/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.entity;

import com.daikit.graphql.meta.GQLAbstractMetaData;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import java.util.ArrayList;
import java.util.List;

public class GQLEntityMetaData
extends GQLAbstractMetaData {
    private boolean readable = true;
    private boolean saveable = true;
    private boolean deletable = true;
    private boolean embedded = false;
    private boolean concrete = true;
    private String name;
    private Class<?> superEntityClass;
    private Class<?> entityClass;
    private List<GQLAbstractAttributeMetaData> attributes = new ArrayList<GQLAbstractAttributeMetaData>();

    public GQLEntityMetaData() {
    }

    public GQLEntityMetaData(String name, Class<?> entityClass) {
        this.name = name;
        this.entityClass = entityClass;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, boolean concrete) {
        this.name = name;
        this.entityClass = entityClass;
        this.concrete = concrete;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, Class<?> superEntityClass) {
        this.name = name;
        this.entityClass = entityClass;
        this.superEntityClass = superEntityClass;
    }

    public GQLEntityMetaData(String name, Class<?> entityClass, Class<?> superEntityClass, boolean concrete) {
        this.name = name;
        this.entityClass = entityClass;
        this.superEntityClass = superEntityClass;
        this.concrete = concrete;
    }

    @Override
    protected void appendToString(StringBuilder stringBuilder) {
        stringBuilder.append(this.concrete ? "" : "[ABS]");
        stringBuilder.append("[").append(this.entityClass == null ? "" : this.entityClass.getSimpleName());
        stringBuilder.append(this.superEntityClass == null ? "" : " EXTENDS " + this.superEntityClass.getSimpleName()).append("]");
        stringBuilder.append("[ATTR=").append(this.attributes.size()).append("])");
    }

    public void addAttribute(GQLAbstractAttributeMetaData attribute) {
        if (attribute != null) {
            this.attributes.add(attribute);
        }
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public GQLEntityMetaData setConcrete(boolean concrete) {
        this.concrete = concrete;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GQLEntityMetaData setName(String name) {
        this.name = name;
        return this;
    }

    public Class<?> getSuperEntityClass() {
        return this.superEntityClass;
    }

    public GQLEntityMetaData setSuperEntityClass(Class<?> superEntityClass) {
        this.superEntityClass = superEntityClass;
        return this;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public GQLEntityMetaData setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public List<GQLAbstractAttributeMetaData> getAttributes() {
        return this.attributes;
    }

    public GQLEntityMetaData setAttributes(List<GQLAbstractAttributeMetaData> attributes) {
        this.attributes = attributes;
        return this;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public GQLEntityMetaData setReadable(boolean readable) {
        this.readable = readable;
        return this;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public GQLEntityMetaData setDeletable(boolean deletable) {
        this.deletable = deletable;
        return this;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public GQLEntityMetaData setSaveable(boolean saveable) {
        this.saveable = saveable;
        return this;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public GQLEntityMetaData setEmbedded(boolean embedded) {
        this.embedded = embedded;
        return this;
    }
}

