/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.constants;

import com.daikit.graphql.utils.Message;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.io.File;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;

public class GQLJavaScalars {
    public static GraphQLScalarType GraphQLLocalDateTime = GraphQLScalarType.newScalar().name("LocalDateTime").description("Date type").coercing((Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object input) {
            if (input == null) {
                return null;
            }
            if (input instanceof String) {
                return this.parseStringToLocalDateTime((String)input);
            }
            if (input instanceof LocalDateTime) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDateTime((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDateTime(((Integer)input).intValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be serialized from LocalDateTime [{}]", input));
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDateTime(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDateTime(value.longValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be parsed to LocalDateTime [{}]", input));
        }

        private LocalDateTime parseLongToLocalDateTime(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId());
        }

        private LocalDateTime parseStringToLocalDateTime(String input) {
            try {
                return LocalDateTime.parse(input);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException(Message.format("Input cannot be parsed to LocalDateTime [{}]", input), e);
            }
        }
    }).build();
    public static GraphQLScalarType GraphQLLocalDate = GraphQLScalarType.newScalar().name("LocalDate").description("Date type").coercing((Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToLocalDate((String)input);
            }
            if (input instanceof LocalDate) {
                return input;
            }
            if (input instanceof Long) {
                return this.parseLongToLocalDate((Long)input);
            }
            if (input instanceof Integer) {
                return this.parseLongToLocalDate(((Integer)input).intValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be serialized from LocalDate [{}]", input));
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToLocalDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return this.parseLongToLocalDate(value.longValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be parsed to LocalDate [{}]", input));
        }

        private LocalDate parseLongToLocalDate(long input) {
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(input), TimeZone.getDefault().toZoneId()).toLocalDate();
        }

        private LocalDate parseStringToLocalDate(String input) {
            try {
                return LocalDate.parse(input);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException(Message.format("Input cannot be parsed to LocalDate [{}]", input), e);
            }
        }
    }).build();
    public static GraphQLScalarType GraphQLDate = GraphQLScalarType.newScalar().name("Date").description("Date type").coercing((Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object input) {
            if (input instanceof String) {
                return this.parseStringToDate((String)input);
            }
            if (input instanceof Date) {
                return input;
            }
            if (input instanceof Long) {
                return new Date((Long)input);
            }
            if (input instanceof Integer) {
                return new Date(((Integer)input).longValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be serialized from Date [{}]", input));
        }

        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return this.parseStringToDate(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                return new Date(value.longValue());
            }
            throw new IllegalArgumentException(Message.format("Input cannot be parsed to Date [{}]", input));
        }

        private Date parseStringToDate(String input) {
            try {
                return input == null ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(input);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(Message.format("Input cannot be parsed to Date [{}]", input), e);
            }
        }
    }).build();
    public static GraphQLScalarType GraphQLFile = GraphQLScalarType.newScalar().name("File").description("File").coercing((Coercing)new Coercing<Object, Object>(){

        public Object serialize(Object input) {
            String serialized;
            if (input == null) {
                serialized = null;
            } else if (input instanceof File) {
                serialized = ((File)input).getName();
            } else {
                throw new IllegalArgumentException(Message.format("Input cannot be serialized from File [{}]", input));
            }
            return serialized;
        }

        public Object parseValue(Object input) {
            Object parsed;
            if (input == null) {
                parsed = null;
            } else if (input instanceof File) {
                parsed = input;
            } else {
                throw new IllegalArgumentException(Message.format("Input cannot be parsed to File [{}]", input));
            }
            return parsed;
        }

        public Object parseLiteral(Object input) {
            throw new IllegalArgumentException(Message.format("Input cannot be parsed to File [{}]", input));
        }
    }).build();
}

