/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.datafetcher;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.custommethod.IGQLAbstractCustomMethod;
import com.daikit.graphql.custommethod.IGQLCustomMethod0Arg;
import com.daikit.graphql.custommethod.IGQLCustomMethod1Arg;
import com.daikit.graphql.custommethod.IGQLCustomMethod2Arg;
import com.daikit.graphql.custommethod.IGQLCustomMethod3Arg;
import com.daikit.graphql.custommethod.IGQLCustomMethod4Arg;
import com.daikit.graphql.custommethod.IGQLCustomMethod5Arg;
import com.daikit.graphql.datafetcher.GQLAbstractDataFetcher;
import com.daikit.graphql.utils.Message;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.GraphQLException;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GQLCustomMethodDataFetcher
extends GQLAbstractDataFetcher<Object> {
    private final Map<String, IGQLAbstractCustomMethod<?>> allMethods = new HashMap();
    private ObjectMapper objectMapper = new ObjectMapper();

    public void registerCustomMethods(List<? extends IGQLAbstractCustomMethod<?>> customMethods) {
        customMethods.stream().forEach(customMethod -> {
            IGQLAbstractCustomMethod<?> existing = this.allMethods.get(customMethod.getMethodName());
            if (existing != null && !existing.equals(customMethod)) {
                throw new GraphQLException(Message.format("Duplicate custom methods registered with name {}.", customMethod.getMethodName()));
            }
            this.allMethods.put(customMethod.getMethodName(), (IGQLAbstractCustomMethod<?>)customMethod);
        });
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        Object ret;
        IGQLAbstractCustomMethod<?> method = this.allMethods.get(environment.getField().getName());
        if (method instanceof IGQLCustomMethod0Arg) {
            ret = ((IGQLCustomMethod0Arg)method).apply();
        } else if (method instanceof IGQLCustomMethod1Arg) {
            ret = ((IGQLCustomMethod1Arg)method).apply(this.getArgumentValue(environment, method, 0));
        } else if (method instanceof IGQLCustomMethod2Arg) {
            ret = ((IGQLCustomMethod2Arg)method).apply(this.getArgumentValue(environment, method, 0), this.getArgumentValue(environment, method, 1));
        } else if (method instanceof IGQLCustomMethod3Arg) {
            ret = ((IGQLCustomMethod3Arg)method).apply(this.getArgumentValue(environment, method, 0), this.getArgumentValue(environment, method, 1), this.getArgumentValue(environment, method, 2));
        } else if (method instanceof IGQLCustomMethod4Arg) {
            ret = ((IGQLCustomMethod4Arg)method).apply(this.getArgumentValue(environment, method, 0), this.getArgumentValue(environment, method, 1), this.getArgumentValue(environment, method, 2), this.getArgumentValue(environment, method, 3));
        } else if (method instanceof IGQLCustomMethod5Arg) {
            ret = ((IGQLCustomMethod5Arg)method).apply(this.getArgumentValue(environment, method, 0), this.getArgumentValue(environment, method, 1), this.getArgumentValue(environment, method, 2), this.getArgumentValue(environment, method, 3), this.getArgumentValue(environment, method, 4));
        } else {
            throw new GraphQLException(Message.format("Unsupported custom method type [{}]", method.getClass().getName()));
        }
        return ret;
    }

    protected <T> T getArgumentValue(DataFetchingEnvironment environment, IGQLAbstractCustomMethod<?> method, int argumentPosition) {
        Field queryField = environment.getField();
        String argumentName = method.getArgumentNames().get(argumentPosition);
        Object argumentGraphQLValue = this.getArgumentValue(queryField, argumentName, environment.getArguments());
        Type expectedType = method.getArgumentTypes().get(argumentPosition);
        Object mappedValue = argumentGraphQLValue;
        if (mappedValue != null && mappedValue instanceof Map) {
            Class expectedClass = GenericsUtils.getTypeClass((Type)expectedType);
            mappedValue = this.convertValue((Map)mappedValue, expectedClass, argumentPosition);
        }
        return (T)mappedValue;
    }

    protected Object convertValue(Map<String, Object> argumentPropertyValues, Class<?> argumentType, int argumentPosition) {
        return this.getObjectMapper().convertValue(argumentPropertyValues, argumentType);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

