/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta;

import com.daikit.graphql.custommethod.GQLAbstractCustomMethod;
import com.daikit.graphql.dynamicattribute.IGQLAbstractDynamicAttribute;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeGetter;
import com.daikit.graphql.dynamicattribute.IGQLDynamicAttributeSetter;
import com.daikit.graphql.exception.GQLException;
import com.daikit.graphql.meta.attribute.GQLAbstractAttributeMetaData;
import com.daikit.graphql.meta.builder.GQLDynamicAttributeMetaDataBuilder;
import com.daikit.graphql.meta.builder.GQLMethodMetaDataBuilder;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.meta.internal.GQLAbstractEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLConcreteEntityMetaDataInfos;
import com.daikit.graphql.meta.internal.GQLInterfaceEntityMetaDataInfos;
import com.daikit.graphql.utils.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GQLMetaModel {
    private final List<GQLEnumMetaData> enums = new ArrayList<GQLEnumMetaData>();
    private final List<GQLInterfaceEntityMetaDataInfos> interfaces = new ArrayList<GQLInterfaceEntityMetaDataInfos>();
    private final List<GQLConcreteEntityMetaDataInfos> concretes = new ArrayList<GQLConcreteEntityMetaDataInfos>();
    private final List<GQLAbstractMethodMetaData> customMethods = new ArrayList<GQLAbstractMethodMetaData>();

    public GQLMetaModel(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, Collection<IGQLAbstractDynamicAttribute<?>> dynamicAttributes, Collection<GQLAbstractCustomMethod<?>> customMethods) {
        GQLDynamicAttributeMetaDataBuilder dynamicAttributeMetaDataBuilder = new GQLDynamicAttributeMetaDataBuilder();
        GQLMethodMetaDataBuilder methodMetaDataBuilder = new GQLMethodMetaDataBuilder();
        Collection dynamicAttributeMetaDatas = dynamicAttributes.stream().map(attribute -> dynamicAttributeMetaDataBuilder.build(enumMetaDatas, entityMetaDatas, (IGQLAbstractDynamicAttribute<?>)attribute)).collect(Collectors.toList());
        Collection methodMetaDatas = customMethods.stream().map(customMethod -> methodMetaDataBuilder.build(enumMetaDatas, entityMetaDatas, (GQLAbstractCustomMethod<?>)customMethod)).collect(Collectors.toList());
        this.registerDynamicAttributes(entityMetaDatas, dynamicAttributeMetaDatas);
        this.initialize(enumMetaDatas, entityMetaDatas, methodMetaDatas);
    }

    public GQLMetaModel(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, Collection<GQLAbstractMethodMetaData> methodMetaDatas) {
        this.initialize(enumMetaDatas, entityMetaDatas, methodMetaDatas);
    }

    private void registerDynamicAttributes(Collection<GQLEntityMetaData> entityMetaDatas, Collection<GQLAbstractAttributeMetaData> dynamicAttributes) {
        for (GQLAbstractAttributeMetaData dynamicAttribute : dynamicAttributes) {
            Class<?> entityType = dynamicAttribute.isDynamicAttributeGetter() ? dynamicAttribute.getDynamicAttributeGetter().getEntityType() : dynamicAttribute.getDynamicAttributeSetter().getEntityType();
            Optional<GQLEntityMetaData> entityMetaData = entityMetaDatas.stream().filter(metaData -> metaData.getEntityClass().isAssignableFrom(entityType)).findFirst();
            if (!entityMetaData.isPresent()) {
                throw new GQLException(Message.format("No entity meta data registered for dynamic attribute [{}] entity class [{}]", dynamicAttribute.getName(), entityType.getSimpleName()));
            }
            entityMetaData.get().addAttribute(dynamicAttribute);
        }
    }

    private void initialize(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, Collection<GQLAbstractMethodMetaData> methodMetaDatas) {
        Comparator<GQLEnumMetaData> enumComparator = new Comparator<GQLEnumMetaData>(){

            @Override
            public int compare(GQLEnumMetaData o1, GQLEnumMetaData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Comparator<GQLAbstractEntityMetaDataInfos> infosComparator = new Comparator<GQLAbstractEntityMetaDataInfos>(){

            @Override
            public int compare(GQLAbstractEntityMetaDataInfos o1, GQLAbstractEntityMetaDataInfos o2) {
                return o1.getEntity().getName().compareTo(o2.getEntity().getName());
            }
        };
        this.getEnums().addAll(enumMetaDatas);
        Collections.sort(this.getEnums(), enumComparator);
        for (GQLEntityMetaData entityMetaData : entityMetaDatas) {
            GQLAbstractEntityMetaDataInfos infos2;
            if (entityMetaData.isConcrete()) {
                infos2 = new GQLConcreteEntityMetaDataInfos(entityMetaData);
                this.getAllConcretes().add((GQLConcreteEntityMetaDataInfos)infos2);
                continue;
            }
            infos2 = new GQLInterfaceEntityMetaDataInfos(entityMetaData);
            this.getAllInterfaces().add((GQLInterfaceEntityMetaDataInfos)infos2);
        }
        Collections.sort(this.getAllConcretes(), infosComparator);
        Collections.sort(this.getAllInterfaces(), infosComparator);
        this.getAllEntities().forEach(infosToUpdate -> infosToUpdate.setSuperEntity(this.getAllEntities().stream().filter(infos -> infos.getEntity().getEntityClass().equals(infosToUpdate.getEntity().getSuperEntityClass())).findFirst().orElse(null)));
        this.getAllEntities().forEach(infos -> this.buildAndSetSuperInterfaces(this.getAllInterfaces(), (GQLAbstractEntityMetaDataInfos)infos));
        this.getNonEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities(this.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        this.getEmbeddedInterfaces().forEach(infos -> this.setConcreteSubEntities(this.getAllConcretes(), (GQLInterfaceEntityMetaDataInfos)infos));
        this.getCustomMethods().addAll(methodMetaDatas);
    }

    private void buildAndSetSuperInterfaces(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        this.getSuperInterfaceInfos(allInterfaces, infos).ifPresent(superInterface -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superInterface, infos));
    }

    private Optional<GQLInterfaceEntityMetaDataInfos> getSuperInterfaceInfos(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos infos) {
        return allInterfaces.stream().filter(potential -> potential.equals(infos.getSuperEntity())).findFirst();
    }

    private void setSuperInterfaceInfos(List<GQLInterfaceEntityMetaDataInfos> allInterfaces, GQLAbstractEntityMetaDataInfos superInterfaceInfos, GQLAbstractEntityMetaDataInfos infos) {
        infos.getSuperInterfaces().add(superInterfaceInfos);
        this.getSuperInterfaceInfos(allInterfaces, superInterfaceInfos).ifPresent(superSuperInterfaceInfos -> this.setSuperInterfaceInfos(allInterfaces, (GQLAbstractEntityMetaDataInfos)superSuperInterfaceInfos, infos));
    }

    private void setConcreteSubEntities(List<GQLConcreteEntityMetaDataInfos> concretes, GQLInterfaceEntityMetaDataInfos infos) {
        infos.getConcreteSubEntities().addAll(concretes.stream().filter(concrete -> concrete.getSuperInterfaces().contains(infos)).collect(Collectors.toList()));
    }

    public <ENTITY_CLASS> Class<? extends ENTITY_CLASS> getEntityClassByEntityName(String entityName) {
        Optional<GQLAbstractEntityMetaDataInfos> entityMetaDataOptional = this.getAllEntities().stream().filter(metaDataInfos -> metaDataInfos.getEntity().getName().equals(entityName)).findFirst();
        if (!entityMetaDataOptional.isPresent()) {
            throw new GQLException(Message.format("Not entity exists for name [{}]", entityName));
        }
        return entityMetaDataOptional.get().getEntity().getEntityClass();
    }

    public List<IGQLDynamicAttributeSetter<?, ?>> getDynamicAttributeSetters() {
        return this.concretes.stream().flatMap(entityMetaData -> entityMetaData.getEntity().getAttributes().stream().filter(attribute -> attribute.isDynamicAttributeSetter()).map(attribute -> attribute.getDynamicAttributeSetter())).collect(Collectors.toList());
    }

    public List<IGQLDynamicAttributeGetter<?, ?>> getDynamicAttributeGetters() {
        return this.concretes.stream().flatMap(entityMetaData -> entityMetaData.getEntity().getAttributes().stream().filter(attribute -> attribute.isDynamicAttributeGetter()).map(attribute -> attribute.getDynamicAttributeGetter())).collect(Collectors.toList());
    }

    public List<GQLEnumMetaData> getEnums() {
        return this.enums;
    }

    public List<GQLInterfaceEntityMetaDataInfos> getNonEmbeddedInterfaces() {
        return this.interfaces.stream().filter(infos -> !infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLConcreteEntityMetaDataInfos> getNonEmbeddedConcretes() {
        return this.concretes.stream().filter(infos -> !infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLInterfaceEntityMetaDataInfos> getEmbeddedInterfaces() {
        return this.interfaces.stream().filter(infos -> infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLConcreteEntityMetaDataInfos> getEmbeddedConcretes() {
        return this.concretes.stream().filter(infos -> infos.getEntity().isEmbedded()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllEntities() {
        return Stream.concat(this.interfaces.stream(), this.concretes.stream()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllEmbeddedEntities() {
        return Stream.concat(this.getEmbeddedInterfaces().stream(), this.getEmbeddedConcretes().stream()).collect(Collectors.toList());
    }

    public List<GQLAbstractEntityMetaDataInfos> getAllNonEmbeddedEntities() {
        return Stream.concat(this.getNonEmbeddedInterfaces().stream(), this.getNonEmbeddedConcretes().stream()).collect(Collectors.toList());
    }

    public List<GQLInterfaceEntityMetaDataInfos> getAllInterfaces() {
        return this.interfaces;
    }

    public List<GQLConcreteEntityMetaDataInfos> getAllConcretes() {
        return this.concretes;
    }

    public List<GQLAbstractMethodMetaData> getCustomMethods() {
        return this.customMethods;
    }
}

