/*
 * Decompiled with CFR 0.152.
 */
package com.daikit.graphql.meta.builder;

import com.daikit.generics.utils.GenericsUtils;
import com.daikit.graphql.custommethod.GQLAbstractCustomMethod;
import com.daikit.graphql.meta.builder.GQLAbstractMetaDataBuilder;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodArgumentMetaData;
import com.daikit.graphql.meta.custommethod.GQLAbstractMethodMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodArgumentScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEntityMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListEnumMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodListScalarMetaData;
import com.daikit.graphql.meta.custommethod.GQLMethodScalarMetaData;
import com.daikit.graphql.meta.entity.GQLEntityMetaData;
import com.daikit.graphql.meta.entity.GQLEnumMetaData;
import com.daikit.graphql.utils.GQLScalarUtils;
import com.daikit.graphql.utils.Message;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GQLMethodMetaDataBuilder
extends GQLAbstractMetaDataBuilder {
    public GQLAbstractMethodMetaData build(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLAbstractCustomMethod<?> customMethod) {
        ArrayList<GQLAbstractMethodArgumentMetaData> arguments = new ArrayList<GQLAbstractMethodArgumentMetaData>();
        for (int i = 0; i < customMethod.getArgumentTypes().size(); ++i) {
            arguments.add(this.createMethodArgument(enumMetaDatas, entityMetaDatas, customMethod, customMethod.getArgumentName(i), customMethod.getArgumentType(i)));
        }
        return this.createMethod(enumMetaDatas, entityMetaDatas, customMethod, arguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GQLAbstractMethodMetaData createMethod(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLAbstractCustomMethod<?> customMethod, List<GQLAbstractMethodArgumentMetaData> arguments) {
        GQLAbstractMethodMetaData methodMetaData;
        Class outputRawClass = GenericsUtils.getTypeClass((Type)customMethod.getOutputType());
        if (GQLScalarUtils.isScalarType(outputRawClass)) {
            methodMetaData = new GQLMethodScalarMetaData();
            ((GQLMethodScalarMetaData)methodMetaData).setScalarType(GQLScalarUtils.getScalarTypeFromClass(outputRawClass).get());
        } else if (this.isEnum(enumMetaDatas, outputRawClass)) {
            methodMetaData = new GQLMethodEnumMetaData();
            ((GQLMethodEnumMetaData)methodMetaData).setEnumClass(outputRawClass);
        } else if (this.isEntity(entityMetaDatas, outputRawClass)) {
            methodMetaData = new GQLMethodEntityMetaData();
            ((GQLMethodEntityMetaData)methodMetaData).setEntityClass(outputRawClass);
        } else {
            if (!Collection.class.isAssignableFrom(outputRawClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] output type [{}].", customMethod.getMethodName(), outputRawClass.getSimpleName()));
            Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)customMethod.getOutputType(), Collection.class).get(0);
            if (GQLScalarUtils.isScalarType(foreignClass)) {
                methodMetaData = new GQLMethodListScalarMetaData();
                ((GQLMethodListScalarMetaData)methodMetaData).setScalarType(GQLScalarUtils.getScalarTypeFromClass(foreignClass).get());
            } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                methodMetaData = new GQLMethodListEnumMetaData();
                ((GQLMethodListEnumMetaData)methodMetaData).setEnumClass(foreignClass);
            } else {
                if (!this.isEntity(entityMetaDatas, foreignClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] output collection type [{}].", customMethod.getMethodName(), outputRawClass.getName()));
                methodMetaData = new GQLMethodListEntityMetaData();
                ((GQLMethodListEntityMetaData)methodMetaData).setForeignClass(foreignClass);
            }
        }
        methodMetaData.getArguments().addAll(arguments);
        methodMetaData.setMethod(customMethod);
        return methodMetaData;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GQLAbstractMethodArgumentMetaData createMethodArgument(Collection<GQLEnumMetaData> enumMetaDatas, Collection<GQLEntityMetaData> entityMetaDatas, GQLAbstractCustomMethod<?> customMethod, String argumentName, Type argumentType) {
        void var6_14;
        Class argumentRawClass = GenericsUtils.getTypeClass((Type)argumentType);
        if (GQLScalarUtils.isScalarType(argumentRawClass)) {
            GQLMethodArgumentScalarMetaData gQLMethodArgumentScalarMetaData = new GQLMethodArgumentScalarMetaData();
            gQLMethodArgumentScalarMetaData.setScalarType(GQLScalarUtils.getScalarTypeFromClass(argumentRawClass).get());
        } else if (this.isEnum(enumMetaDatas, argumentRawClass)) {
            GQLMethodArgumentEnumMetaData gQLMethodArgumentEnumMetaData = new GQLMethodArgumentEnumMetaData();
            gQLMethodArgumentEnumMetaData.setEnumClass(argumentRawClass);
        } else if (this.isEntity(entityMetaDatas, argumentRawClass)) {
            GQLMethodArgumentEntityMetaData gQLMethodArgumentEntityMetaData = new GQLMethodArgumentEntityMetaData();
            gQLMethodArgumentEntityMetaData.setEntityClass(argumentRawClass);
        } else {
            if (!Collection.class.isAssignableFrom(argumentRawClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] argument [{}] type [{}].", customMethod.getMethodName(), argumentName, argumentRawClass.getName()));
            Class foreignClass = (Class)GenericsUtils.getTypeArgumentsAsClasses((Type)argumentType, Collection.class).get(0);
            if (GQLScalarUtils.isScalarType(foreignClass)) {
                GQLMethodArgumentListScalarMetaData gQLMethodArgumentListScalarMetaData = new GQLMethodArgumentListScalarMetaData();
                gQLMethodArgumentListScalarMetaData.setScalarType(GQLScalarUtils.getScalarTypeFromClass(foreignClass).get());
            } else if (this.isEnum(enumMetaDatas, foreignClass)) {
                GQLMethodArgumentListEnumMetaData gQLMethodArgumentListEnumMetaData = new GQLMethodArgumentListEnumMetaData();
                gQLMethodArgumentListEnumMetaData.setEnumClass(foreignClass);
            } else {
                if (!this.isEntity(entityMetaDatas, foreignClass)) throw new IllegalArgumentException(Message.format("Not handled method [{}] argument [{}] collection type [{}].", customMethod.getMethodName(), argumentName, foreignClass.getName()));
                GQLMethodArgumentListEntityMetaData gQLMethodArgumentListEntityMetaData = new GQLMethodArgumentListEntityMetaData();
                gQLMethodArgumentListEntityMetaData.setForeignClass(foreignClass);
            }
        }
        var6_14.setName(argumentName);
        return var6_14;
    }
}

