/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen;

import com.daml.lf.archive.Dar;
import com.daml.lf.codegen.CodeGenRunner$ArchiveReader$;
import com.daml.lf.codegen.InterfaceTree;
import com.daml.lf.codegen.InterfaceTrees;
import com.daml.lf.codegen.NodeWithContext;
import com.daml.lf.codegen.backend.Backend;
import com.daml.lf.codegen.backend.java.JavaBackend$;
import com.daml.lf.codegen.conf.Conf;
import com.daml.lf.data.ImmArray;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.DefTemplate;
import com.daml.lf.iface.Interface;
import com.daml.lf.iface.Type;
import com.daml.lf.iface.reader.Errors;
import com.daml.lf.iface.reader.Errors$;
import com.daml.lf.iface.reader.InterfaceReader;
import com.daml.lf.iface.reader.InterfaceReader$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class CodeGenRunner$
implements StrictLogging {
    public static CodeGenRunner$ MODULE$;
    private final Backend backend;
    private final Logger logger;

    static {
        new CodeGenRunner$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void run(Conf conf) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(conf.verbosity());
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"com.daml.lf.codegen.backend.java.inner")).setLevel(conf.verbosity());
        conf.darFiles().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CodeGenRunner$.$anonfun$run$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.checkAndCreateOutputDir(conf.outputDirectory());
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
            private final AtomicInteger n;

            private AtomicInteger n() {
                return this.n;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(new StringBuilder(13).append("java-codegen-").append(this.n().getAndIncrement()).toString());
                return var2_2;
            }
            {
                this.n = new AtomicInteger(0);
            }
        });
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
        Tuple2<Seq<Interface>, Map<String, String>> tuple2 = this.collectDamlLfInterfaces(conf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq interfaces = (Seq)tuple2._1();
        Map pkgPrefixes = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)interfaces, (Object)pkgPrefixes);
        Tuple2 tuple23 = tuple22;
        Seq interfaces2 = (Seq)tuple23._1();
        Map pkgPrefixes2 = (Map)tuple23._2();
        this.generateCode((Seq<Interface>)interfaces2, conf, (Map<String, String>)pkgPrefixes2, (ExecutionContext)ec);
        java.util.List<Runnable> list = executor.shutdownNow();
    }

    public Tuple2<Seq<Interface>, Map<String, String>> collectDamlLfInterfaces(Conf conf) {
        List interfacesAndPrefixes = (List)conf.darFiles().toList().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Option pkgPrefix = (Option)tuple2._2();
            File file = path.toFile();
            Dar dar = (Dar)CodeGenRunner$ArchiveReader$.MODULE$.readArchiveFromFile(file).get();
            List list = (List)dar.all().map((Function1 & Serializable & scala.Serializable)archive -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = InterfaceReader$.MODULE$.readInterface(archive);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Errors errors = (Errors)tuple2._1();
                Interface interface_ = (Interface)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)errors, (Object)interface_);
                Tuple2 tuple23 = tuple22;
                Errors errors2 = (Errors)tuple23._1();
                interface = (Interface)tuple23._2();
                if (!errors2.equals((Object)Errors$.MODULE$.zeroErrors())) {
                    throw new RuntimeException(InterfaceReader.InterfaceReaderError$.MODULE$.treeReport(errors2).toString());
                }
                if (MODULE$.logger().underlying().isTraceEnabled()) {
                    MODULE$.logger().underlying().trace("DAML-LF Archive decoded, packageId '{}'", new Object[]{interface.packageId()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)interface, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)interface.packageId()), (Object)pkgPrefix));
            }, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom());
        List interfaces = (List)interfacesAndPrefixes.map((Function1 & Serializable & scala.Serializable)x$3 -> (Interface)x$3._1(), List$.MODULE$.canBuildFrom());
        Map prefixes = ((TraversableOnce)interfacesAndPrefixes.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Interface, Tuple2<String, Option<String>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Tuple2 tuple2;
                A1 A1 = x1;
                if (A1 != null && (tuple2 = (Tuple2)A1._2()) != null) {
                    String key = (String)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String value = (String)some.value();
                        object = new Tuple2((Object)key, (Object)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Interface, Tuple2<String, Option<String>>> x1) {
                Option option;
                Tuple2 tuple2;
                Tuple2<Interface, Tuple2<String, Option<String>>> tuple22 = x1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)interfaces, (Object)prefixes);
    }

    public void generateFile(Path outputFile, ImmArray<DefDataType<Type, Type>> dataTypes, ImmArray<DefTemplate<Type>> templates) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Started writing file '{}' with data types {} and templates {}", new Object[]{outputFile, dataTypes.toString(), templates.toString()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Path _ = Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        if (!Files.exists(outputFile, new LinkOption[0])) {
            Path _2 = Files.createFile(outputFile, new FileAttribute[0]);
        }
        OutputStream os = Files.newOutputStream(outputFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        os.close();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Finish writing file '{}'", new Object[]{outputFile});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void generateCode(Seq<Interface> interfaces, Conf conf, Map<String, String> pkgPrefixes, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Start processing packageIds '{}' in directory '{}'", new Object[]{((TraversableOnce)interfaces.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.packageId(), Seq$.MODULE$.canBuildFrom())).mkString(", "), conf.outputDirectory()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Future<InterfaceTrees> preprocessingFuture = this.backend().preprocess(interfaces, conf, pkgPrefixes, ec);
        Future future = preprocessingFuture.flatMap((Function1 & Serializable & scala.Serializable)preprocessedInterfaceTrees -> Future$.MODULE$.traverse(preprocessedInterfaceTrees.interfaceTrees(), (Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.processInterfaceTree((InterfaceTree)x$5, conf, pkgPrefixes, ec), List$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)_ -> {
            CodeGenRunner$.$anonfun$generateCode$4(_);
            return BoxedUnit.UNIT;
        }, ec), ec);
        BoxedUnit _ = (BoxedUnit)Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.create(10L, TimeUnit.MINUTES));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Finish processing packageIds ''{}''", new Object[]{((TraversableOnce)interfaces.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.packageId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Backend backend() {
        return this.backend;
    }

    public Future<BoxedUnit> processInterfaceTree(InterfaceTree interfaceTree, Conf conf, Map<String, String> packagePrefixes, ExecutionContext ec) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Start processing packageId '{}'", new Object[]{interfaceTree.interface().packageId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return interfaceTree.process((Function1<NodeWithContext, Future<BoxedUnit>>)(Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.backend().process((NodeWithContext)x$7, conf, packagePrefixes, ec), ec).map((Function1 & Serializable & scala.Serializable)_ -> {
            CodeGenRunner$.$anonfun$processInterfaceTree$2(interfaceTree, _);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public void assertInputFileExists(Path filePath) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Checking that the file '{}' exists", new Object[]{filePath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Input file '").append(filePath).append("' doesn't exist").toString());
        }
    }

    public void assertInputFileIsReadable(Path filePath) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Checking that the file '{}' is readable", new Object[]{filePath});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!Files.isReadable(filePath)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Input file '").append(filePath).append("' is not readable").toString());
        }
    }

    public void checkAndCreateOutputDir(Path outputPath) {
        boolean exists = Files.exists(outputPath, new LinkOption[0]);
        if (!exists) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Output directory '{}' does not exists, creating it", new Object[]{outputPath});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Path path = Files.createDirectories(outputPath, new FileAttribute[0]);
        } else if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Output directory '").append(outputPath).append("' exists but it is not a directory").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$run$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        MODULE$.assertInputFileExists(path);
        MODULE$.assertInputFileIsReadable(path);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$generateCode$4(List _) {
    }

    public static final /* synthetic */ void $anonfun$processInterfaceTree$2(InterfaceTree interfaceTree$1, BoxedUnit _) {
        BoxedUnit boxedUnit;
        if (MODULE$.logger().underlying().isInfoEnabled()) {
            MODULE$.logger().underlying().info("Stop processing packageId '{}'", new Object[]{interfaceTree$1.interface().packageId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private CodeGenRunner$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.backend = JavaBackend$.MODULE$;
    }
}

