/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.lf.codegen.TypeWithContext;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.ToValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.TrackLineage$;
import com.daml.lf.codegen.backend.java.inner.VariantConstructorClass$;
import com.daml.lf.codegen.backend.java.inner.VariantRecordClass$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.iface.DataType;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.Enum;
import com.daml.lf.iface.InterfaceType;
import com.daml.lf.iface.Record;
import com.daml.lf.iface.Type;
import com.daml.lf.iface.TypeCon;
import com.daml.lf.iface.TypeConName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariantClass$
implements StrictLogging {
    public static VariantClass$ MODULE$;
    private final Logger logger;

    static {
        new VariantClass$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Tuple2<TypeSpec, List<TypeSpec>> generate(ClassName variantClassName, String subPackage, IndexedSeq<String> typeArguments, com.daml.lf.iface.Variant<Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes) {
        return (Tuple2)TrackLineage$.MODULE$.of("variant", typeWithContext.name(), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Start");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            IndexedSeq<FieldInfo> constructorInfo = package$.MODULE$.getFieldsWithTypes((IndexedSeq<Tuple2<String, Type>>)variant.fields(), packagePrefixes);
            TypeSpec variantType = TypeSpec.classBuilder((ClassName)variantClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addTypeVariables((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)typeArguments.map((Function1 & Serializable & scala.Serializable)x$1 -> TypeVariableName.get((String)x$1), IndexedSeq$.MODULE$.canBuildFrom())).asJava()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).build()).addMethod(MODULE$.generateAbstractToValueSpec(typeArguments)).addMethod(MODULE$.generateFromValue(typeArguments, constructorInfo, variantClassName, subPackage)).build();
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("End");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            List<TypeSpec> constructors = MODULE$.generateConstructorClasses(typeArguments, variant, typeWithContext, packagePrefixes, variantClassName);
            return new Tuple2((Object)variantType, constructors);
        });
    }

    private boolean isRecord(InterfaceType interfaceType) {
        boolean bl;
        DataType dataType = interfaceType.type().dataType();
        if (dataType instanceof Record) {
            bl = true;
        } else {
            boolean bl2 = dataType instanceof com.daml.lf.iface.Variant ? true : dataType instanceof Enum;
            if (bl2) {
                bl = false;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVariantRecord(TypeWithContext typeWithContext, String constructor, Ref.Identifier identifier) {
        if (!typeWithContext.interface().typeDecls().get((Object)identifier.qualifiedName()).exists((Function1 & Serializable & scala.Serializable)interfaceType -> BoxesRunTime.boxToBoolean((boolean)VariantClass$.MODULE$.isRecord(interfaceType)))) return false;
        Ref.DottedName dottedName = typeWithContext.identifier().qualifiedName().module();
        Ref.DottedName dottedName2 = identifier.qualifiedName().module();
        if (dottedName == null) {
            if (dottedName2 != null) {
                return false;
            }
        } else if (!dottedName.equals(dottedName2)) return false;
        ImmArray immArray = typeWithContext.identifier().qualifiedName().name().segments();
        ImmArray immArray2 = identifier.qualifiedName().name().segments().init();
        if (immArray == null) {
            if (immArray2 != null) {
                return false;
            }
        } else if (!immArray.equals(immArray2)) return false;
        String string = constructor;
        Object object = identifier.qualifiedName().name().segments().last();
        if (string == null) {
            if (object == null) return true;
            return false;
        } else {
            if (!string.equals(object)) return false;
            return true;
        }
    }

    private MethodSpec generateAbstractToValueSpec(IndexedSeq<String> typeArgs) {
        return MethodSpec.methodBuilder((String)"toValue").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameters((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(ToValueExtractorParameters$.MODULE$.generate(typeArgs)).asJava()).returns(Value.class).build();
    }

    private MethodSpec.Builder initFromValueBuilder(TypeName t) {
        return MethodSpec.methodBuilder((String)"fromValue").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).returns(t).addParameter(Value.class, "value$", new Modifier[0]);
    }

    private CodeBlock variantExtractor(TypeName t) {
        return CodeBlock.of((String)"$T variant$$ = value$$.asVariant().orElseThrow(() -> new IllegalArgumentException($S))", (Object[])new Object[]{Variant.class, new StringBuilder(53).append("Expected Variant to build an instance of the Variant ").append(t).toString()});
    }

    private MethodSpec.Builder switchOnConstructor(MethodSpec.Builder builder, IndexedSeq<FieldInfo> constructors, ClassName variant, String subPackage, Function1<String, CodeBlock> useConstructor) {
        BoxedUnit boxedUnit;
        String constructorsAsString = ((TraversableOnce)constructors.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.damlName(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating switch on constructors {} for {}", new Object[]{constructorsAsString, variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        constructors.foreach((Function1 & Serializable & scala.Serializable)constructorInfo -> builder.beginControlFlow("if ($S.equals(variant$$.getConstructor()))", new Object[]{constructorInfo.damlName()}).addStatement((CodeBlock)useConstructor.apply((Object)new .colon.colon((Object)subPackage, (List)new .colon.colon((Object)constructorInfo.javaName(), (List)Nil$.MODULE$)).mkString("."))).endControlFlow());
        return builder.addStatement("throw new IllegalArgumentException($S)", new Object[]{new StringBuilder(82).append("Found unknown constructor variant$.getConstructor() for variant ").append(variant).append(", expected one of ").append(constructorsAsString).toString()});
    }

    private MethodSpec generateParameterizedFromValue(ParameterizedTypeName variant, IndexedSeq<FieldInfo> constructors, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", new Object[]{variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(variant.typeArguments).asScala()).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VariantClass$.$anonfun$generateParameterizedFromValue$1(x$2))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("All type arguments of ").append(variant$2.rawType).append(" must be generic").toString());
        MethodSpec.Builder builder = this.initFromValueBuilder((TypeName)variant);
        FromValueExtractorParameters typeVariablesExtractorParameters = FromValueExtractorParameters$.MODULE$.generate((IndexedSeq<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(variant.typeArguments).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Buffer$.MODULE$.canBuildFrom())).toIndexedSeq());
        builder.addTypeVariables((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(typeVariablesExtractorParameters.typeVariables()).asJava());
        builder.addParameters((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(typeVariablesExtractorParameters.parameterSpecs()).asJava());
        builder.addStatement("$L", new Object[]{this.variantExtractor((TypeName)variant.rawType)});
        CodeBlock extractors = CodeBlock.join((Iterable)((Iterable)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(variant.typeArguments).asScala()).map((Function1 & Serializable & scala.Serializable)t -> CodeBlock.of((String)"$L", (Object[])new Object[]{new StringBuilder(9).append("fromValue").append(t).toString()}), Buffer$.MODULE$.canBuildFrom())).asJava()), (String)", ");
        this.switchOnConstructor(builder, constructors, variant.rawType, subPackage, (Function1<String, CodeBlock>)(Function1 & Serializable & scala.Serializable)constructor -> CodeBlock.of((String)"return $L.fromValue(variant$$, $L)", (Object[])new Object[]{constructor, extractors}));
        return builder.build();
    }

    private MethodSpec generateConcreteFromValue(ClassName t, IndexedSeq<FieldInfo> constructors, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", new Object[]{t});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MethodSpec.Builder builder = this.initFromValueBuilder((TypeName)t).addStatement("$L", new Object[]{this.variantExtractor((TypeName)t)});
        this.switchOnConstructor(builder, constructors, t, subPackage, (Function1<String, CodeBlock>)(Function1 & Serializable & scala.Serializable)c -> CodeBlock.of((String)"return $L.fromValue(variant$$)", (Object[])new Object[]{c}));
        return builder.build();
    }

    private MethodSpec generateFromValue(IndexedSeq<String> typeArguments, IndexedSeq<FieldInfo> constructorInfo, ClassName variantClassName, String subPackage) {
        MethodSpec methodSpec;
        TypeName typeName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArguments);
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            methodSpec = this.generateConcreteFromValue(className, constructorInfo, subPackage);
        } else if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            methodSpec = this.generateParameterizedFromValue(parameterizedTypeName, constructorInfo, subPackage);
        } else {
            throw new IllegalArgumentException("Required either ClassName or ParameterizedTypeName");
        }
        return methodSpec;
    }

    private List<TypeSpec> generateConstructorClasses(IndexedSeq<String> typeArgs, com.daml.lf.iface.Variant<Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes, ClassName variantClassName) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating inner classes");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuffer innerClasses = new ArrayBuffer();
        HashSet variantRecords = new HashSet();
        TypeName fullVariantClassName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArgs);
        package$.MODULE$.getFieldsWithTypes((IndexedSeq<Tuple2<String, Type>>)variant.fields(), packagePrefixes).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)VariantClass$.$anonfun$generateConstructorClasses$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Object object;
            FieldInfo fieldInfo = x$4;
            if (fieldInfo != null) {
                Ref.Identifier id;
                TypeCon typeCon;
                TypeConName typeConName;
                String damlName = fieldInfo.damlName();
                Type damlType = fieldInfo.damlType();
                String javaName = fieldInfo.javaName();
                Type type = damlType;
                if (type instanceof TypeCon && (typeConName = (typeCon = (TypeCon)type).name()) != null && MODULE$.isVariantRecord(typeWithContext, damlName, id = typeConName.identifier())) {
                    object = BoxesRunTime.boxToBoolean((boolean)variantRecords.add((Object)damlName));
                } else {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        MODULE$.logger().underlying().debug("{} is trivial", new Object[]{damlName});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = innerClasses.$plus$eq((Object)VariantConstructorClass$.MODULE$.generate(fullVariantClassName, typeArgs, damlName, javaName, damlType, packagePrefixes));
                }
            } else {
                throw new MatchError((Object)fieldInfo);
            }
            ArrayBuffer arrayBuffer = object;
            return arrayBuffer;
        });
        typeWithContext.typesLineages().map((Function1 & Serializable & scala.Serializable)child -> {
            BoxedUnit boxedUnit;
            block10: {
                block7: {
                    DataType record;
                    ImmArray.ImmArraySeq typeVars;
                    block9: {
                        block8: {
                            InterfaceType.Normal normal;
                            DefDataType defDataType;
                            Some some;
                            InterfaceType interfaceType;
                            BoxedUnit boxedUnit2;
                            if (!variantRecords.contains((Object)child.name())) break block7;
                            if (MODULE$.logger().underlying().isDebugEnabled()) {
                                MODULE$.logger().underlying().debug("{} is a variant record", new Object[]{child.name()});
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            Option<InterfaceType> option = child.type().typ();
                            if (!(option instanceof Some) || !((interfaceType = (InterfaceType)(some = (Some)option).value()) instanceof InterfaceType.Normal) || (defDataType = (normal = (InterfaceType.Normal)interfaceType).type()) == null) break block8;
                            typeVars = defDataType.typeVars();
                            record = defDataType.dataType();
                            if (record instanceof Record) break block9;
                        }
                        String c = new StringBuilder(1).append(typeWithContext.name()).append(".").append(child.name()).toString();
                        throw new IllegalArgumentException(new StringBuilder(55).append("Underlying type of constructor ").append(c).append(" is not Record (found: ").append(child.type().typ()).append(")").toString());
                    }
                    Record record2 = (Record)record;
                    ArrayBuffer arrayBuffer = innerClasses.$plus$eq((Object)VariantRecordClass$.MODULE$.generate((IndexedSeq<String>)((IndexedSeq)typeVars.map((Function1 & Serializable & scala.Serializable)s -> JavaEscaper$.MODULE$.escapeString((String)s), ImmArray.ImmArraySeq$.MODULE$.canBuildFrom())), package$.MODULE$.getFieldsWithTypes((IndexedSeq<Tuple2<String, Type>>)record2.fields(), packagePrefixes), child.name(), fullVariantClassName, packagePrefixes).build());
                    boxedUnit = arrayBuffer;
                    break block10;
                }
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{} is an unrelated inner type", new Object[]{child.name()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        }, Iterable$.MODULE$.canBuildFrom());
        return innerClasses.toList();
    }

    public static final /* synthetic */ boolean $anonfun$generateParameterizedFromValue$1(TypeName x$2) {
        return x$2 instanceof TypeVariableName;
    }

    public static final /* synthetic */ boolean $anonfun$generateConstructorClasses$1(FieldInfo check$ifrefutable$1) {
        FieldInfo fieldInfo = check$ifrefutable$1;
        boolean bl = fieldInfo != null;
        return bl;
    }

    private VariantClass$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

