/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Record;
import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.iface.PrimType;
import com.daml.lf.iface.PrimTypeBool$;
import com.daml.lf.iface.PrimTypeContractId$;
import com.daml.lf.iface.PrimTypeDate$;
import com.daml.lf.iface.PrimTypeGenMap$;
import com.daml.lf.iface.PrimTypeInt64$;
import com.daml.lf.iface.PrimTypeList$;
import com.daml.lf.iface.PrimTypeOptional$;
import com.daml.lf.iface.PrimTypeParty$;
import com.daml.lf.iface.PrimTypeText$;
import com.daml.lf.iface.PrimTypeTextMap$;
import com.daml.lf.iface.PrimTypeTimestamp$;
import com.daml.lf.iface.PrimTypeUnit$;
import com.daml.lf.iface.TypeCon;
import com.daml.lf.iface.TypeNumeric;
import com.daml.lf.iface.TypePrim;
import com.daml.lf.iface.TypeVar;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class FromValueGenerator$
implements StrictLogging {
    public static FromValueGenerator$ MODULE$;
    private final Map<PrimType, Tuple2<String, Option<String>>> extractors;
    private final Logger logger;

    static {
        new FromValueGenerator$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public MethodSpec generateFromValueForRecordLike(IndexedSeq<FieldInfo> fields, TypeName className, IndexedSeq<String> typeParameters, Function2<String, String, CodeBlock> recordValueExtractor, Map<String, String> packagePrefixes) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue method");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        IndexedSeq<ParameterSpec> converterParams = FromValueExtractorParameters$.MODULE$.generate(typeParameters).parameterSpecs();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"fromValue").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(className).addTypeVariables(package$.MODULE$.TypeNameExtensions(className).typeParameters()).addParameter(TypeName.get(Value.class), "value$", new Modifier[0]).addParameters((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(converterParams).asJava()).addException(IllegalArgumentException.class).addCode((CodeBlock)recordValueExtractor.apply((Object)"value$", (Object)"recordValue$")).addStatement("$T record$$ = recordValue$$.asRecord().orElseThrow(() -> new IllegalArgumentException($S))", new Object[]{Record.class, "Contracts must be constructed from Records"}).addStatement("$T fields$$ = record$$.getFields()", new Object[]{ParameterizedTypeName.get(List.class, (Type[])new Type[]{Record.Field.class})}).addStatement("int numberOfFields = fields$$.size()", new Object[0]).beginControlFlow(new StringBuilder(23).append("if (numberOfFields != ").append(fields.size()).append(")").toString(), new Object[0]).addStatement("throw new $T($S + numberOfFields)", new Object[]{IllegalArgumentException.class, new StringBuilder(25).append("Expected ").append(fields.size()).append(" arguments, got ").toString()}).endControlFlow();
        fields.toIterator().zip(this.accessors()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CodeBlock accessor;
            FieldInfo fieldInfo;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    fieldInfo = (FieldInfo)tuple2._1();
                    accessor = (CodeBlock)tuple2._2();
                    if (fieldInfo != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            com.daml.lf.iface.Type damlType = fieldInfo.damlType();
            String javaName = fieldInfo.javaName();
            MethodSpec.Builder builder = method.addStatement(MODULE$.generateFieldExtractor(damlType, javaName, accessor, packagePrefixes));
            return builder;
        });
        return method.addStatement("return new $L($L)", new Object[]{className, package$.MODULE$.generateArgumentList((IndexedSeq<String>)((IndexedSeq)fields.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.javaName(), IndexedSeq$.MODULE$.canBuildFrom())))}).build();
    }

    private Iterator<CodeBlock> accessors() {
        return scala.package$.MODULE$.Iterator().from(0).map((Function1 & Serializable & scala.Serializable)i -> FromValueGenerator$.$anonfun$accessors$1(BoxesRunTime.unboxToInt((Object)i)));
    }

    public CodeBlock variantCheck(String constructorName, String inputVar, String outputVar) {
        return CodeBlock.builder().addStatement("$T variant$$ = $L.asVariant().orElseThrow(() -> new IllegalArgumentException($S + $L.getClass().getName()))", new Object[]{Variant.class, inputVar, "Expected: Variant. Actual: ", inputVar}).addStatement("if (!$S.equals(variant$$.getConstructor())) throw new $T($S + variant$$.getConstructor())", new Object[]{constructorName, IllegalArgumentException.class, new StringBuilder(41).append("Invalid constructor. Expected: ").append(constructorName).append(". Actual: ").toString()}).addStatement("$T $L = variant$$.getValue()", new Object[]{Value.class, outputVar}).build();
    }

    public CodeBlock generateFieldExtractor(com.daml.lf.iface.Type fieldType, String field, CodeBlock accessor, Map<String, String> packagePrefixes) {
        return CodeBlock.of((String)"$T $L = $L", (Object[])new Object[]{package$.MODULE$.toJavaTypeName(fieldType, packagePrefixes), field, this.extractor(fieldType, field, accessor, package$.MODULE$.newNameGenerator(), packagePrefixes)});
    }

    private Option<CodeBlock> primitive(PrimType damlType, TypeName apiType, String field, CodeBlock accessor) {
        return this.extractors.get((Object)damlType).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Option converter;
            String extractor;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                extractor = (String)tuple2._1();
                converter = (Option)tuple2._2();
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("Generating primitive extractor for {} of type {}", new Object[]{field, apiType});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            CodeBlock codeBlock = CodeBlock.of((String)"$L.$L()$L$L", (Object[])new Object[]{accessor, extractor, MODULE$.orElseThrow(apiType, field), converter.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")});
            return codeBlock;
        });
    }

    private CodeBlock orElseThrow(TypeName typeName, String field) {
        return CodeBlock.of((String)".orElseThrow(() -> new IllegalArgumentException($S))", (Object[])new Object[]{new StringBuilder(24).append("Expected ").append(field).append(" to be of type ").append(typeName).toString()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CodeBlock extractor(com.daml.lf.iface.Type damlType, String field, CodeBlock accessor, Iterator<String> args, Map<String, String> packagePrefixes) {
        PrimType primType;
        BoxedUnit boxedUnit;
        LazyRef apiType$lzy = new LazyRef();
        LazyRef javaType$lzy = new LazyRef();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating composite extractor for {} of type {}", new Object[]{field, FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean bl = false;
        TypePrim typePrim = null;
        boolean bl2 = false;
        TypeCon typeCon = null;
        com.daml.lf.iface.Type type = damlType;
        if (type instanceof TypeVar) {
            TypeVar typeVar = (TypeVar)type;
            String tvName = typeVar.name();
            return CodeBlock.of((String)"fromValue$L.apply($L)", (Object[])new Object[]{JavaEscaper$.MODULE$.escapeString(tvName), accessor});
        }
        if (type instanceof TypePrim) {
            Some some;
            bl = true;
            typePrim = (TypePrim)type;
            PrimType primType2 = typePrim.typ();
            ImmArray.ImmArraySeq immArraySeq = typePrim.typArgs();
            if (PrimTypeList$.MODULE$.equals(primType2) && !(some = ImmArray.ImmArraySeq$.MODULE$.unapplySeq((Seq)immArraySeq)).isEmpty() && some.get() != null && ((IndexedSeqOptimized)some.get()).lengthCompare(1) == 0) {
                com.daml.lf.iface.Type param = (com.daml.lf.iface.Type)((ImmArray.ImmArraySeq)some.get()).apply(0);
                String optMapArg = (String)args.next();
                String listMapArg = (String)args.next();
                return CodeBlock.of((String)new StringOps(Predef$.MODULE$.augmentString("$L.asList()\n            |    .map($L -> $L.toList($L ->\n            |        $L\n            |    ))\n            |    $L\n            |")).stripMargin(), (Object[])new Object[]{accessor, optMapArg, optMapArg, listMapArg, this.extractor(param, listMapArg, CodeBlock.of((String)"$L", (Object[])new Object[]{listMapArg}), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
            }
        }
        if (bl) {
            Some some;
            PrimType primType3 = typePrim.typ();
            ImmArray.ImmArraySeq immArraySeq = typePrim.typArgs();
            if (PrimTypeOptional$.MODULE$.equals(primType3) && !(some = ImmArray.ImmArraySeq$.MODULE$.unapplySeq((Seq)immArraySeq)).isEmpty() && some.get() != null && ((IndexedSeqOptimized)some.get()).lengthCompare(1) == 0) {
                com.daml.lf.iface.Type param = (com.daml.lf.iface.Type)((ImmArray.ImmArraySeq)some.get()).apply(0);
                String optOptArg = (String)args.next();
                String valArg = (String)args.next();
                return CodeBlock.of((String)new StringOps(Predef$.MODULE$.augmentString("$L.asOptional()\n            |    .map($L -> $L.toOptional($L ->\n            |        $L\n            |    ))\n            |    $L\n          ")).stripMargin(), (Object[])new Object[]{accessor, optOptArg, optOptArg, valArg, this.extractor(param, valArg, CodeBlock.of((String)"$L", (Object[])new Object[]{valArg}), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
            }
        }
        if (bl && PrimTypeContractId$.MODULE$.equals(primType = typePrim.typ())) {
            return CodeBlock.of((String)"new $T($L.asContractId()$L.getValue())", (Object[])new Object[]{FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes), accessor, this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
        }
        if (bl) {
            Some some;
            PrimType primType4 = typePrim.typ();
            ImmArray.ImmArraySeq immArraySeq = typePrim.typArgs();
            if (PrimTypeTextMap$.MODULE$.equals(primType4) && !(some = ImmArray.ImmArraySeq$.MODULE$.unapplySeq((Seq)immArraySeq)).isEmpty() && some.get() != null && ((IndexedSeqOptimized)some.get()).lengthCompare(1) == 0) {
                com.daml.lf.iface.Type param = (com.daml.lf.iface.Type)((ImmArray.ImmArraySeq)some.get()).apply(0);
                String optMapArg = (String)args.next();
                String entryArg = (String)args.next();
                return CodeBlock.of((String)new StringOps(Predef$.MODULE$.augmentString("$L.asTextMap()\n            |    .map($L -> $L.toMap($L ->\n            |        $L\n            |    ))\n            |    $L\n          ")).stripMargin(), (Object[])new Object[]{accessor, optMapArg, optMapArg, entryArg, this.extractor(param, entryArg, CodeBlock.of((String)"$L", (Object[])new Object[]{entryArg}), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
            }
        }
        if (bl) {
            Some some;
            PrimType primType5 = typePrim.typ();
            ImmArray.ImmArraySeq immArraySeq = typePrim.typArgs();
            if (PrimTypeGenMap$.MODULE$.equals(primType5) && !(some = ImmArray.ImmArraySeq$.MODULE$.unapplySeq((Seq)immArraySeq)).isEmpty() && some.get() != null && ((IndexedSeqOptimized)some.get()).lengthCompare(2) == 0) {
                com.daml.lf.iface.Type keyType = (com.daml.lf.iface.Type)((ImmArray.ImmArraySeq)some.get()).apply(0);
                com.daml.lf.iface.Type valueType = (com.daml.lf.iface.Type)((ImmArray.ImmArraySeq)some.get()).apply(1);
                String optMapArg = (String)args.next();
                String entryArg = (String)args.next();
                return CodeBlock.of((String)new StringOps(Predef$.MODULE$.augmentString("$L.asGenMap()\n              |    .map($L -> $L.toMap(\n              |        $L -> $L,\n              |        $L -> $L\n              |    ))\n              |    $L\n          ")).stripMargin(), (Object[])new Object[]{accessor, optMapArg, optMapArg, entryArg, this.extractor(keyType, entryArg, CodeBlock.of((String)"$L", (Object[])new Object[]{entryArg}), args, packagePrefixes), entryArg, this.extractor(valueType, entryArg, CodeBlock.of((String)"$L", (Object[])new Object[]{entryArg}), args, packagePrefixes), this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
            }
        }
        if (type instanceof TypeNumeric) {
            return CodeBlock.of((String)"$L.asNumeric()$L.getValue()", (Object[])new Object[]{accessor, this.orElseThrow(FromValueGenerator$.apiType$2(apiType$lzy, damlType), field)});
        }
        if (bl) {
            PrimType prim = typePrim.typ();
            return (CodeBlock)this.primitive(prim, FromValueGenerator$.apiType$2(apiType$lzy, damlType), field, accessor).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(25).append("Unhandled primitive type ").append(prim).toString()));
        }
        if (type instanceof TypeCon) {
            bl2 = true;
            typeCon = (TypeCon)type;
            ImmArray.ImmArraySeq immArraySeq = typeCon.typArgs();
            Some some = ImmArray.ImmArraySeq$.MODULE$.unapplySeq((Seq)immArraySeq);
            if (!some.isEmpty() && some.get() != null && ((IndexedSeqOptimized)some.get()).lengthCompare(0) == 0) {
                return CodeBlock.of((String)"$T.fromValue($L)", (Object[])new Object[]{FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes), accessor});
            }
        }
        if (!bl2) throw new MatchError((Object)type);
        ImmArray.ImmArraySeq typeParameters = typeCon.typArgs();
        Tuple2 tuple2 = ((GenericTraversableTemplate)typeParameters.map((Function1 & Serializable & scala.Serializable)targ -> {
            String innerArg = (String)args.next();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.toJavaTypeName((com.daml.lf.iface.Type)targ, packagePrefixes)), (Object)CodeBlock.of((String)"$L -> $L", (Object[])new Object[]{innerArg, MODULE$.extractor((com.daml.lf.iface.Type)targ, field, CodeBlock.of((String)"$L", (Object[])new Object[]{innerArg}), args, packagePrefixes)}));
        }, ImmArray.ImmArraySeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        ImmArray.ImmArraySeq targs = (ImmArray.ImmArraySeq)tuple2._1();
        ImmArray.ImmArraySeq extractors = (ImmArray.ImmArraySeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targs, (Object)extractors);
        Tuple2 tuple23 = tuple22;
        ImmArray.ImmArraySeq targs2 = (ImmArray.ImmArraySeq)tuple23._1();
        ImmArray.ImmArraySeq extractors2 = (ImmArray.ImmArraySeq)tuple23._2();
        CodeBlock targsCode = CodeBlock.join((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)targs2.map((Function1 & Serializable & scala.Serializable)x$3 -> CodeBlock.of((String)"$L", (Object[])new Object[]{x$3}), ImmArray.ImmArraySeq$.MODULE$.canBuildFrom())).asJava()), (String)", ");
        return CodeBlock.builder().add(CodeBlock.of((String)"$T.<$L>fromValue($L, ", (Object[])new Object[]{package$.MODULE$.TypeNameExtensions(FromValueGenerator$.javaType$1(javaType$lzy, damlType, packagePrefixes)).rawType(), targsCode, accessor})).add(CodeBlock.join((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)extractors2).asJava()), (String)", ")).add(")", new Object[0]).build();
    }

    public static final /* synthetic */ CodeBlock $anonfun$accessors$1(int i) {
        return CodeBlock.of((String)"fields$$.get($L).getValue()", (Object[])new Object[]{new Integer(i)});
    }

    private static final /* synthetic */ TypeName apiType$lzycompute$1(LazyRef apiType$lzy$1, com.daml.lf.iface.Type damlType$1) {
        TypeName typeName;
        LazyRef lazyRef = apiType$lzy$1;
        synchronized (lazyRef) {
            typeName = apiType$lzy$1.initialized() ? (TypeName)apiType$lzy$1.value() : (TypeName)apiType$lzy$1.initialize((Object)package$.MODULE$.toAPITypeName(damlType$1));
        }
        return typeName;
    }

    private static final TypeName apiType$2(LazyRef apiType$lzy$1, com.daml.lf.iface.Type damlType$1) {
        return apiType$lzy$1.initialized() ? (TypeName)apiType$lzy$1.value() : FromValueGenerator$.apiType$lzycompute$1(apiType$lzy$1, damlType$1);
    }

    private static final /* synthetic */ TypeName javaType$lzycompute$1(LazyRef javaType$lzy$1, com.daml.lf.iface.Type damlType$1, Map packagePrefixes$2) {
        TypeName typeName;
        LazyRef lazyRef = javaType$lzy$1;
        synchronized (lazyRef) {
            typeName = javaType$lzy$1.initialized() ? (TypeName)javaType$lzy$1.value() : (TypeName)javaType$lzy$1.initialize((Object)package$.MODULE$.toJavaTypeName(damlType$1, (Map<String, String>)packagePrefixes$2));
        }
        return typeName;
    }

    private static final TypeName javaType$1(LazyRef javaType$lzy$1, com.daml.lf.iface.Type damlType$1, Map packagePrefixes$2) {
        return javaType$lzy$1.initialized() ? (TypeName)javaType$lzy$1.value() : FromValueGenerator$.javaType$lzycompute$1(javaType$lzy$1, damlType$1, packagePrefixes$2);
    }

    private FromValueGenerator$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.extractors = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)PrimTypeBool$.MODULE$, (Object)new Tuple2((Object)"asBool", (Object)new Some((Object)".getValue()"))), new Tuple2((Object)PrimTypeInt64$.MODULE$, (Object)new Tuple2((Object)"asInt64", (Object)new Some((Object)".getValue()"))), new Tuple2((Object)PrimTypeText$.MODULE$, (Object)new Tuple2((Object)"asText", (Object)new Some((Object)".getValue()"))), new Tuple2((Object)PrimTypeTimestamp$.MODULE$, (Object)new Tuple2((Object)"asTimestamp", (Object)new Some((Object)".getValue()"))), new Tuple2((Object)PrimTypeParty$.MODULE$, (Object)new Tuple2((Object)"asParty", (Object)new Some((Object)".getValue()"))), new Tuple2((Object)PrimTypeUnit$.MODULE$, (Object)new Tuple2((Object)"asUnit", (Object)None$.MODULE$)), new Tuple2((Object)PrimTypeDate$.MODULE$, (Object)new Tuple2((Object)"asDate", (Object)new Some((Object)".getValue()")))}));
    }
}

