/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import org.checkerframework.org.plumelib.util.Pair;

public class AnnotationInsertion
extends Insertion {
    private final String fullyQualifiedAnnotationText;
    private final String fullyQualifiedAnnotationName;
    private String type;
    private boolean generateBound;
    private boolean generateExtends;
    private boolean wasGenerateExtends;

    public AnnotationInsertion(String fullyQualifiedAnnotationText, Criteria criteria, boolean separateLine) {
        super(criteria, separateLine);
        assert (fullyQualifiedAnnotationText.startsWith("@")) : fullyQualifiedAnnotationText;
        this.fullyQualifiedAnnotationText = fullyQualifiedAnnotationText;
        this.fullyQualifiedAnnotationName = this.extractAnnotationFullyQualifiedName();
        this.type = null;
        this.generateBound = false;
        this.generateExtends = false;
        this.wasGenerateExtends = false;
    }

    public AnnotationInsertion(String annotation) {
        this(annotation, new Criteria(), false);
    }

    public boolean isGenerateExtends() {
        return this.generateExtends;
    }

    public boolean isGenerateBound() {
        return this.generateBound;
    }

    public void setGenerateExtends(boolean generateExtends) {
        this.generateExtends = generateExtends;
        this.wasGenerateExtends |= generateExtends;
    }

    public void setGenerateBound(boolean b) {
        this.generateBound = b;
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        String result2 = this.fullyQualifiedAnnotationText;
        if (abbreviate) {
            Pair<String, String> ps = AnnotationInsertion.removePackage(result2);
            String packageName = (String)ps.a;
            if (packageName != null) {
                this.packageNames.add(packageName);
                result2 = (String)ps.b;
            }
        }
        if (!result2.startsWith("@")) {
            throw new Error("Illegal insertion, must start with @: " + result2);
        }
        if (this.type != null) {
            result2 = "new " + result2 + " " + this.type;
        } else if (this.generateBound) {
            result2 = result2 + " Object &";
        } else if (this.generateExtends) {
            result2 = " extends " + result2 + " Object";
        }
        return comments ? "/*" + result2 + "*/" : result2;
    }

    private String extractAnnotationFullyQualifiedName() {
        assert (this.fullyQualifiedAnnotationText.startsWith("@"));
        int nameBegin = 1;
        int nameEnd = this.fullyQualifiedAnnotationText.indexOf("(");
        if (nameEnd == -1) {
            nameEnd = this.fullyQualifiedAnnotationText.length();
        }
        return this.fullyQualifiedAnnotationText.substring(nameBegin, nameEnd);
    }

    public String getAnnotation() {
        return this.fullyQualifiedAnnotationText;
    }

    public String getAnnotationFullyQualifiedName() {
        return this.fullyQualifiedAnnotationName;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        if (this.generateExtends || precedingChar == '.') {
            return false;
        }
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar);
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        return !this.wasGenerateExtends && super.addTrailingSpace(gotSeparateLine);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.ANNOTATION;
    }

    @Override
    public String toString() {
        return this.fullyQualifiedAnnotationText + " " + super.toString();
    }

    public void setType(String s2) {
        this.type = s2;
    }
}

