/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.BoundLocation;

public class MethodBoundCriterion
implements Criterion {
    private final String methodName;
    public final BoundLocation boundLoc;
    private final Criterion sigMethodCriterion;
    private final Criterion boundLocationCriterion;

    public MethodBoundCriterion(String methodName, BoundLocation boundLoc) {
        this.methodName = methodName;
        this.boundLoc = boundLoc;
        this.sigMethodCriterion = Criteria.inMethod(methodName);
        this.boundLocationCriterion = Criteria.atBoundLocation(boundLoc);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        return this.sigMethodCriterion.isSatisfiedBy(path) && this.boundLocationCriterion.isSatisfiedBy(path);
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_BOUND;
    }

    public String toString() {
        return "MethodBoundCriterion: method: " + this.methodName + " bound boundLoc: " + this.boundLoc;
    }
}

