/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.AnnotationInsertion;
import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.TypedInsertion;
import java.util.List;
import scenelib.type.DeclaredType;

public class ReceiverInsertion
extends TypedInsertion {
    private boolean addComma = false;
    private boolean qualifyThis = false;

    public ReceiverInsertion(DeclaredType type, Criteria criteria, List<Insertion> innerTypeInsertions) {
        super(type, criteria, innerTypeInsertions);
    }

    public void setAddComma(boolean addComma) {
        this.addComma = addComma;
    }

    public void setQualifyType(boolean qualifyThis) {
        this.qualifyThis = qualifyThis;
    }

    @Override
    protected String getText(boolean comments, boolean abbreviate) {
        if (this.annotationsOnly) {
            StringBuilder b = new StringBuilder();
            List<String> annotations = this.type.getAnnotations();
            if (annotations.isEmpty()) {
                return "";
            }
            for (String a : annotations) {
                b.append(a);
                b.append(' ');
            }
            return new AnnotationInsertion(b.toString(), this.getCriteria(), this.isSeparateLine()).getText(comments, abbreviate);
        }
        DeclaredType baseType = this.getBaseType();
        boolean commentAnnotation = comments && baseType.getName().isEmpty();
        String result2 = this.typeToString(this.type, commentAnnotation, abbreviate);
        if (!baseType.getName().isEmpty()) {
            result2 = result2 + " ";
            if (this.qualifyThis) {
                for (DeclaredType t = baseType; t != null; t = t.getInnerType()) {
                    result2 = result2 + t.getName() + ".";
                }
            }
            result2 = result2 + "this";
            if (this.addComma) {
                result2 = result2 + ",";
            }
            if (comments) {
                result2 = "/*>>> " + result2 + " */";
            }
        }
        return result2;
    }

    @Override
    protected boolean addLeadingSpace(boolean gotSeparateLine, int pos, char precedingChar) {
        if (precedingChar == '.' && this.getBaseType().getName().isEmpty()) {
            return false;
        }
        return super.addLeadingSpace(gotSeparateLine, pos, precedingChar);
    }

    @Override
    protected boolean addTrailingSpace(boolean gotSeparateLine) {
        if (!this.getBaseType().getName().isEmpty() && !this.addComma) {
            return false;
        }
        return super.addTrailingSpace(gotSeparateLine);
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.RECEIVER;
    }
}

