/*
 * Decompiled with CFR 0.152.
 */
package com.daml.assistant.config;

import com.daml.assistant.config.ConfigLoadError;
import com.daml.assistant.config.ConfigLoadingError;
import com.daml.assistant.config.ConfigMissing;
import com.daml.assistant.config.ConfigParseError;
import com.daml.assistant.config.ProjectConfig;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.yaml.parser.package$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.util.Either;
import scala.util.Try$;

public final class ProjectConfig$
implements scala.Serializable {
    public static ProjectConfig$ MODULE$;
    private final String envVarProjectPath;
    private final String projectConfigName;

    static {
        new ProjectConfig$();
    }

    public String envVarProjectPath() {
        return this.envVarProjectPath;
    }

    public String projectConfigName() {
        return this.projectConfigName;
    }

    public Either<ConfigLoadingError, String> projectPath() {
        return scala.sys.package$.MODULE$.env().get(this.envVarProjectPath()).toRight((Function0<ConfigMissing> & Serializable & scala.Serializable)() -> new ConfigMissing(new StringBuilder(31).append("Environment variable ").append(MODULE$.envVarProjectPath()).append(" not found").toString()));
    }

    public Either<ConfigLoadingError, File> projectConfigPath() {
        return this.projectPath().flatMap((Function1<String, Either> & Serializable & scala.Serializable)path -> Try$.MODULE$.apply((Function0<File> & Serializable & scala.Serializable)() -> new File((String)path, MODULE$.projectConfigName())).toEither().left().map((Function1<Throwable, ConfigMissing> & Serializable & scala.Serializable)t -> new ConfigMissing(t.getMessage())));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromString(String content) {
        return package$.MODULE$.parse(content).left().map((Function1<ParsingFailure, ConfigParseError> & Serializable & scala.Serializable)e -> new ConfigParseError(e.getMessage())).map((Function1<Json, ProjectConfig> & Serializable & scala.Serializable)json -> new ProjectConfig((Json)json));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromFile(File file) {
        return scala.package$.MODULE$.Either().cond(Files.exists(file.toPath(), new LinkOption[0]), (JFunction0$mcZ$sp & scala.Serializable)() -> true, (Function0<ConfigMissing> & Serializable & scala.Serializable)() -> new ConfigMissing(new StringBuilder(27).append("Config file ").append(file.toPath()).append(" does not exist").toString())).flatMap((Function1<Object, Either> & Serializable & scala.Serializable)_ -> ProjectConfig$.$anonfun$loadFromFile$3(file, BoxesRunTime.unboxToBoolean(_)));
    }

    public Either<ConfigLoadingError, ProjectConfig> loadFromEnv() {
        return this.projectConfigPath().flatMap((Function1<File, Either> & Serializable & scala.Serializable)path -> MODULE$.loadFromFile((File)path).map((Function1<ProjectConfig, ProjectConfig> & Serializable & scala.Serializable)result2 -> result2));
    }

    public ProjectConfig apply(Json content) {
        return new ProjectConfig(content);
    }

    public Option<Json> unapply(ProjectConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Json>(x$0.content());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Either $anonfun$loadFromFile$3(File file$1, boolean _) {
        return Try$.MODULE$.apply((Function0<BufferedSource> & Serializable & scala.Serializable)() -> Source$.MODULE$.fromFile(file$1, "UTF-8")).toEither().left().map((Function1<Throwable, ConfigLoadError> & Serializable & scala.Serializable)e -> new ConfigLoadError(e.getMessage())).flatMap((Function1<BufferedSource, Either> & Serializable & scala.Serializable)source -> Try$.MODULE$.apply((Function0<String> & Serializable & scala.Serializable)() -> {
            String string2;
            try {
                string2 = source.mkString();
            }
            finally {
                source.close();
            }
            return string2;
        }).toEither().left().map((Function1<Throwable, ConfigLoadError> & Serializable & scala.Serializable)e -> new ConfigLoadError(e.getMessage())).flatMap((Function1<String, Either> & Serializable & scala.Serializable)content -> MODULE$.loadFromString((String)content).map((Function1<ProjectConfig, ProjectConfig> & Serializable & scala.Serializable)result2 -> result2)));
    }

    private ProjectConfig$() {
        MODULE$ = this;
        this.envVarProjectPath = "DAML_PROJECT";
        this.projectConfigName = "daml.yaml";
    }
}

