/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.CommandUnknown;
import com.daml.ledger.javaapi.data.CreateAndExerciseCommand;
import com.daml.ledger.javaapi.data.CreateCommand;
import com.daml.ledger.javaapi.data.ExerciseByKeyCommand;
import com.daml.ledger.javaapi.data.ExerciseCommand;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.ProtoCommandUnknown;
import java.util.Optional;

public abstract class Command {
    abstract Identifier getTemplateId();

    public static Command fromProtoCommand(CommandsOuterClass.Command command) {
        switch (command.getCommandCase()) {
            case CREATE: {
                return CreateCommand.fromProto(command.getCreate());
            }
            case EXERCISE: {
                return ExerciseCommand.fromProto(command.getExercise());
            }
            case CREATEANDEXERCISE: {
                return CreateAndExerciseCommand.fromProto(command.getCreateAndExercise());
            }
            case EXERCISEBYKEY: {
                return ExerciseByKeyCommand.fromProto(command.getExerciseByKey());
            }
        }
        throw new ProtoCommandUnknown(command);
    }

    public CommandsOuterClass.Command toProtoCommand() {
        CommandsOuterClass.Command.Builder builder = CommandsOuterClass.Command.newBuilder();
        if (this instanceof CreateCommand) {
            builder.setCreate(((CreateCommand)this).toProto());
        } else if (this instanceof ExerciseCommand) {
            builder.setExercise(((ExerciseCommand)this).toProto());
        } else if (this instanceof CreateAndExerciseCommand) {
            builder.setCreateAndExercise(((CreateAndExerciseCommand)this).toProto());
        } else if (this instanceof ExerciseByKeyCommand) {
            builder.setExerciseByKey(((ExerciseByKeyCommand)this).toProto());
        } else {
            throw new CommandUnknown(this);
        }
        return builder.build();
    }

    public final Optional<CreateCommand> asCreateCommand() {
        return this instanceof CreateCommand ? Optional.of((CreateCommand)this) : Optional.empty();
    }

    public final Optional<ExerciseCommand> asExerciseCommand() {
        return this instanceof ExerciseCommand ? Optional.of((ExerciseCommand)this) : Optional.empty();
    }
}

