/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.Record;
import com.daml.ledger.javaapi.data.Value;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CreateAndExerciseCommand
extends Command {
    private final Identifier templateId;
    private final Record createArguments;
    private final String choice;
    private final Value choiceArgument;

    public CreateAndExerciseCommand(@NonNull Identifier templateId, @NonNull Record createArguments, @NonNull String choice2, @NonNull Value choiceArgument) {
        this.templateId = templateId;
        this.createArguments = createArguments;
        this.choice = choice2;
        this.choiceArgument = choiceArgument;
    }

    public static CreateAndExerciseCommand fromProto(CommandsOuterClass.CreateAndExerciseCommand command) {
        Identifier templateId = Identifier.fromProto(command.getTemplateId());
        Record createArguments = Record.fromProto(command.getCreateArguments());
        String choice2 = command.getChoice();
        Value choiceArgument = Value.fromProto(command.getChoiceArgument());
        return new CreateAndExerciseCommand(templateId, createArguments, choice2, choiceArgument);
    }

    public CommandsOuterClass.CreateAndExerciseCommand toProto() {
        return CommandsOuterClass.CreateAndExerciseCommand.newBuilder().setTemplateId(this.templateId.toProto()).setCreateArguments(this.createArguments.toProtoRecord()).setChoice(this.choice).setChoiceArgument(this.choiceArgument.toProto()).build();
    }

    @Override
    Identifier getTemplateId() {
        return this.templateId;
    }

    public Record getCreateArguments() {
        return this.createArguments;
    }

    public String getChoice() {
        return this.choice;
    }

    public Value getChoiceArgument() {
        return this.choiceArgument;
    }

    public String toString() {
        return "CreateAndExerciseCommand{templateId=" + this.templateId + ", createArguments=" + this.createArguments + ", choice='" + this.choice + '\'' + ", choiceArgument=" + this.choiceArgument + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAndExerciseCommand that = (CreateAndExerciseCommand)o;
        return this.templateId.equals(that.templateId) && this.createArguments.equals(that.createArguments) && this.choice.equals(that.choice) && this.choiceArgument.equals(that.choiceArgument);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.createArguments, this.choice, this.choiceArgument);
    }
}

