/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.EventOuterClass;
import com.daml.ledger.javaapi.data.ArchivedEvent;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.Identifier;
import com.daml.ledger.javaapi.data.UnsupportedEventTypeException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Event {
    public @NonNull List<@NonNull String> getWitnessParties();

    public @NonNull String getEventId();

    public @NonNull Identifier getTemplateId();

    public @NonNull String getContractId();

    default public EventOuterClass.Event toProtoEvent() {
        EventOuterClass.Event.Builder eventBuilder = EventOuterClass.Event.newBuilder();
        if (this instanceof ArchivedEvent) {
            ArchivedEvent event = (ArchivedEvent)this;
            eventBuilder.setArchived(event.toProto());
        } else if (this instanceof CreatedEvent) {
            CreatedEvent event = (CreatedEvent)this;
            eventBuilder.setCreated(event.toProto());
        } else {
            throw new RuntimeException("this should be ArchivedEvent or CreatedEvent or ExercisedEvent, found " + this.toString());
        }
        return eventBuilder.build();
    }

    public static Event fromProtoEvent(EventOuterClass.Event event) {
        if (event.hasCreated()) {
            return CreatedEvent.fromProto(event.getCreated());
        }
        if (event.hasArchived()) {
            return ArchivedEvent.fromProto(event.getArchived());
        }
        throw new UnsupportedEventTypeException(event.toString());
    }
}

