/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ActiveContractsServiceOuterClass;
import com.daml.ledger.javaapi.data.CreatedEvent;
import com.daml.ledger.javaapi.data.WorkflowEvent;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetActiveContractsResponse
implements WorkflowEvent {
    private final String offset;
    private final List<CreatedEvent> activeContracts;
    private final String workflowId;

    public GetActiveContractsResponse(@NonNull String offset, @NonNull List<CreatedEvent> activeContracts, String workflowId) {
        this.offset = offset;
        this.activeContracts = activeContracts;
        this.workflowId = workflowId;
    }

    public static GetActiveContractsResponse fromProto(ActiveContractsServiceOuterClass.GetActiveContractsResponse response) {
        List<CreatedEvent> events = response.getActiveContractsList().stream().map(CreatedEvent::fromProto).collect(Collectors.toList());
        return new GetActiveContractsResponse(response.getOffset(), events, response.getWorkflowId());
    }

    public ActiveContractsServiceOuterClass.GetActiveContractsResponse toProto() {
        return ActiveContractsServiceOuterClass.GetActiveContractsResponse.newBuilder().setOffset(this.offset).addAllActiveContracts(this.activeContracts.stream().map(CreatedEvent::toProto).collect(Collectors.toList())).setWorkflowId(this.workflowId).build();
    }

    public @NonNull Optional<String> getOffset() {
        return Optional.of(this.offset).filter(off -> !this.offset.equals(""));
    }

    public @NonNull List<@NonNull CreatedEvent> getCreatedEvents() {
        return this.activeContracts;
    }

    @Override
    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public String toString() {
        return "GetActiveContractsResponse{offset='" + this.offset + '\'' + ", activeContracts=" + this.activeContracts + ", workflowId=" + this.workflowId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetActiveContractsResponse that = (GetActiveContractsResponse)o;
        return Objects.equals(this.offset, that.offset) && Objects.equals(this.activeContracts, that.activeContracts) && Objects.equals(this.workflowId, that.workflowId);
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.activeContracts, this.workflowId);
    }
}

