/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.TransactionOuterClass;
import com.daml.ledger.api.v1.TransactionServiceOuterClass;
import com.daml.ledger.javaapi.data.TransactionTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GetTransactionTreesResponse {
    private final List<TransactionTree> transactions;

    public GetTransactionTreesResponse(@NonNull List<@NonNull TransactionTree> transactions) {
        this.transactions = transactions;
    }

    public static GetTransactionTreesResponse fromProto(TransactionServiceOuterClass.GetTransactionTreesResponse response) {
        ArrayList<TransactionTree> transactionTrees = new ArrayList<TransactionTree>(response.getTransactionsCount());
        for (TransactionOuterClass.TransactionTree transactionTree : response.getTransactionsList()) {
            transactionTrees.add(TransactionTree.fromProto(transactionTree));
        }
        return new GetTransactionTreesResponse(transactionTrees);
    }

    public TransactionServiceOuterClass.GetTransactionTreesResponse toProto() {
        ArrayList<TransactionOuterClass.TransactionTree> transactionTrees = new ArrayList<TransactionOuterClass.TransactionTree>(this.transactions.size());
        for (TransactionTree transactionTree : this.transactions) {
            transactionTrees.add(transactionTree.toProto());
        }
        return TransactionServiceOuterClass.GetTransactionTreesResponse.newBuilder().addAllTransactions(transactionTrees).build();
    }

    public @NonNull List<@NonNull TransactionTree> getTransactions() {
        return this.transactions;
    }

    public String toString() {
        return "GetTransactionTreesResponse{transactions=" + this.transactions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTransactionTreesResponse that = (GetTransactionTreesResponse)o;
        return Objects.equals(this.transactions, that.transactions);
    }

    public int hashCode() {
        return Objects.hash(this.transactions);
    }
}

