/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.ValueOuterClass;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Identifier {
    private final String packageId;
    private final String moduleName;
    private final String entityName;

    @Deprecated
    public Identifier(@NonNull String packageId, @NonNull String name) {
        this.packageId = packageId;
        int lastDot = name.lastIndexOf(46);
        if (lastDot <= 0) {
            throw new IllegalArgumentException(String.format("Identifier name [%s] has wrong format. Dot-separated module and entity name expected (e.g.: Foo.Bar)", name));
        }
        this.moduleName = name.substring(0, lastDot);
        this.entityName = name.substring(lastDot + 1);
    }

    public Identifier(@NonNull String packageId, @NonNull String moduleName, @NonNull String entityName) {
        this.packageId = packageId;
        this.moduleName = moduleName;
        this.entityName = entityName;
    }

    public static @NonNull Identifier fromProto(ValueOuterClass.Identifier identifier) {
        if (!identifier.getModuleName().isEmpty() && !identifier.getEntityName().isEmpty()) {
            return new Identifier(identifier.getPackageId(), identifier.getModuleName(), identifier.getEntityName());
        }
        throw new IllegalArgumentException(String.format("Invalid identifier [%s]: both module_name and entity_name must be set.", identifier));
    }

    public ValueOuterClass.Identifier toProto() {
        return ValueOuterClass.Identifier.newBuilder().setPackageId(this.packageId).setModuleName(this.moduleName).setEntityName(this.entityName).build();
    }

    public @NonNull String getPackageId() {
        return this.packageId;
    }

    @Deprecated
    public @NonNull String getName() {
        return this.moduleName.concat(".").concat(this.entityName);
    }

    public @NonNull String getModuleName() {
        return this.moduleName;
    }

    public @NonNull String getEntityName() {
        return this.entityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.packageId, that.packageId) && Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.entityName, that.entityName);
    }

    public int hashCode() {
        return Objects.hash(this.packageId, this.moduleName, this.entityName);
    }

    public String toString() {
        return "Identifier{packageId='" + this.packageId + '\'' + ", moduleName='" + this.moduleName + '\'' + ", entityName='" + this.entityName + '\'' + '}';
    }
}

