/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.javaapi.data;

import com.daml.ledger.api.v1.CommandsOuterClass;
import com.daml.ledger.javaapi.data.Command;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SubmitCommandsRequest {
    private final String workflowId;
    private final String applicationId;
    private final String commandId;
    private final String party;
    private final Optional<Instant> minLedgerTimeAbsolute;
    private final Optional<java.time.Duration> minLedgerTimeRelative;
    private final Optional<java.time.Duration> deduplicationTime;
    private final List<Command> commands;

    public SubmitCommandsRequest(@NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        this.workflowId = workflowId;
        this.applicationId = applicationId;
        this.commandId = commandId;
        this.party = party;
        this.minLedgerTimeAbsolute = minLedgerTimeAbsolute;
        this.minLedgerTimeRelative = minLedgerTimeRelative;
        this.deduplicationTime = deduplicationTime;
        this.commands = commands;
    }

    public static SubmitCommandsRequest fromProto(CommandsOuterClass.Commands commands) {
        String ledgerId = commands.getLedgerId();
        String workflowId = commands.getWorkflowId();
        String applicationId = commands.getApplicationId();
        String commandId = commands.getCommandId();
        String party = commands.getParty();
        Optional<Instant> minLedgerTimeAbs = commands.hasMinLedgerTimeAbs() ? Optional.of(Instant.ofEpochSecond(commands.getMinLedgerTimeAbs().getSeconds(), commands.getMinLedgerTimeAbs().getNanos())) : Optional.empty();
        Optional<java.time.Duration> minLedgerTimeRel = commands.hasMinLedgerTimeRel() ? Optional.of(java.time.Duration.ofSeconds(commands.getMinLedgerTimeRel().getSeconds(), commands.getMinLedgerTimeRel().getNanos())) : Optional.empty();
        Optional<java.time.Duration> deduplicationTime = commands.hasDeduplicationTime() ? Optional.of(java.time.Duration.ofSeconds(commands.getDeduplicationTime().getSeconds(), commands.getDeduplicationTime().getNanos())) : Optional.empty();
        ArrayList<Command> listOfCommands = new ArrayList<Command>(commands.getCommandsCount());
        for (CommandsOuterClass.Command command : commands.getCommandsList()) {
            listOfCommands.add(Command.fromProtoCommand(command));
        }
        return new SubmitCommandsRequest(workflowId, applicationId, commandId, party, minLedgerTimeAbs, minLedgerTimeRel, deduplicationTime, listOfCommands);
    }

    public static CommandsOuterClass.Commands toProto(@NonNull String ledgerId, @NonNull String workflowId, @NonNull String applicationId, @NonNull String commandId, @NonNull String party, @NonNull Optional<Instant> minLedgerTimeAbsolute, @NonNull Optional<java.time.Duration> minLedgerTimeRelative, @NonNull Optional<java.time.Duration> deduplicationTime, @NonNull List<@NonNull Command> commands) {
        ArrayList<CommandsOuterClass.Command> commandsConverted = new ArrayList<CommandsOuterClass.Command>(commands.size());
        for (Command command : commands) {
            commandsConverted.add(command.toProtoCommand());
        }
        CommandsOuterClass.Commands.Builder builder = CommandsOuterClass.Commands.newBuilder().setLedgerId(ledgerId).setWorkflowId(workflowId).setApplicationId(applicationId).setCommandId(commandId).setParty(party).addAllCommands(commandsConverted);
        minLedgerTimeAbsolute.ifPresent(abs -> builder.setMinLedgerTimeAbs(Timestamp.newBuilder().setSeconds(abs.getEpochSecond()).setNanos(abs.getNano())));
        minLedgerTimeRelative.ifPresent(rel -> builder.setMinLedgerTimeRel(Duration.newBuilder().setSeconds(rel.getSeconds()).setNanos(rel.getNano())));
        deduplicationTime.ifPresent(dedup -> builder.setDeduplicationTime(Duration.newBuilder().setSeconds(dedup.getSeconds()).setNanos(dedup.getNano())));
        return builder.build();
    }

    public @NonNull String getWorkflowId() {
        return this.workflowId;
    }

    public @NonNull String getApplicationId() {
        return this.applicationId;
    }

    public @NonNull String getCommandId() {
        return this.commandId;
    }

    public @NonNull String getParty() {
        return this.party;
    }

    public @NonNull Optional<Instant> getMinLedgerTimeAbsolute() {
        return this.minLedgerTimeAbsolute;
    }

    public @NonNull Optional<java.time.Duration> getMinLedgerTimeRelative() {
        return this.minLedgerTimeRelative;
    }

    public @NonNull Optional<java.time.Duration> getDeduplicationTime() {
        return this.deduplicationTime;
    }

    public @NonNull List<@NonNull Command> getCommands() {
        return this.commands;
    }

    public String toString() {
        return "SubmitCommandsRequest{workflowId='" + this.workflowId + '\'' + ", applicationId='" + this.applicationId + '\'' + ", commandId='" + this.commandId + '\'' + ", party='" + this.party + '\'' + ", minLedgerTimeAbs=" + this.minLedgerTimeAbsolute + ", minLedgerTimeRel=" + this.minLedgerTimeRelative + ", deduplicationTime=" + this.deduplicationTime + ", commands=" + this.commands + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitCommandsRequest submitCommandsRequest1 = (SubmitCommandsRequest)o;
        return Objects.equals(this.workflowId, submitCommandsRequest1.workflowId) && Objects.equals(this.applicationId, submitCommandsRequest1.applicationId) && Objects.equals(this.commandId, submitCommandsRequest1.commandId) && Objects.equals(this.party, submitCommandsRequest1.party) && Objects.equals(this.minLedgerTimeAbsolute, submitCommandsRequest1.minLedgerTimeAbsolute) && Objects.equals(this.minLedgerTimeRelative, submitCommandsRequest1.minLedgerTimeRelative) && Objects.equals(this.deduplicationTime, submitCommandsRequest1.deduplicationTime) && Objects.equals(this.commands, submitCommandsRequest1.commands);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.applicationId, this.commandId, this.party, this.minLedgerTimeAbsolute, this.minLedgerTimeRelative, this.deduplicationTime, this.commands);
    }
}

