/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.archive;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.lf.archive.Dar;
import com.daml.lf.archive.DarReader$;
import com.daml.lf.archive.DarReader$ZipEntries$;
import com.daml.lf.archive.Errors;
import com.daml.lf.data.TryOps$;
import com.daml.lf.data.TryOps$Bracket$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001\u0002\u001a4\u0001qB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\tK\u0002\u0011\t\u0011)A\u0005M\")\u0001\u0010\u0001C\u0001s\")Q\u0010\u0001C\u0001}\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0003\u0016\u0002!IAa&\t\u000f\te\u0006\u0001\"\u0003\u0003<\u001e9\u00111M\u001a\t\u0002\u0005\u0015dA\u0002\u001a4\u0011\u0003\t9\u0007\u0003\u0004y\u0019\u0011\u0005\u0011\u0011\u000e\u0005\n\u0003Wb!\u0019!C\u0005\u0003[B\u0001\"!\u001f\rA\u0003%\u0011q\u000e\u0005\u000b\u0003wb!\u0019!C\u0001g\u0005u\u0004\u0002CA@\u0019\u0001\u0006I!a\u000b\u0007\u000f\u0005\u0005E\u0002Q\u001a\u0002\u0004\"Q\u00111\u0003\n\u0003\u0016\u0004%\t!!%\t\u0013\u0005M%C!E!\u0002\u0013Q\u0006BCAK%\tU\r\u0011\"\u0001\u0002\u0018\"Q\u0011q\u0014\n\u0003\u0012\u0003\u0006I!!'\t\ra\u0014B\u0011AAQ\u0011\u001d\tYK\u0005C\u0001\u0003[Cq!a-\u0013\t\u0003\t)\fC\u0004\u0002:J!I!a/\t\u000f\u0005}&\u0003\"\u0003\u0002B\"9\u00111\u0019\n\u0005\n\u0005\u0015\u0007bBAi%\u0011%\u00111\u001b\u0005\n\u0003/\u0014\u0012\u0011!C\u0001\u00033D\u0011\"a8\u0013#\u0003%\t!!9\t\u0013\u0005\u0015(#%A\u0005\u0002\u0005\u001d\b\"CAv%\u0005\u0005I\u0011IA7\u0011%\tiOEA\u0001\n\u0003\ti\bC\u0005\u0002pJ\t\t\u0011\"\u0001\u0002r\"I\u0011q\u001f\n\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0005\u000f\u0011\u0012\u0011!C\u0001\u0005\u0013A\u0011B!\u0004\u0013\u0003\u0003%\tEa\u0004\t\u0013\tE!#!A\u0005B\tM\u0001\"\u0003B\u000b%\u0005\u0005I\u0011\tB\f\u000f)\u0011Y\u0002DA\u0001\u0012\u0003\u0019$Q\u0004\u0004\u000b\u0003\u0003c\u0011\u0011!E\u0001g\t}\u0001B\u0002=+\t\u0003\u0011i\u0003C\u0005\u0003\u0012)\n\t\u0011\"\u0012\u0003\u0014!I!q\u0006\u0016\u0002\u0002\u0013\u0005%\u0011\u0007\u0005\n\u0005oQ\u0013\u0011!CA\u0005sA\u0011Ba\u0012+\u0003\u0003%IA!\u0013\t\u000f\t=B\u0002\"\u0001\u0003R!9!q\u0006\u0007\u0005\u0002\t}$!\u0003#beJ+\u0017\rZ3s\u0015\t!T'A\u0004be\u000eD\u0017N^3\u000b\u0005Y:\u0014A\u00017g\u0015\tA\u0014(\u0001\u0003eC6d'\"\u0001\u001e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005uz7C\u0001\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fM\u0006I\"/Z1e\t\u0006dgMT1nKN4%o\\7NC:Lg-Z:u!\u0011yd\t\u0013)\n\u0005\u001d\u0003%!\u0003$v]\u000e$\u0018n\u001c82!\tIe*D\u0001K\u0015\tYE*\u0001\u0002j_*\tQ*\u0001\u0003kCZ\f\u0017BA(K\u0005-Ie\u000e];u'R\u0014X-Y7\u0011\u0007E#f+D\u0001S\u0015\t\u0019\u0006)\u0001\u0003vi&d\u0017BA+S\u0005\r!&/\u001f\t\u0004/bSV\"A\u001a\n\u0005e\u001b$a\u0001#beB\u00111L\u0019\b\u00039\u0002\u0004\"!\u0018!\u000e\u0003yS!aX\u001e\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0007)\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1A\u0003%\u0001\u0018M]:f\t\u0006dg\rE\u0003@O&DE.\u0003\u0002i\u0001\nIa)\u001e8di&|gN\r\t\u0003\u007f)L!a\u001b!\u0003\t1{gn\u001a\t\u0004#Rk\u0007C\u00018p\u0019\u0001!Q\u0001\u001d\u0001C\u0002E\u0014\u0011!Q\t\u0003eV\u0004\"aP:\n\u0005Q\u0004%a\u0002(pi\"Lgn\u001a\t\u0003\u007fYL!a\u001e!\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0004und\bcA,\u0001[\")Ai\u0001a\u0001\u000b\")Qm\u0001a\u0001M\u0006\u0019\"/Z1e\u0003J\u001c\u0007.\u001b<f\rJ|WNR5mKR\u0019q0a\u0001\u0011\tE#\u0016\u0011\u0001\t\u0004/bk\u0007bBA\u0003\t\u0001\u0007\u0011qA\u0001\bI\u0006\u0014h)\u001b7f!\rI\u0015\u0011B\u0005\u0004\u0003\u0017Q%\u0001\u0002$jY\u0016\f1B]3bI\u0006\u00138\r[5wKR9q0!\u0005\u0002\u0016\u0005\u001d\u0002BBA\n\u000b\u0001\u0007!,\u0001\u0003oC6,\u0007bBA\f\u000b\u0001\u0007\u0011\u0011D\u0001\nI\u0006\u00148\u000b\u001e:fC6\u0004B!a\u0007\u0002$5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#A\u0002{SBT!a\u0015'\n\t\u0005\u0015\u0012Q\u0004\u0002\u000f5&\u0004\u0018J\u001c9viN#(/Z1n\u0011%\tI#\u0002I\u0001\u0002\u0004\tY#\u0001\nf]R\u0014\u0018pU5{KRC'/Z:i_2$\u0007cA \u0002.%\u0019\u0011q\u0006!\u0003\u0007%sG/A\u000bsK\u0006$\u0017I]2iSZ,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U\"\u0006BA\u0016\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\u0002\u0015AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011g2,(\u000f],ji\"\u001c\u0015-\u001e;j_:$b!!\u0014\u0002V\u0005]\u0003\u0003B)U\u0003\u001f\u0002RaPA)S\"K1!a\u0015A\u0005\u0019!V\u000f\u001d7fe!9\u0011qD\u0004A\u0002\u0005e\u0001bBA\u0015\u000f\u0001\u0007\u00111F\u0001\u000fY>\fGMW5q\u000b:$(/[3t)!\tiFa$\u0003\u0012\nM\u0005\u0003B)U\u0003?\u00022!!\u0019\u0013\u001d\t96\"A\u0005ECJ\u0014V-\u00193feB\u0011q\u000bD\n\u0003\u0019y\"\"!!\u001a\u0002\u00195\u000bg.\u001b4fgRt\u0015-\\3\u0016\u0005\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005UD*\u0001\u0003mC:<\u0017bA2\u0002t\u0005iQ*\u00198jM\u0016\u001cHOT1nK\u0002\n!#\u00128uef\u001c\u0016N_3UQJ,7\u000f[8mIV\u0011\u00111F\u0001\u0014\u000b:$(/_*ju\u0016$\u0006N]3tQ>dG\r\t\u0002\u000b5&\u0004XI\u001c;sS\u0016\u001c8C\u0002\n?\u0003\u000b\u000bY\tE\u0002@\u0003\u000fK1!!#A\u0005\u001d\u0001&o\u001c3vGR\u00042aPAG\u0013\r\ty\t\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u00025\u0006)a.Y7fA\u00059QM\u001c;sS\u0016\u001cXCAAM!\u0019Y\u00161\u0014.\u0002P%\u0019\u0011Q\u00143\u0003\u00075\u000b\u0007/\u0001\u0005f]R\u0014\u0018.Z:!)\u0019\t\u0019+a*\u0002*B\u0019\u0011Q\u0015\n\u000e\u00031Aa!a\u0005\u0018\u0001\u0004Q\u0006bBAK/\u0001\u0007\u0011\u0011T\u0001\u0012O\u0016$\u0018J\u001c9viN#(/Z1n\r>\u0014H\u0003BA'\u0003_Ca!!-\u0019\u0001\u0004Q\u0016!C3oiJLh*Y7f\u00035\u0011X-\u00193EC24g*Y7fgR\u0019\u0001+a.\t\u000b\u0011K\u0002\u0019A#\u00025A\f'o]3EC24g*Y7fg\u001a\u0013x.\\'b]&4Wm\u001d;\u0015\u0007A\u000bi\fC\u0003E5\u0001\u0007Q)A\ngS:$G*Z4bGf$\u0015\r\u001c4OC6,7\u000fF\u0001Q\u0003\u0019I7\u000fR1mMR!\u0011qYAg!\ry\u0014\u0011Z\u0005\u0004\u0003\u0017\u0004%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u001fd\u0002\u0019\u0001.\u0002\u0003M\f!\"[:Qe&lG)\u00197g)\u0011\t9-!6\t\r\u0005=W\u00041\u0001[\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\r\u00161\\Ao\u0011!\t\u0019B\bI\u0001\u0002\u0004Q\u0006\"CAK=A\u0005\t\u0019AAM\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a9+\u0007i\u000b9$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%(\u0006BAM\u0003o\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004k\u0006M\b\"CA{G\u0005\u0005\t\u0019AA\u0016\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111 \t\u0006\u0003{\u0014\u0019!^\u0007\u0003\u0003\u007fT1A!\u0001A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000b\tyP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAd\u0005\u0017A\u0001\"!>&\u0003\u0003\u0005\r!^\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111F\u0001\ti>\u001cFO]5oOR\u0011\u0011qN\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d'\u0011\u0004\u0005\t\u0003kD\u0013\u0011!a\u0001k\u0006Q!,\u001b9F]R\u0014\u0018.Z:\u0011\u0007\u0005\u0015&fE\u0003+\u0005C\tY\tE\u0005\u0003$\t%\",!'\u0002$6\u0011!Q\u0005\u0006\u0004\u0005O\u0001\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005W\u0011)CA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\r&1\u0007B\u001b\u0011\u0019\t\u0019\"\fa\u00015\"9\u0011QS\u0017A\u0002\u0005e\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005w\u0011\u0019\u0005E\u0003@\u0005{\u0011\t%C\u0002\u0003@\u0001\u0013aa\u00149uS>t\u0007CB \u0002Ri\u000bI\nC\u0005\u0003F9\n\t\u00111\u0001\u0002$\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0017\u0002B!!\u001d\u0003N%!!qJA:\u0005\u0019y%M[3diR\u0011!1\u000b\t\u0005/\u0002\u0011)\u0006E\u0004@\u0003#\u00129Fa\u001b\u0011\t\te#Q\r\b\u0005\u00057\u0012\t'\u0004\u0002\u0003^)\u0019!qL\u001b\u0002\t\u0011\fG/Y\u0005\u0005\u0005G\u0012i&A\u0002SK\u001aLAAa\u001a\u0003j\tI\u0001+Y2lC\u001e,\u0017\n\u001a\u0006\u0005\u0005G\u0012i\u0006\u0005\u0003\u0003n\ted\u0002\u0002B8\u0005kj!A!\u001d\u000b\u0007\tMt'A\u0006eC6dw\f\u001c4`I\u00164\u0018\u0002\u0002B<\u0005c\na\u0001R1nY23\u0017\u0002\u0002B>\u0005{\u0012a\"\u0011:dQ&4X\rU1zY>\fGM\u0003\u0003\u0003x\tET\u0003\u0002BA\u0005\u000f#BAa!\u0003\nB!q\u000b\u0001BC!\rq'q\u0011\u0003\u0006aF\u0012\r!\u001d\u0005\u0007KF\u0002\rAa#\u0011\r}:\u0017\u000e\u0013BG!\u0011\tFK!\"\t\r\u0005M\u0001\u00021\u0001[\u0011\u001d\t9\u0002\u0003a\u0001\u00033Aq!!\u000b\t\u0001\u0004\tY#\u0001\u0005qCJ\u001cX-\u00117m)\u0011\u0011IJ!.\u0015\t\tm%q\u0016\t\u0005#R\u0013i\nE\u0003\u0003 \n%VN\u0004\u0003\u0003\"\n\u0015fbA/\u0003$&\t\u0011)C\u0002\u0003(\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003,\n5&\u0001\u0002'jgRT1Aa*A\u0011\u001d\u0011\t,\u0003a\u0001\u0005g\u000bQA\\1nKN\u0004RAa(\u0003*jCq!a+\n\u0001\u0004\u00119\fE\u0003@\rj\u000bi%\u0001\u0005qCJ\u001cXm\u00148f)\u0011\u0011iL!1\u0015\u00071\u0014y\f\u0003\u0004\u0002P*\u0001\rA\u0017\u0005\b\u0003WS\u0001\u0019\u0001B\\\u0001")
public class DarReader<A> {
    private final Function1<InputStream, Try<Dar<String>>> readDalfNamesFromManifest;
    private final Function2<Object, InputStream, Try<A>> parseDalf;

    public static <A> DarReader<A> apply(Function2<Object, InputStream, Try<A>> function2) {
        return DarReader$.MODULE$.apply(function2);
    }

    public static DarReader<Tuple2<String, DamlLf.ArchivePayload>> apply() {
        return DarReader$.MODULE$.apply();
    }

    public Try<Dar<A>> readArchiveFromFile(File darFile) {
        return this.readArchive(darFile.getName(), new ZipInputStream(new FileInputStream(darFile)), this.readArchive$default$3());
    }

    public Try<Dar<A>> readArchive(String name, ZipInputStream darStream, int entrySizeThreshold) {
        return TryOps$Bracket$.MODULE$.bracket(Try$.MODULE$.apply((Function0<ZipInputStream> & Serializable & scala.Serializable)() -> darStream), (Function1<ZipInputStream, Try> & Serializable & scala.Serializable)zis -> Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> zis.close())).flatMap((Function1<ZipInputStream, Try> & Serializable & scala.Serializable)zis -> this.loadZipEntries(name, (ZipInputStream)zis, entrySizeThreshold)).flatMap((Function1<ZipEntries, Try> & Serializable & scala.Serializable)entries -> entries.readDalfNames($this.readDalfNamesFromManifest).flatMap((Function1<Dar, Try> & Serializable & scala.Serializable)names -> this.parseOne((Function1<String, Try<Tuple2<Object, InputStream>>>)(Function1<String, Try> & Serializable & scala.Serializable)entryName -> entries.getInputStreamFor((String)entryName), (String)names.main()).flatMap((Function1<Object, Try> & Serializable & scala.Serializable)main -> this.parseAll((Function1<String, Try<Tuple2<Object, InputStream>>>)(Function1<String, Try> & Serializable & scala.Serializable)entryName -> entries.getInputStreamFor((String)entryName), names.dependencies()).map((Function1<List, Dar> & Serializable & scala.Serializable)deps -> new Dar<Object>(main, (List<Object>)deps)))));
    }

    public int readArchive$default$3() {
        return DarReader$.MODULE$.EntrySizeThreshold();
    }

    private Try<Tuple2<Object, InputStream>> slurpWithCaution(ZipInputStream zip, int entrySizeThreshold) {
        return Try$.MODULE$.apply((Function0<Tuple2> & Serializable & scala.Serializable)() -> {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            package$.MODULE$.Iterator().continually((JFunction0$mcI$sp & scala.Serializable)() -> zip.read(buffer)).takeWhile((JFunction1$mcZI$sp & scala.Serializable)x$1 -> x$1 >= 0).withFilter((JFunction1$mcZI$sp & scala.Serializable)n -> n > 0).foreach((JFunction1$mcVI$sp & scala.Serializable)n -> {
                output.write(buffer, 0, n);
                if (output.size() >= entrySizeThreshold) {
                    throw new Errors.ZipBomb();
                }
            });
            return new Tuple2<Long, ByteArrayInputStream>(BoxesRunTime.boxToLong(output.size()), new ByteArrayInputStream(output.toByteArray()));
        });
    }

    private Try<ZipEntries> loadZipEntries(String name, ZipInputStream darStream, int entrySizeThreshold) {
        return this.go$1(new Success<GenMap>(Predef$.MODULE$.Map().empty()), darStream, entrySizeThreshold).map((Function1<Map, ZipEntries> & Serializable & scala.Serializable)x$3 -> new ZipEntries(name, (Map<String, Tuple2<Object, InputStream>>)x$3));
    }

    private Try<List<A>> parseAll(Function1<String, Try<Tuple2<Object, InputStream>>> getInputStreamFor, List<String> names) {
        return TryOps$.MODULE$.sequence(names.map((Function1<String, Try> & Serializable & scala.Serializable)s2 -> this.parseOne(getInputStreamFor, (String)s2), List$.MODULE$.canBuildFrom()));
    }

    private Try<A> parseOne(Function1<String, Try<Tuple2<Object, InputStream>>> getInputStreamFor, String s2) {
        return TryOps$Bracket$.MODULE$.bracket(getInputStreamFor.apply(s2), (Function1<Tuple2, Try> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            InputStream is = (InputStream)tuple2._2();
            Try try_ = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> is.close());
            return try_;
        }).flatMap((Function1<Tuple2, Try> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long size = tuple2._1$mcJ$sp();
            InputStream is = (InputStream)tuple2._2();
            Try try_ = $this.parseDalf.apply(BoxesRunTime.boxToLong(size), is);
            return try_;
        });
    }

    private final Try go$1(Try accT, ZipInputStream darStream$2, int entrySizeThreshold$3) {
        Option<ZipEntry> option2;
        while ((option2 = Option$.MODULE$.apply(darStream$2.getNextEntry())) instanceof Some) {
            Some some = (Some)option2;
            ZipEntry entry = (ZipEntry)some.value();
            accT = accT.flatMap((Function1<Map, Try> & Serializable & scala.Serializable)acc -> TryOps$Bracket$.MODULE$.bracket(this.slurpWithCaution(darStream$2, entrySizeThreshold$3), (Function1<Tuple2, Try> & Serializable & scala.Serializable)x$2 -> Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> darStream$2.closeEntry())).map((Function1<Tuple2, Map> & Serializable & scala.Serializable)sizedBytes -> acc.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getName()), sizedBytes))));
        }
        if (!None$.MODULE$.equals(option2)) {
            throw new MatchError(option2);
        }
        Try try_ = accT;
        return try_;
    }

    public DarReader(Function1<InputStream, Try<Dar<String>>> readDalfNamesFromManifest, Function2<Object, InputStream, Try<A>> parseDalf) {
        this.readDalfNamesFromManifest = readDalfNamesFromManifest;
        this.parseDalf = parseDalf;
    }

    public static class ZipEntries
    implements Product,
    scala.Serializable {
        private final String name;
        private final Map<String, Tuple2<Object, InputStream>> entries;

        public String name() {
            return this.name;
        }

        public Map<String, Tuple2<Object, InputStream>> entries() {
            return this.entries;
        }

        public Try<Tuple2<Object, InputStream>> getInputStreamFor(String entryName) {
            Try try_;
            Some some;
            Tuple2 tuple2;
            Option option2 = this.entries().get(entryName);
            if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                long size = tuple2._1$mcJ$sp();
                InputStream is = (InputStream)tuple2._2();
                try_ = new Success<Tuple2<Long, InputStream>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToLong(size)), is));
            } else if (None$.MODULE$.equals(option2)) {
                try_ = new Failure<Tuple2<Object, InputStream>>(new Errors.InvalidZipEntry(entryName, this));
            } else {
                throw new MatchError(option2);
            }
            return try_;
        }

        public Try<Dar<String>> readDalfNames(Function1<InputStream, Try<Dar<String>>> readDalfNamesFromManifest) {
            return this.parseDalfNamesFromManifest(readDalfNamesFromManifest).recoverWith(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZipEntries $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option<Throwable> option2 = NonFatal$.MODULE$.unapply(A1);
                    if (!option2.isEmpty()) {
                        Throwable e1 = option2.get();
                        object = this.$outer.com$daml$lf$archive$DarReader$ZipEntries$$findLegacyDalfNames().recoverWith(new scala.Serializable(this, e1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ZipEntries$$anonfun$readDalfNames$1 $outer;
                            private final Throwable e1$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Option<Throwable> option2 = NonFatal$.MODULE$.unapply(A1);
                                Object object = !option2.isEmpty() ? new Failure<T>(new Errors.InvalidDar(this.$outer.com$daml$lf$archive$DarReader$ZipEntries$$anonfun$$$outer(), this.e1$1)) : function1.apply(x1);
                                return object;
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable2 = x1;
                                Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                                boolean bl = !option2.isEmpty();
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.e1$1 = e1$1;
                            }
                        });
                    } else {
                        object = function1.apply(x1);
                    }
                    return object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable2 = x1;
                    Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                    boolean bl = !option2.isEmpty();
                    return bl;
                }

                public /* synthetic */ ZipEntries com$daml$lf$archive$DarReader$ZipEntries$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        private Try<Dar<String>> parseDalfNamesFromManifest(Function1<InputStream, Try<Dar<String>>> readDalfNamesFromManifest) {
            return TryOps$Bracket$.MODULE$.bracket(this.getInputStreamFor(DarReader$.MODULE$.com$daml$lf$archive$DarReader$$ManifestName()), (Function1<Tuple2, Try> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                InputStream is = (InputStream)tuple2._2();
                Try try_ = Try$.MODULE$.apply((JFunction0$mcV$sp & scala.Serializable)() -> is.close());
                return try_;
            }).flatMap((Function1<Tuple2, Try> & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                InputStream is = (InputStream)tuple2._2();
                Try try_ = (Try)readDalfNamesFromManifest.apply(is);
                return try_;
            });
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Try<Dar<String>> com$daml$lf$archive$DarReader$ZipEntries$$findLegacyDalfNames() {
            void var1_13;
            List dalfs = ((TraversableOnce)this.entries().keys().filter((Function1<String, Object> & Serializable & scala.Serializable)s2 -> BoxesRunTime.boxToBoolean(this.isDalf(s2)))).toList();
            Tuple2 tuple2 = dalfs.partition((Function1<String, Object> & Serializable & scala.Serializable)s2 -> BoxesRunTime.boxToBoolean(this.isPrimDalf(s2)));
            if (tuple2 != null) {
                List list2 = (List)tuple2._1();
                List list3 = (List)tuple2._2();
                Some<List> some = List$.MODULE$.unapplySeq(list2);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                    String prim = (String)((LinearSeqOptimized)some.get()).apply(0);
                    Some<List> some2 = List$.MODULE$.unapplySeq(list3);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                        String main = (String)((LinearSeqOptimized)some2.get()).apply(0);
                        Success<Dar<Nothing$>> success = new Success<Dar<Nothing$>>(new Dar<Nothing$>((Nothing$)((Object)main), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)prim), Nil$.MODULE$)));
                        return var1_13;
                    }
                }
            }
            if (tuple2 != null) {
                List list4 = (List)tuple2._1();
                List list5 = (List)tuple2._2();
                Some<List> some = List$.MODULE$.unapplySeq(list4);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                    String prim = (String)((LinearSeqOptimized)some.get()).apply(0);
                    if (((Object)Nil$.MODULE$).equals(list5)) {
                        Success<Dar<String>> success = new Success<Dar<String>>(new Dar<String>(prim, (List<String>)List$.MODULE$.empty()));
                        return var1_13;
                    }
                }
            }
            if (tuple2 != null) {
                Some<List> some;
                List list6 = (List)tuple2._1();
                List list7 = (List)tuple2._2();
                if (((Object)Nil$.MODULE$).equals(list6) && !(some = List$.MODULE$.unapplySeq(list7)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
                    String main = (String)((LinearSeqOptimized)some.get()).apply(0);
                    Success<Dar<String>> success = new Success<Dar<String>>(new Dar<String>(main, (List<String>)List$.MODULE$.empty()));
                    return var1_13;
                }
            }
            Failure failure = new Failure(new Errors.InvalidLegacyDar(this));
            return var1_13;
        }

        private boolean isDalf(String s2) {
            return s2.toLowerCase().endsWith(".dalf");
        }

        private boolean isPrimDalf(String s2) {
            return s2.toLowerCase().contains("-prim") && this.isDalf(s2);
        }

        public ZipEntries copy(String name, Map<String, Tuple2<Object, InputStream>> entries) {
            return new ZipEntries(name, entries);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Map<String, Tuple2<Object, InputStream>> copy$default$2() {
            return this.entries();
        }

        @Override
        public String productPrefix() {
            return "ZipEntries";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.name();
                    break;
                }
                case 1: {
                    object = this.entries();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ZipEntries;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ZipEntries)) return false;
            boolean bl = true;
            if (!bl) return false;
            ZipEntries zipEntries = (ZipEntries)x$1;
            String string2 = this.name();
            String string3 = zipEntries.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Map<String, Tuple2<Object, InputStream>> map2 = this.entries();
            Map<String, Tuple2<Object, InputStream>> map3 = zipEntries.entries();
            if (map2 == null) {
                if (map3 != null) {
                    return false;
                }
            } else if (!map2.equals(map3)) return false;
            if (!zipEntries.canEqual(this)) return false;
            return true;
        }

        public ZipEntries(String name, Map<String, Tuple2<Object, InputStream>> entries) {
            this.name = name;
            this.entries = entries;
            Product.$init$(this);
        }
    }
}

