/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.codegen.backend.java.inner;

import com.daml.ledger.javaapi.data.Value;
import com.daml.ledger.javaapi.data.Variant;
import com.daml.lf.codegen.TypeWithContext;
import com.daml.lf.codegen.backend.java.JavaEscaper$;
import com.daml.lf.codegen.backend.java.inner.FieldInfo;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters;
import com.daml.lf.codegen.backend.java.inner.FromValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.ToValueExtractorParameters$;
import com.daml.lf.codegen.backend.java.inner.TrackLineage$;
import com.daml.lf.codegen.backend.java.inner.VariantConstructorClass$;
import com.daml.lf.codegen.backend.java.inner.VariantRecordClass$;
import com.daml.lf.codegen.backend.java.inner.package$;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$ImmArraySeq$;
import com.daml.lf.data.Ref;
import com.daml.lf.iface.DataType;
import com.daml.lf.iface.DefDataType;
import com.daml.lf.iface.Enum;
import com.daml.lf.iface.InterfaceType;
import com.daml.lf.iface.Record;
import com.daml.lf.iface.TypeCon;
import com.daml.lf.iface.TypeConName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Type;
import javax.lang.model.element.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class VariantClass$
implements StrictLogging {
    public static VariantClass$ MODULE$;
    private final Logger logger;

    static {
        new VariantClass$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Tuple2<TypeSpec, List<TypeSpec>> generate(ClassName variantClassName, String subPackage, IndexedSeq<String> typeArguments, com.daml.lf.iface.Variant<com.daml.lf.iface.Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes) {
        return (Tuple2)TrackLineage$.MODULE$.of("variant", typeWithContext.name(), (Function0<Tuple2> & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Start");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            IndexedSeq<FieldInfo> constructorInfo = package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes);
            TypeSpec variantType = TypeSpec.classBuilder(variantClassName).addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addTypeVariables(JavaConverters$.MODULE$.asJavaIterableConverter(typeArguments.map((Function1<String, TypeVariableName> & Serializable & scala.Serializable)x$1 -> TypeVariableName.get(x$1), IndexedSeq$.MODULE$.canBuildFrom())).asJava()).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).build()).addMethod(MODULE$.generateAbstractToValueSpec(typeArguments)).addMethod(MODULE$.generateFromValue(typeArguments, constructorInfo, variantClassName, subPackage)).build();
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("End");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            List<TypeSpec> constructors = MODULE$.generateConstructorClasses(typeArguments, variant, typeWithContext, packagePrefixes, variantClassName);
            return new Tuple2<TypeSpec, List<TypeSpec>>(variantType, constructors);
        });
    }

    private boolean isRecord(InterfaceType interfaceType) {
        boolean bl;
        DataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> dataType = interfaceType.type().dataType();
        if (dataType instanceof Record) {
            bl = true;
        } else {
            boolean bl2 = dataType instanceof com.daml.lf.iface.Variant ? true : dataType instanceof Enum;
            if (bl2) {
                bl = false;
            } else {
                throw new MatchError(dataType);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVariantRecord(TypeWithContext typeWithContext, String constructor, Ref.Identifier identifier) {
        if (!typeWithContext.interface().typeDecls().get(identifier.qualifiedName()).exists((Function1<InterfaceType, Object> & Serializable & scala.Serializable)interfaceType -> BoxesRunTime.boxToBoolean(VariantClass$.MODULE$.isRecord(interfaceType)))) return false;
        Ref.DottedName dottedName = typeWithContext.identifier().qualifiedName().module();
        Ref.DottedName dottedName2 = identifier.qualifiedName().module();
        if (dottedName == null) {
            if (dottedName2 != null) {
                return false;
            }
        } else if (!((Object)dottedName).equals(dottedName2)) return false;
        ImmArray<String> immArray = typeWithContext.identifier().qualifiedName().name().segments();
        ImmArray<String> immArray2 = identifier.qualifiedName().name().segments().init();
        if (immArray == null) {
            if (immArray2 != null) {
                return false;
            }
        } else if (!((Object)immArray).equals(immArray2)) return false;
        String string2 = constructor;
        String string3 = identifier.qualifiedName().name().segments().last();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    private MethodSpec generateAbstractToValueSpec(IndexedSeq<String> typeArgs) {
        return MethodSpec.methodBuilder("toValue").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).addParameters(JavaConverters$.MODULE$.asJavaIterableConverter(ToValueExtractorParameters$.MODULE$.generate(typeArgs)).asJava()).returns((Type)((Object)Value.class)).build();
    }

    private MethodSpec.Builder initFromValueBuilder(TypeName t) {
        return MethodSpec.methodBuilder("fromValue").addModifiers(Modifier.STATIC, Modifier.PUBLIC).returns(t).addParameter((Type)((Object)Value.class), "value$", new Modifier[0]);
    }

    private CodeBlock variantExtractor(TypeName t) {
        return CodeBlock.of("$T variant$$ = value$$.asVariant().orElseThrow(() -> new IllegalArgumentException($S))", Variant.class, new StringBuilder(53).append("Expected Variant to build an instance of the Variant ").append(t).toString());
    }

    private MethodSpec.Builder switchOnConstructor(MethodSpec.Builder builder, IndexedSeq<FieldInfo> constructors, ClassName variant, String subPackage, Function1<String, CodeBlock> useConstructor) {
        BoxedUnit boxedUnit;
        String constructorsAsString = ((TraversableOnce)constructors.map((Function1<FieldInfo, String> & Serializable & scala.Serializable)x$1 -> x$1.damlName(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating switch on constructors {} for {}", new Object[]{constructorsAsString, variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        constructors.foreach((Function1<FieldInfo, MethodSpec.Builder> & Serializable & scala.Serializable)constructorInfo -> builder.beginControlFlow("if ($S.equals(variant$$.getConstructor()))", constructorInfo.damlName()).addStatement((CodeBlock)useConstructor.apply(new $colon$colon<Nothing$>((Nothing$)((Object)subPackage), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)constructorInfo.javaName()), Nil$.MODULE$)).mkString("."))).endControlFlow());
        return builder.addStatement("throw new IllegalArgumentException($S)", new StringBuilder(82).append("Found unknown constructor variant$.getConstructor() for variant ").append(variant).append(", expected one of ").append(constructorsAsString).toString());
    }

    private MethodSpec generateParameterizedFromValue(ParameterizedTypeName variant, IndexedSeq<FieldInfo> constructors, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", new Object[]{variant});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.require(((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(variant.typeArguments).asScala()).forall((Function1<TypeName, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(VariantClass$.$anonfun$generateParameterizedFromValue$1(x$2))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(38).append("All type arguments of ").append(variant$2.rawType).append(" must be generic").toString());
        MethodSpec.Builder builder = this.initFromValueBuilder(variant);
        FromValueExtractorParameters typeVariablesExtractorParameters = FromValueExtractorParameters$.MODULE$.generate(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(variant.typeArguments).asScala()).map((Function1<TypeName, String> & Serializable & scala.Serializable)x$3 -> x$3.toString(), Iterable$.MODULE$.canBuildFrom())).toIndexedSeq());
        builder.addTypeVariables(JavaConverters$.MODULE$.asJavaIterableConverter(typeVariablesExtractorParameters.typeVariables()).asJava());
        builder.addParameters(JavaConverters$.MODULE$.asJavaIterableConverter(typeVariablesExtractorParameters.parameterSpecs()).asJava());
        builder.addStatement("$L", this.variantExtractor(variant.rawType));
        CodeBlock extractors = CodeBlock.join(JavaConverters$.MODULE$.asJavaIterableConverter(((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(variant.typeArguments).asScala()).map((Function1<TypeName, CodeBlock> & Serializable & scala.Serializable)t -> CodeBlock.of("$L", new StringBuilder(9).append("fromValue").append(t).toString()), Iterable$.MODULE$.canBuildFrom())).asJava(), ", ");
        this.switchOnConstructor(builder, constructors, variant.rawType, subPackage, (Function1<String, CodeBlock> & Serializable & scala.Serializable)constructor -> CodeBlock.of("return $L.fromValue(variant$$, $L)", constructor, extractors));
        return builder.build();
    }

    private MethodSpec generateConcreteFromValue(ClassName t, IndexedSeq<FieldInfo> constructors, String subPackage) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating fromValue static method for {}", new Object[]{t});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MethodSpec.Builder builder = this.initFromValueBuilder(t).addStatement("$L", this.variantExtractor(t));
        this.switchOnConstructor(builder, constructors, t, subPackage, (Function1<String, CodeBlock> & Serializable & scala.Serializable)c -> CodeBlock.of("return $L.fromValue(variant$$)", c));
        return builder.build();
    }

    private MethodSpec generateFromValue(IndexedSeq<String> typeArguments, IndexedSeq<FieldInfo> constructorInfo, ClassName variantClassName, String subPackage) {
        MethodSpec methodSpec;
        TypeName typeName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArguments);
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            methodSpec = this.generateConcreteFromValue(className, constructorInfo, subPackage);
        } else if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            methodSpec = this.generateParameterizedFromValue(parameterizedTypeName, constructorInfo, subPackage);
        } else {
            throw new IllegalArgumentException("Required either ClassName or ParameterizedTypeName");
        }
        return methodSpec;
    }

    private List<TypeSpec> generateConstructorClasses(IndexedSeq<String> typeArgs, com.daml.lf.iface.Variant<com.daml.lf.iface.Type> variant, TypeWithContext typeWithContext, Map<String, String> packagePrefixes, ClassName variantClassName) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Generating inner classes");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ArrayBuffer innerClasses = new ArrayBuffer();
        HashSet variantRecords = new HashSet();
        TypeName fullVariantClassName = package$.MODULE$.ClassNameExtensions(variantClassName).parameterized(typeArgs);
        package$.MODULE$.getFieldsWithTypes(variant.fields(), packagePrefixes).withFilter((Function1<FieldInfo, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(VariantClass$.$anonfun$generateConstructorClasses$1(check$ifrefutable$1))).foreach((Function1<FieldInfo, Object> & Serializable & scala.Serializable)x$4 -> {
            Object object;
            FieldInfo fieldInfo = x$4;
            if (fieldInfo != null) {
                Ref.Identifier id2;
                TypeCon typeCon;
                TypeConName typeConName;
                String damlName = fieldInfo.damlName();
                com.daml.lf.iface.Type damlType = fieldInfo.damlType();
                String javaName = fieldInfo.javaName();
                com.daml.lf.iface.Type type = damlType;
                if (type instanceof TypeCon && (typeConName = (typeCon = (TypeCon)type).name()) != null && MODULE$.isVariantRecord(typeWithContext, damlName, id2 = typeConName.identifier())) {
                    object = BoxesRunTime.boxToBoolean(variantRecords.add(damlName));
                } else {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isDebugEnabled()) {
                        MODULE$.logger().underlying().debug("{} is trivial", new Object[]{damlName});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = innerClasses.$plus$eq(VariantConstructorClass$.MODULE$.generate(fullVariantClassName, typeArgs, damlName, javaName, damlType, packagePrefixes));
                }
            } else {
                throw new MatchError(fieldInfo);
            }
            Growable growable = object;
            return growable;
        });
        typeWithContext.typesLineages().map((Function1<TypeWithContext, Object> & Serializable & scala.Serializable)child -> {
            Object object;
            block10: {
                block7: {
                    DataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> record;
                    ImmArray.ImmArraySeq<String> typeVars;
                    block9: {
                        block8: {
                            InterfaceType.Normal normal;
                            DefDataType<com.daml.lf.iface.Type, com.daml.lf.iface.Type> defDataType;
                            Some some;
                            InterfaceType interfaceType;
                            BoxedUnit boxedUnit;
                            if (!variantRecords.contains(child.name())) break block7;
                            if (MODULE$.logger().underlying().isDebugEnabled()) {
                                MODULE$.logger().underlying().debug("{} is a variant record", new Object[]{child.name()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Option<InterfaceType> option2 = child.type().typ();
                            if (!(option2 instanceof Some) || !((interfaceType = (InterfaceType)(some = (Some)option2).value()) instanceof InterfaceType.Normal) || (defDataType = (normal = (InterfaceType.Normal)interfaceType).type()) == null) break block8;
                            typeVars = defDataType.typeVars();
                            record = defDataType.dataType();
                            if (record instanceof Record) break block9;
                        }
                        String c = new StringBuilder(1).append(typeWithContext.name()).append(".").append(child.name()).toString();
                        throw new IllegalArgumentException(new StringBuilder(55).append("Underlying type of constructor ").append(c).append(" is not Record (found: ").append(child.type().typ()).append(")").toString());
                    }
                    Record record2 = (Record)record;
                    Growable growable = innerClasses.$plus$eq(VariantRecordClass$.MODULE$.generate(typeVars.map((Function1<String, String> & Serializable & scala.Serializable)s2 -> JavaEscaper$.MODULE$.escapeString((String)s2), ImmArray$ImmArraySeq$.MODULE$.canBuildFrom()), package$.MODULE$.getFieldsWithTypes(record2.fields(), packagePrefixes), child.name(), fullVariantClassName, packagePrefixes).build());
                    object = growable;
                    break block10;
                }
                if (MODULE$.logger().underlying().isDebugEnabled()) {
                    MODULE$.logger().underlying().debug("{} is an unrelated inner type", new Object[]{child.name()});
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        }, Iterable$.MODULE$.canBuildFrom());
        return innerClasses.toList();
    }

    public static final /* synthetic */ boolean $anonfun$generateParameterizedFromValue$1(TypeName x$2) {
        return x$2 instanceof TypeVariableName;
    }

    public static final /* synthetic */ boolean $anonfun$generateConstructorClasses$1(FieldInfo check$ifrefutable$1) {
        FieldInfo fieldInfo = check$ifrefutable$1;
        boolean bl = fieldInfo != null;
        return bl;
    }

    private VariantClass$() {
        MODULE$ = this;
        StrictLogging.$init$(this);
    }
}

