/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.PolyUpperBound;
import org.checkerframework.checker.index.qual.SubstringIndexFor;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public abstract class UBQualifier {
    public static UBQualifier createUBQualifier(AnnotationMirror am) {
        if (AnnotationUtils.areSameByClass(am, UpperBoundUnknown.class)) {
            return UpperBoundUnknownQualifier.UNKNOWN;
        }
        if (AnnotationUtils.areSameByClass(am, UpperBoundBottom.class)) {
            return UpperBoundBottomQualifier.BOTTOM;
        }
        if (AnnotationUtils.areSameByClass(am, LTLengthOf.class) || AnnotationUtils.areSameByClass(am, SubstringIndexFor.class)) {
            return UBQualifier.parseLTLengthOf(am);
        }
        if (AnnotationUtils.areSameByClass(am, LTEqLengthOf.class)) {
            return UBQualifier.parseLTEqLengthOf(am);
        }
        if (AnnotationUtils.areSameByClass(am, LTOMLengthOf.class)) {
            return UBQualifier.parseLTOMLengthOf(am);
        }
        if (AnnotationUtils.areSameByClass(am, PolyUpperBound.class)) {
            return PolyQualifier.POLY;
        }
        assert (false);
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    private static UBQualifier parseLTLengthOf(AnnotationMirror am) {
        List<String> sequences = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = AnnotationUtils.getElementValueArray(am, "offset", String.class, true);
        if (offset.isEmpty()) {
            offset = Collections.nCopies(sequences.size(), "");
        }
        return UBQualifier.createUBQualifier(sequences, offset);
    }

    private static UBQualifier parseLTEqLengthOf(AnnotationMirror am) {
        List<String> sequences = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = Collections.nCopies(sequences.size(), "-1");
        return UBQualifier.createUBQualifier(sequences, offset);
    }

    private static UBQualifier parseLTOMLengthOf(AnnotationMirror am) {
        List<String> sequences = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = Collections.nCopies(sequences.size(), "1");
        return UBQualifier.createUBQualifier(sequences, offset);
    }

    public static UBQualifier createUBQualifier(String sequence, String offset) {
        return UBQualifier.createUBQualifier(Collections.singletonList(sequence), Collections.singletonList(offset));
    }

    public static UBQualifier createUBQualifier(AnnotatedTypeMirror type, AnnotationMirror top) {
        return UBQualifier.createUBQualifier(type.getEffectiveAnnotationInHierarchy(top));
    }

    public static UBQualifier createUBQualifier(List<String> sequences, List<String> offsets) {
        assert (!sequences.isEmpty());
        HashMap<String, Set<OffsetEquation>> map2 = new HashMap<String, Set<OffsetEquation>>();
        if (offsets.isEmpty()) {
            for (String sequence : sequences) {
                map2.put(sequence, Collections.singleton(OffsetEquation.ZERO));
            }
        } else {
            assert (sequences.size() == offsets.size());
            for (int i = 0; i < sequences.size(); ++i) {
                OffsetEquation eq2;
                String sequence = sequences.get(i);
                String offset = offsets.get(i);
                HashSet<OffsetEquation> set2 = (HashSet<OffsetEquation>)map2.get(sequence);
                if (set2 == null) {
                    set2 = new HashSet<OffsetEquation>();
                    map2.put(sequence, set2);
                }
                if ((eq2 = OffsetEquation.createOffsetFromJavaExpression(offset)).hasError()) {
                    return UpperBoundUnknownQualifier.UNKNOWN;
                }
                set2.add(eq2);
            }
        }
        return new LessThanLengthOf(map2);
    }

    public UBQualifier plusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier plusOffset(int value) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier minusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier minusOffset(int value) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public boolean isLessThanLengthQualifier() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isPoly() {
        return false;
    }

    public abstract boolean isSubtype(UBQualifier var1);

    public abstract UBQualifier lub(UBQualifier var1);

    public UBQualifier widenUpperBound(UBQualifier obj) {
        return this.lub(obj);
    }

    public abstract UBQualifier glb(UBQualifier var1);

    public boolean isLessThanLengthOf(String sequence) {
        return false;
    }

    public boolean isLessThanLengthOfAny(List<String> sequences) {
        return false;
    }

    public boolean hasSequenceWithOffset(String sequence, int offset) {
        return false;
    }

    public boolean hasSequenceWithOffset(String sequence, String offset) {
        return false;
    }

    public boolean isLessThanOrEqualTo(String sequence) {
        return false;
    }

    private static class PolyQualifier
    extends UBQualifier {
        static final UBQualifier POLY = new PolyQualifier();

        private PolyQualifier() {
        }

        @Override
        public boolean isPoly() {
            return true;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            return superType.isUnknown() || superType.isPoly();
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            if (other.isPoly() || other.isBottom()) {
                return this;
            }
            return UpperBoundUnknownQualifier.UNKNOWN;
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            if (other.isPoly() || other.isUnknown()) {
                return this;
            }
            return UpperBoundBottomQualifier.BOTTOM;
        }
    }

    private static class UpperBoundBottomQualifier
    extends UBQualifier {
        static final UBQualifier BOTTOM = new UpperBoundBottomQualifier();

        private UpperBoundBottomQualifier() {
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            return other;
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            return this;
        }

        public String toString() {
            return "BOTTOM";
        }
    }

    public static class UpperBoundUnknownQualifier
    extends UBQualifier {
        static final UBQualifier UNKNOWN = new UpperBoundUnknownQualifier();

        private UpperBoundUnknownQualifier() {
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            return superType.isUnknown();
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            return this;
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            return other;
        }

        public String toString() {
            return "UNKNOWN";
        }
    }

    public static class LessThanLengthOf
    extends UBQualifier {
        private final Map<String, Set<OffsetEquation>> map;

        private LessThanLengthOf(Map<String, Set<OffsetEquation>> map2) {
            assert (!map2.isEmpty());
            this.map = map2;
        }

        @Override
        public boolean hasSequenceWithOffset(String sequence, int offset) {
            Set<OffsetEquation> offsets = this.map.get(sequence);
            if (offsets == null) {
                return false;
            }
            return offsets.contains(OffsetEquation.createOffsetForInt(offset));
        }

        @Override
        public boolean hasSequenceWithOffset(String sequence, String offset) {
            Set<OffsetEquation> offsets = this.map.get(sequence);
            if (offsets == null) {
                return false;
            }
            OffsetEquation target = OffsetEquation.createOffsetFromJavaExpression(offset);
            return offsets.contains(target);
        }

        @Override
        public boolean isLessThanOrEqualTo(String sequence) {
            return this.isLessThanLengthOf(sequence) || this.hasSequenceWithOffset(sequence, -1);
        }

        @Override
        public boolean isLessThanLengthOfAny(List<String> sequences) {
            for (String sequence : sequences) {
                if (!this.isLessThanLengthOf(sequence)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isLessThanLengthOf(String sequence) {
            Set<OffsetEquation> offsets = this.map.get(sequence);
            if (offsets == null) {
                return false;
            }
            if (offsets.isEmpty()) {
                return true;
            }
            for (OffsetEquation offset : offsets) {
                if (!offset.isNonNegative()) continue;
                return true;
            }
            return false;
        }

        public AnnotationMirror convertToAnnotation(ProcessingEnvironment env) {
            return this.convertToAnnotation(env, false);
        }

        public AnnotationMirror convertToSubstringIndexAnnotation(ProcessingEnvironment env) {
            return this.convertToAnnotation(env, true);
        }

        private AnnotationMirror convertToAnnotation(ProcessingEnvironment env, boolean buildSubstringIndexAnnotation) {
            AnnotationBuilder builder;
            ArrayList<String> sortedSequences = new ArrayList<String>(this.map.keySet());
            Collections.sort(sortedSequences);
            ArrayList<String> sequences = new ArrayList<String>();
            ArrayList<String> offsets = new ArrayList<String>();
            boolean isLTEq = true;
            boolean isLTOM = true;
            for (String sequence : sortedSequences) {
                ArrayList<String> sortOffsets = new ArrayList<String>();
                for (OffsetEquation eq2 : this.map.get(sequence)) {
                    isLTEq = isLTEq && eq2.equals(OffsetEquation.NEG_1);
                    isLTOM = isLTOM && eq2.equals(OffsetEquation.ONE);
                    sortOffsets.add(eq2.toString());
                }
                Collections.sort(sortOffsets);
                for (String offset : sortOffsets) {
                    sequences.add(sequence);
                    offsets.add(offset);
                }
            }
            if (buildSubstringIndexAnnotation) {
                builder = new AnnotationBuilder(env, SubstringIndexFor.class);
                builder.setValue((CharSequence)"value", sequences);
                builder.setValue((CharSequence)"offset", offsets);
            } else if (isLTEq) {
                builder = new AnnotationBuilder(env, LTEqLengthOf.class);
                builder.setValue((CharSequence)"value", sequences);
            } else if (isLTOM) {
                builder = new AnnotationBuilder(env, LTOMLengthOf.class);
                builder.setValue((CharSequence)"value", sequences);
            } else {
                builder = new AnnotationBuilder(env, LTLengthOf.class);
                builder.setValue((CharSequence)"value", sequences);
                builder.setValue((CharSequence)"offset", offsets);
            }
            return builder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LessThanLengthOf qualifier = (LessThanLengthOf)o;
            if (LessThanLengthOf.containsSame(this.map.keySet(), qualifier.map.keySet())) {
                for (Map.Entry<String, Set<OffsetEquation>> entry : this.map.entrySet()) {
                    Set<OffsetEquation> thisOffset;
                    Set<OffsetEquation> otherOffset = qualifier.map.get(entry.getKey());
                    if (LessThanLengthOf.containsSame(otherOffset, thisOffset = entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static <T> boolean containsSame(Set<T> set1, Set<T> set2) {
            return set1.containsAll(set2) && set2.containsAll(set1);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean isLessThanLengthQualifier() {
            return true;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            if (superType.isUnknown()) {
                return true;
            }
            if (superType.isBottom()) {
                return false;
            }
            LessThanLengthOf superTypeLTL = (LessThanLengthOf)superType;
            if (!this.map.keySet().containsAll(superTypeLTL.map.keySet())) {
                return false;
            }
            for (Map.Entry<String, Set<OffsetEquation>> entry : superTypeLTL.map.entrySet()) {
                String sequence = entry.getKey();
                Set<OffsetEquation> superOffsets = entry.getValue();
                Set<OffsetEquation> subOffsets = this.map.get(sequence);
                if (this.isSubtypeOffset(subOffsets, superOffsets)) continue;
                return false;
            }
            return true;
        }

        private boolean isSubtypeOffset(Set<OffsetEquation> subOffsets, Set<OffsetEquation> superOffsets) {
            for (OffsetEquation superOffset : superOffsets) {
                boolean oneIsSubtype = false;
                for (OffsetEquation subOffset : subOffsets) {
                    if (!superOffset.lessThanOrEqual(subOffset)) continue;
                    oneIsSubtype = true;
                    break;
                }
                if (oneIsSubtype) continue;
                return false;
            }
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            if (other.isUnknown()) {
                return other;
            }
            if (other.isBottom()) {
                return this;
            }
            LessThanLengthOf otherLtl = (LessThanLengthOf)other;
            HashSet<String> sequences = new HashSet<String>(this.map.keySet());
            sequences.retainAll(otherLtl.map.keySet());
            HashMap<String, Set<OffsetEquation>> lubMap = new HashMap<String, Set<OffsetEquation>>();
            for (String sequence : sequences) {
                HashSet<OffsetEquation> lub = new HashSet<OffsetEquation>();
                Set<OffsetEquation> offsets1 = this.map.get(sequence);
                Set<OffsetEquation> offsets2 = otherLtl.map.get(sequence);
                for (OffsetEquation offset1 : offsets1) {
                    for (OffsetEquation offset2 : offsets2) {
                        if (offset2.lessThanOrEqual(offset1)) {
                            lub.add(offset2);
                            continue;
                        }
                        if (!offset1.lessThanOrEqual(offset2)) continue;
                        lub.add(offset1);
                    }
                }
                if (lub.isEmpty()) continue;
                lubMap.put(sequence, lub);
            }
            if (lubMap.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return new LessThanLengthOf(lubMap);
        }

        @Override
        public UBQualifier widenUpperBound(UBQualifier obj) {
            UBQualifier lub = this.lub(obj);
            if (!lub.isLessThanLengthQualifier() || !obj.isLessThanLengthQualifier()) {
                return lub;
            }
            Map<String, Set<OffsetEquation>> lubMap = ((LessThanLengthOf)lub).map;
            this.widenLub((LessThanLengthOf)obj, lubMap);
            if (lubMap.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return new LessThanLengthOf(lubMap);
        }

        private void widenLub(LessThanLengthOf other, Map<String, Set<OffsetEquation>> lubMap) {
            if (!LessThanLengthOf.containsSame(this.map.keySet(), lubMap.keySet()) || !LessThanLengthOf.containsSame(other.map.keySet(), lubMap.keySet())) {
                return;
            }
            ArrayList<Pair<String, OffsetEquation>> remove = new ArrayList<Pair<String, OffsetEquation>>();
            for (Map.Entry<String, Set<OffsetEquation>> entry : lubMap.entrySet()) {
                String sequence = entry.getKey();
                Set<OffsetEquation> lubOffsets = entry.getValue();
                Set<OffsetEquation> thisOffsets = this.map.get(sequence);
                Set<OffsetEquation> otherOffsets = other.map.get(sequence);
                if (lubOffsets.size() != thisOffsets.size() || lubOffsets.size() != otherOffsets.size()) {
                    return;
                }
                for (OffsetEquation lubEq : lubOffsets) {
                    if (lubEq.isInt()) {
                        int otherInt;
                        int thisInt = OffsetEquation.getIntOffsetEquation(thisOffsets).getInt();
                        if (thisInt == (otherInt = OffsetEquation.getIntOffsetEquation(otherOffsets).getInt())) continue;
                        remove.add(Pair.of(sequence, lubEq));
                        continue;
                    }
                    if (thisOffsets.contains(lubEq) && otherOffsets.contains(lubEq)) continue;
                    return;
                }
            }
            for (Pair pair : remove) {
                Set<OffsetEquation> offsets = lubMap.get(pair.first);
                offsets.remove(pair.second);
                if (!offsets.isEmpty()) continue;
                lubMap.remove(pair.first);
            }
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            if (other.isUnknown()) {
                return this;
            }
            if (other.isBottom()) {
                return other;
            }
            LessThanLengthOf otherLtl = (LessThanLengthOf)other;
            HashSet<String> sequences = new HashSet<String>(this.map.keySet());
            sequences.addAll(otherLtl.map.keySet());
            HashMap<String, Set<OffsetEquation>> glbMap = new HashMap<String, Set<OffsetEquation>>();
            for (String sequence : sequences) {
                Set<OffsetEquation> glb = this.map.get(sequence);
                Set<OffsetEquation> otherglb = otherLtl.map.get(sequence);
                if (glb == null) {
                    glb = otherglb;
                } else if (otherglb != null) {
                    glb.addAll(otherglb);
                }
                glbMap.put(sequence, this.simplifyOffsets(glb));
            }
            return new LessThanLengthOf(glbMap);
        }

        private Set<OffsetEquation> simplifyOffsets(Set<OffsetEquation> offsets) {
            HashSet<OffsetEquation> newOff = new HashSet<OffsetEquation>();
            OffsetEquation literal = null;
            for (OffsetEquation eq2 : offsets) {
                if (eq2.isInt()) {
                    if (literal == null) {
                        literal = eq2;
                        continue;
                    }
                    literal = literal.lessThanOrEqual(eq2) ? eq2 : literal;
                    continue;
                }
                newOff.add(eq2);
            }
            if (literal != null) {
                newOff.add(literal);
            }
            return newOff;
        }

        @Override
        public UBQualifier plusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
            return this.pluseOrMinusOffset(node, factory, '+');
        }

        @Override
        public UBQualifier minusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
            return this.pluseOrMinusOffset(node, factory, '-');
        }

        private UBQualifier pluseOrMinusOffset(Node node, UpperBoundAnnotatedTypeFactory factory, char op) {
            assert (op == '-' || op == '+');
            OffsetEquation newOffset = OffsetEquation.createOffsetFromNode(node, factory, op);
            LessThanLengthOf nodeOffsetQualifier = null;
            if (!newOffset.hasError()) {
                nodeOffsetQualifier = (LessThanLengthOf)this.addOffset(newOffset);
            }
            OffsetEquation valueOffset = OffsetEquation.createOffsetFromNodesValue(node, factory.getValueAnnotatedTypeFactory(), op);
            LessThanLengthOf valueOffsetQualifier = null;
            if (valueOffset != null && !valueOffset.hasError()) {
                valueOffsetQualifier = (LessThanLengthOf)this.addOffset(valueOffset);
            }
            if (valueOffsetQualifier == null) {
                if (nodeOffsetQualifier == null) {
                    return UpperBoundUnknownQualifier.UNKNOWN;
                }
                return nodeOffsetQualifier;
            }
            if (nodeOffsetQualifier == null) {
                return valueOffsetQualifier;
            }
            return nodeOffsetQualifier.glb(valueOffsetQualifier);
        }

        @Override
        public UBQualifier plusOffset(int value) {
            OffsetEquation newOffset = OffsetEquation.createOffsetForInt(value);
            return this.addOffset(newOffset);
        }

        @Override
        public UBQualifier minusOffset(int value) {
            OffsetEquation newOffset = OffsetEquation.createOffsetForInt(-value);
            return this.addOffset(newOffset);
        }

        public UBQualifier removeSequenceLengthAccess(final List<String> sequences) {
            if (sequences.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            OffsetEquationFunction removeSequenceLengthsFunc = new OffsetEquationFunction(){

                @Override
                public OffsetEquation compute(OffsetEquation eq2) {
                    return eq2.removeSequenceLengths(sequences);
                }
            };
            return this.computeNewOffsets(removeSequenceLengthsFunc);
        }

        public UBQualifier removeSequenceLengthAccessAndNeg1(final List<String> sequences) {
            if (sequences.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            OffsetEquationFunction removeSequenceLenFunc = new OffsetEquationFunction(){

                @Override
                public OffsetEquation compute(OffsetEquation eq2) {
                    OffsetEquation newEq = eq2.removeSequenceLengths(sequences);
                    if (newEq == null) {
                        return null;
                    }
                    if (newEq.getInt() == -1) {
                        return newEq.copyAdd('+', OffsetEquation.ONE);
                    }
                    return newEq;
                }
            };
            return this.computeNewOffsets(removeSequenceLenFunc);
        }

        private UBQualifier addOffset(final OffsetEquation newOffset) {
            OffsetEquationFunction addOffsetFunc = new OffsetEquationFunction(){

                @Override
                public OffsetEquation compute(OffsetEquation eq2) {
                    return eq2.copyAdd('+', newOffset);
                }
            };
            return this.computeNewOffsets(addOffsetFunc);
        }

        public UBQualifier divide(int divisor) {
            if (divisor == 1) {
                return this;
            }
            if (divisor > 1) {
                OffsetEquationFunction divideFunc = new OffsetEquationFunction(){

                    @Override
                    public OffsetEquation compute(OffsetEquation eq2) {
                        if (eq2.isNegativeOrZero()) {
                            return eq2;
                        }
                        return null;
                    }
                };
                return this.computeNewOffsets(divideFunc);
            }
            return UpperBoundUnknownQualifier.UNKNOWN;
        }

        public boolean isValuePlusOffsetLessThanMinLen(String sequence, long value, int minlen) {
            Set<OffsetEquation> offsets = this.map.get(sequence);
            if (offsets == null) {
                return false;
            }
            for (OffsetEquation offset : offsets) {
                if (!offset.isInt()) continue;
                return (long)minlen - (long)offset.getInt() > value;
            }
            return false;
        }

        public boolean isValidReplacement(String sequence, String replacementSequence, LessThanLengthOf other) {
            Set<OffsetEquation> offsets = this.map.get(sequence);
            if (offsets == null) {
                return false;
            }
            Set<OffsetEquation> otherOffsets = other.map.get(replacementSequence);
            if (otherOffsets == null) {
                return false;
            }
            return LessThanLengthOf.containsSame(offsets, otherOffsets);
        }

        public String toString() {
            return "LessThanLengthOf{map=" + this.map + '}';
        }

        public Iterable<? extends String> getSequences() {
            return this.map.keySet();
        }

        public UBQualifier removeOffset(String sequence, int offset) {
            OffsetEquation offsetEq = OffsetEquation.createOffsetForInt(offset);
            ArrayList<String> sequences = new ArrayList<String>();
            ArrayList<String> offsets = new ArrayList<String>();
            for (String seq : this.map.keySet()) {
                Set<OffsetEquation> offsetSet = this.map.get(seq);
                for (OffsetEquation off : offsetSet) {
                    if (sequence.equals(seq) || off.equals(offsetEq)) continue;
                    sequences.add(seq);
                    offsets.add(off.toString());
                }
            }
            if (sequences.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return UBQualifier.createUBQualifier(sequences, offsets);
        }

        private UBQualifier computeNewOffsets(OffsetEquationFunction f) {
            HashMap<String, Set<OffsetEquation>> newMap = new HashMap<String, Set<OffsetEquation>>(this.map.size());
            for (Map.Entry<String, Set<OffsetEquation>> entry : this.map.entrySet()) {
                HashSet<OffsetEquation> offsets = new HashSet<OffsetEquation>(entry.getValue().size());
                for (OffsetEquation eq2 : entry.getValue()) {
                    OffsetEquation newEq = f.compute(eq2);
                    if (newEq == null) continue;
                    offsets.add(newEq);
                }
                if (offsets.isEmpty()) continue;
                newMap.put(entry.getKey(), offsets);
            }
            if (newMap.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return new LessThanLengthOf(newMap);
        }

        static interface OffsetEquationFunction {
            public OffsetEquation compute(OffsetEquation var1);
        }
    }
}

