/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.Tree;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.TypesUtils;

public class LockTreeAnnotator
extends TreeAnnotator {
    public LockTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
        super(atypeFactory);
    }

    @Override
    public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
        if (LockTreeAnnotator.isBinaryComparisonOrInstanceOfOperator(node.getKind()) || TypesUtils.isString(type.getUnderlyingType())) {
            type.replaceAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
            return null;
        }
        return super.visitBinary(node, type);
    }

    private static boolean isBinaryComparisonOrInstanceOfOperator(Tree.Kind opKind) {
        switch (opKind) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case INSTANCE_OF: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
        if (TypesUtils.isString(type.getUnderlyingType())) {
            type.replaceAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
        }
        return (Void)super.visitCompoundAssignment(node, type);
    }
}

