/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T castNonNull(@Nullable T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [] castNonNullDeep(T @Nullable [] arr2) {
        return NullnessUtil.castNonNullArray(arr2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][] castNonNullDeep(T @Nullable [] @Nullable [] arr2) {
        return (Object[][])NullnessUtil.castNonNullArray(arr2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] arr2) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr2) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> @NonNull T @NonNull [][][][][] castNonNullDeep(T @Nullable [] @Nullable [] @Nullable [] @Nullable [] @Nullable [] arr2) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr2);
    }

    private static <T> @NonNull T @NonNull [] castNonNullArray(T @Nullable [] arr2) {
        assert (arr2 != null) : "Misuse of castNonNullArray: called with a null array argument";
        for (int i = 0; i < arr2.length; ++i) {
            assert (arr2[i] != null) : "Misuse of castNonNull: called with a null array element";
            NullnessUtil.checkIfArray(arr2[i]);
        }
        return arr2;
    }

    private static void checkIfArray(@NonNull Object ref) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument";
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref);
        }
    }
}

