/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.UnknownUnits;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsRelationsTools {
    public static @Nullable AnnotationMirror buildAnnoMirrorWithDefaultPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass) {
        if (env == null || annoClass == null) {
            return null;
        }
        return UnitsRelationsTools.buildAnnoMirrorWithSpecificPrefix(env, annoClass, Prefix.one);
    }

    public static @Nullable AnnotationMirror buildAnnoMirrorWithSpecificPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass, Prefix p) {
        if (env == null || annoClass == null || p == null) {
            return null;
        }
        AnnotationBuilder builder = new AnnotationBuilder(env, annoClass);
        builder.setValue((CharSequence)"value", p);
        return builder.build();
    }

    public static @Nullable AnnotationMirror buildAnnoMirrorWithNoPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass) {
        if (env == null || annoClass == null) {
            return null;
        }
        return AnnotationBuilder.fromClass(env.getElementUtils(), annoClass);
    }

    public static @Nullable Prefix getPrefix(AnnotatedTypeMirror annoType) {
        if (annoType == null) {
            return null;
        }
        Prefix result2 = null;
        for (AnnotationMirror mirror : annoType.getAnnotations()) {
            result2 = UnitsRelationsTools.getPrefix(mirror);
            if (result2 == null) continue;
            return result2;
        }
        return result2;
    }

    public static @Nullable Prefix getPrefix(@Nullable AnnotationMirror unitsAnnotation) {
        AnnotationValue annotationValue = UnitsRelationsTools.getAnnotationMirrorPrefix(unitsAnnotation);
        if (UnitsRelationsTools.hasNoPrefix(annotationValue)) {
            return null;
        }
        String prefixString = annotationValue.getValue().toString();
        for (Prefix prefix : Prefix.values()) {
            if (!prefixString.equals(prefix.toString())) continue;
            return prefix;
        }
        return null;
    }

    public static boolean hasNoPrefix(@Nullable AnnotatedTypeMirror annoType) {
        if (annoType == null) {
            return true;
        }
        for (AnnotationMirror mirror : annoType.getAnnotations()) {
            if (UnitsRelationsTools.hasNoPrefix(mirror)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNoPrefix(@Nullable AnnotationMirror unitsAnnotation) {
        AnnotationValue annotationValue = UnitsRelationsTools.getAnnotationMirrorPrefix(unitsAnnotation);
        return UnitsRelationsTools.hasNoPrefix(annotationValue);
    }

    private static boolean hasNoPrefix(@Nullable AnnotationValue annotationValue) {
        return annotationValue == null;
    }

    private static @Nullable AnnotationValue getAnnotationMirrorPrefix(@Nullable AnnotationMirror unitsAnnotation) {
        if (unitsAnnotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = unitsAnnotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static @Nullable AnnotationMirror removePrefix(@Nullable Elements elements, @Nullable AnnotationMirror unitsAnnotation) {
        if (elements == null) {
            return null;
        }
        if (UnitsRelationsTools.hasNoPrefix(unitsAnnotation)) {
            return unitsAnnotation;
        }
        return AnnotationBuilder.fromName(elements, unitsAnnotation.getAnnotationType().toString());
    }

    public static AnnotatedTypeMirror removePrefix(@Nullable Elements elements, @Nullable AnnotatedTypeMirror annoType) {
        AnnotatedTypeMirror result2 = annoType.deepCopy(false);
        Set<AnnotationMirror> annos = annoType.getAnnotations();
        for (AnnotationMirror anno : annos) {
            AnnotationMirror cleanedMirror = UnitsRelationsTools.removePrefix(elements, anno);
            if (cleanedMirror != null) {
                result2.addAnnotation(cleanedMirror);
                continue;
            }
            result2.addAnnotation(anno);
        }
        return result2;
    }

    public static boolean hasNoUnits(@Nullable AnnotatedTypeMirror annoType) {
        if (annoType == null) {
            return false;
        }
        return annoType.getAnnotation(UnknownUnits.class) != null;
    }

    public static boolean hasSpecificUnit(@Nullable AnnotatedTypeMirror annoType, @Nullable AnnotationMirror unitsAnnotation) {
        if (annoType == null || unitsAnnotation == null) {
            return false;
        }
        return AnnotationUtils.containsSame(annoType.getAnnotations(), unitsAnnotation);
    }

    public static boolean hasSpecificUnitIgnoringPrefix(@Nullable AnnotatedTypeMirror annoType, @Nullable AnnotationMirror unitsAnnotation) {
        if (annoType == null || unitsAnnotation == null) {
            return false;
        }
        return AnnotationUtils.containsSameIgnoringValues(annoType.getAnnotations(), unitsAnnotation);
    }
}

