/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.com.github.javaparser.TokenRange;
import org.checkerframework.com.github.javaparser.ast.AllFieldsConstructor;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.expr.NameExpr;
import org.checkerframework.com.github.javaparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithBody;
import org.checkerframework.com.github.javaparser.ast.observer.ObservableProperty;
import org.checkerframework.com.github.javaparser.ast.stmt.BlockStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.ReturnStmt;
import org.checkerframework.com.github.javaparser.ast.stmt.Statement;
import org.checkerframework.com.github.javaparser.ast.visitor.CloneVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.VoidVisitor;
import org.checkerframework.com.github.javaparser.metamodel.ForeachStmtMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.JavaParserMetaModel;
import org.checkerframework.com.github.javaparser.utils.Utils;

public final class ForeachStmt
extends Statement
implements NodeWithBody<ForeachStmt> {
    private VariableDeclarationExpr variable;
    private Expression iterable;
    private Statement body;

    public ForeachStmt() {
        this(null, new VariableDeclarationExpr(), new NameExpr(), new ReturnStmt());
    }

    @AllFieldsConstructor
    public ForeachStmt(VariableDeclarationExpr variable, Expression iterable2, Statement body2) {
        this(null, variable, iterable2, body2);
    }

    public ForeachStmt(TokenRange tokenRange, VariableDeclarationExpr variable, Expression iterable2, Statement body2) {
        super(tokenRange);
        this.setVariable(variable);
        this.setIterable(iterable2);
        this.setBody(body2);
        this.customInitialization();
    }

    public ForeachStmt(VariableDeclarationExpr variable, String iterable2, BlockStmt body2) {
        this(null, variable, new NameExpr(iterable2), body2);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public VariableDeclarationExpr getVariable() {
        return this.variable;
    }

    @Override
    public ForeachStmt setBody(Statement body2) {
        Utils.assertNotNull(body2);
        if (body2 == this.body) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.BODY, this.body, body2);
        if (this.body != null) {
            this.body.setParentNode(null);
        }
        this.body = body2;
        this.setAsParentNodeOf(body2);
        return this;
    }

    public ForeachStmt setIterable(Expression iterable2) {
        Utils.assertNotNull(iterable2);
        if (iterable2 == this.iterable) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ITERABLE, this.iterable, iterable2);
        if (this.iterable != null) {
            this.iterable.setParentNode(null);
        }
        this.iterable = iterable2;
        this.setAsParentNodeOf(iterable2);
        return this;
    }

    public ForeachStmt setVariable(VariableDeclarationExpr variable) {
        Utils.assertNotNull(variable);
        if (variable == this.variable) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.VARIABLE, this.variable, variable);
        if (this.variable != null) {
            this.variable.setParentNode(null);
        }
        this.variable = variable;
        this.setAsParentNodeOf(variable);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public ForeachStmt clone() {
        return (ForeachStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public ForeachStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.foreachStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.body) {
            this.setBody((Statement)replacementNode);
            return true;
        }
        if (node == this.iterable) {
            this.setIterable((Expression)replacementNode);
            return true;
        }
        if (node == this.variable) {
            this.setVariable((VariableDeclarationExpr)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isForeachStmt() {
        return true;
    }

    @Override
    public ForeachStmt asForeachStmt() {
        return this;
    }

    @Override
    public void ifForeachStmt(Consumer<ForeachStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<ForeachStmt> toForeachStmt() {
        return Optional.of(this);
    }
}

