/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.com.github.javaparser.TokenRange;
import org.checkerframework.com.github.javaparser.ast.AllFieldsConstructor;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import org.checkerframework.com.github.javaparser.ast.observer.ObservableProperty;
import org.checkerframework.com.github.javaparser.ast.stmt.Statement;
import org.checkerframework.com.github.javaparser.ast.visitor.CloneVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.GenericVisitor;
import org.checkerframework.com.github.javaparser.ast.visitor.VoidVisitor;
import org.checkerframework.com.github.javaparser.metamodel.JavaParserMetaModel;
import org.checkerframework.com.github.javaparser.metamodel.OptionalProperty;
import org.checkerframework.com.github.javaparser.metamodel.SwitchEntryStmtMetaModel;
import org.checkerframework.com.github.javaparser.utils.Utils;

public final class SwitchEntryStmt
extends Statement
implements NodeWithStatements<SwitchEntryStmt> {
    @OptionalProperty
    private Expression label;
    private NodeList<Statement> statements;

    public SwitchEntryStmt() {
        this(null, null, new NodeList<Statement>());
    }

    @AllFieldsConstructor
    public SwitchEntryStmt(Expression label, NodeList<Statement> statements) {
        this(null, label, statements);
    }

    public SwitchEntryStmt(TokenRange tokenRange, Expression label, NodeList<Statement> statements) {
        super(tokenRange);
        this.setLabel(label);
        this.setStatements((NodeList)statements);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public NodeList<Statement> getStatements() {
        return this.statements;
    }

    public SwitchEntryStmt setLabel(Expression label) {
        if (label == this.label) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.LABEL, this.label, label);
        if (this.label != null) {
            this.label.setParentNode(null);
        }
        this.label = label;
        this.setAsParentNodeOf(label);
        return this;
    }

    @Override
    public SwitchEntryStmt setStatements(NodeList<Statement> statements) {
        Utils.assertNotNull(statements);
        if (statements == this.statements) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.STATEMENTS, this.statements, statements);
        if (this.statements != null) {
            this.statements.setParentNode(null);
        }
        this.statements = statements;
        this.setAsParentNodeOf(statements);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.removeLabel();
            return true;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i) != node) continue;
            this.statements.remove(i);
            return true;
        }
        return super.remove(node);
    }

    public SwitchEntryStmt removeLabel() {
        return this.setLabel(null);
    }

    @Override
    public SwitchEntryStmt clone() {
        return (SwitchEntryStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public SwitchEntryStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.switchEntryStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.setLabel((Expression)replacementNode);
            return true;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i) != node) continue;
            this.statements.set(i, (Statement)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isSwitchEntryStmt() {
        return true;
    }

    @Override
    public SwitchEntryStmt asSwitchEntryStmt() {
        return this;
    }

    @Override
    public void ifSwitchEntryStmt(Consumer<SwitchEntryStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<SwitchEntryStmt> toSwitchEntryStmt() {
        return Optional.of(this);
    }
}

