/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EnumMap;
import java.util.Iterator;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.com.google.common.base.Preconditions;
import org.checkerframework.com.google.common.collect.AbstractMapBasedMultiset;
import org.checkerframework.com.google.common.collect.Iterables;
import org.checkerframework.com.google.common.collect.Serialization;
import org.checkerframework.com.google.common.collect.WellBehavedMap;

@GwtCompatible(emulated=true)
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMapBasedMultiset<E> {
    private transient Class<E> type;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> type) {
        return new EnumMultiset<E>(type);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset multiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements, Class<E> type) {
        EnumMultiset<E> result2 = EnumMultiset.create(type);
        Iterables.addAll(result2, elements);
        return result2;
    }

    private EnumMultiset(Class<E> type) {
        super(WellBehavedMap.wrap(new EnumMap(type)));
        this.type = type;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream2) throws IOException {
        stream2.defaultWriteObject();
        stream2.writeObject(this.type);
        Serialization.writeMultiset(this, stream2);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        Class localType;
        stream2.defaultReadObject();
        this.type = localType = (Class)stream2.readObject();
        this.setBackingMap(WellBehavedMap.wrap(new EnumMap(this.type)));
        Serialization.populateMultiset(this, stream2);
    }
}

