/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import javax.annotation.Nullable;
import org.checkerframework.com.google.common.annotations.Beta;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.com.google.common.base.Function;
import org.checkerframework.com.google.common.base.Optional;
import org.checkerframework.com.google.common.base.Preconditions;
import org.checkerframework.com.google.common.base.Predicate;
import org.checkerframework.com.google.common.collect.CollectPreconditions;
import org.checkerframework.com.google.common.collect.Collections2;
import org.checkerframework.com.google.common.collect.ConsumingQueueIterator;
import org.checkerframework.com.google.common.collect.FluentIterable;
import org.checkerframework.com.google.common.collect.ImmutableCollection;
import org.checkerframework.com.google.common.collect.ImmutableList;
import org.checkerframework.com.google.common.collect.Iterators;
import org.checkerframework.com.google.common.collect.Lists;
import org.checkerframework.com.google.common.collect.Multiset;
import org.checkerframework.com.google.common.collect.ObjectArrays;
import org.checkerframework.com.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible(emulated=true)
public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<? extends T> iterable2) {
        Preconditions.checkNotNull(iterable2);
        if (iterable2 instanceof UnmodifiableIterable || iterable2 instanceof ImmutableCollection) {
            Iterable<? extends T> result2 = iterable2;
            return result2;
        }
        return new UnmodifiableIterable(iterable2);
    }

    @Deprecated
    public static <E> Iterable<E> unmodifiableIterable(ImmutableCollection<E> iterable2) {
        return Preconditions.checkNotNull(iterable2);
    }

    public static int size(Iterable<?> iterable2) {
        return iterable2 instanceof Collection ? ((Collection)iterable2).size() : Iterators.size(iterable2.iterator());
    }

    public static boolean contains(Iterable<?> iterable2, @Nullable Object element) {
        if (iterable2 instanceof Collection) {
            Collection collection = (Collection)iterable2;
            return Collections2.safeContains(collection, element);
        }
        return Iterators.contains(iterable2.iterator(), element);
    }

    @CanIgnoreReturnValue
    public static boolean removeAll(Iterable<?> removeFrom, Collection<?> elementsToRemove) {
        return removeFrom instanceof Collection ? ((Collection)removeFrom).removeAll(Preconditions.checkNotNull(elementsToRemove)) : Iterators.removeAll(removeFrom.iterator(), elementsToRemove);
    }

    @CanIgnoreReturnValue
    public static boolean retainAll(Iterable<?> removeFrom, Collection<?> elementsToRetain) {
        return removeFrom instanceof Collection ? ((Collection)removeFrom).retainAll(Preconditions.checkNotNull(elementsToRetain)) : Iterators.retainAll(removeFrom.iterator(), elementsToRetain);
    }

    @CanIgnoreReturnValue
    public static <T> boolean removeIf(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        if (removeFrom instanceof RandomAccess && removeFrom instanceof List) {
            return Iterables.removeIfFromRandomAccessList((List)removeFrom, Preconditions.checkNotNull(predicate));
        }
        return Iterators.removeIf(removeFrom.iterator(), predicate);
    }

    private static <T> boolean removeIfFromRandomAccessList(List<T> list2, Predicate<? super T> predicate) {
        int from;
        int to = 0;
        for (from = 0; from < list2.size(); ++from) {
            T element = list2.get(from);
            if (predicate.apply(element)) continue;
            if (from > to) {
                try {
                    list2.set(to, element);
                }
                catch (UnsupportedOperationException e) {
                    Iterables.slowRemoveIfForRemainingElements(list2, predicate, to, from);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    Iterables.slowRemoveIfForRemainingElements(list2, predicate, to, from);
                    return true;
                }
            }
            ++to;
        }
        list2.subList(to, list2.size()).clear();
        return from != to;
    }

    private static <T> void slowRemoveIfForRemainingElements(List<T> list2, Predicate<? super T> predicate, int to, int from) {
        int n;
        for (n = list2.size() - 1; n > from; --n) {
            if (!predicate.apply(list2.get(n))) continue;
            list2.remove(n);
        }
        for (n = from - 1; n >= to; --n) {
            list2.remove(n);
        }
    }

    @Nullable
    static <T> T removeFirstMatching(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        Iterator<T> iterator = removeFrom.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (!predicate.apply(next)) continue;
            iterator.remove();
            return next;
        }
        return null;
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (collection1.size() != collection2.size()) {
                return false;
            }
        }
        return Iterators.elementsEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static String toString(Iterable<?> iterable2) {
        return Iterators.toString(iterable2.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable2) {
        return Iterators.getOnlyElement(iterable2.iterator());
    }

    @Nullable
    public static <T> T getOnlyElement(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        return Iterators.getOnlyElement(iterable2.iterator(), defaultValue);
    }

    @GwtIncompatible
    public static <T> T[] toArray(Iterable<? extends T> iterable2, Class<T> type) {
        return Iterables.toArray(iterable2, ObjectArrays.newArray(type, 0));
    }

    static <T> T[] toArray(Iterable<? extends T> iterable2, T[] array) {
        Collection<T> collection = Iterables.castOrCopyToCollection(iterable2);
        return collection.toArray(array);
    }

    static Object[] toArray(Iterable<?> iterable2) {
        return Iterables.castOrCopyToCollection(iterable2).toArray();
    }

    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> iterable2) {
        return iterable2 instanceof Collection ? (ArrayList<E>)iterable2 : Lists.newArrayList(iterable2.iterator());
    }

    @CanIgnoreReturnValue
    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = Collections2.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        return Iterators.addAll(addTo, Preconditions.checkNotNull(elementsToAdd).iterator());
    }

    public static int frequency(Iterable<?> iterable2, @Nullable Object element) {
        if (iterable2 instanceof Multiset) {
            return ((Multiset)iterable2).count(element);
        }
        if (iterable2 instanceof Set) {
            return ((Set)iterable2).contains(element) ? 1 : 0;
        }
        return Iterators.frequency(iterable2.iterator(), element);
    }

    public static <T> Iterable<T> cycle(final Iterable<T> iterable2) {
        Preconditions.checkNotNull(iterable2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.cycle(iterable2);
            }

            @Override
            public String toString() {
                return iterable2.toString() + " (cycled)";
            }
        };
    }

    public static <T> Iterable<T> cycle(T ... elements) {
        return Iterables.cycle(Lists.newArrayList(elements));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return FluentIterable.concat(a, b);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c) {
        return FluentIterable.concat(a, b, c);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c, Iterable<? extends T> d) {
        return FluentIterable.concat(a, b, c, d);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return Iterables.concat(ImmutableList.copyOf(inputs));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        return FluentIterable.concat(inputs);
    }

    public static <T> Iterable<List<T>> partition(final Iterable<T> iterable2, final int size) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(size > 0);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.partition(iterable2.iterator(), size);
            }
        };
    }

    public static <T> Iterable<List<T>> paddedPartition(final Iterable<T> iterable2, final int size) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(size > 0);
        return new FluentIterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.paddedPartition(iterable2.iterator(), size);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> retainIfTrue) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(retainIfTrue);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), retainIfTrue);
            }
        };
    }

    @GwtIncompatible
    public static <T> Iterable<T> filter(final Iterable<?> unfiltered, final Class<T> desiredType) {
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(desiredType);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), desiredType);
            }
        };
    }

    public static <T> boolean any(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.any(iterable2.iterator(), predicate);
    }

    public static <T> boolean all(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.all(iterable2.iterator(), predicate);
    }

    public static <T> T find(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.find(iterable2.iterator(), predicate);
    }

    @Nullable
    public static <T> T find(Iterable<? extends T> iterable2, Predicate<? super T> predicate, @Nullable T defaultValue) {
        return Iterators.find(iterable2.iterator(), predicate, defaultValue);
    }

    public static <T> Optional<T> tryFind(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.tryFind(iterable2.iterator(), predicate);
    }

    public static <T> int indexOf(Iterable<T> iterable2, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterable2.iterator(), predicate);
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> fromIterable, final Function<? super F, ? extends T> function2) {
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(fromIterable.iterator(), function2);
            }
        };
    }

    public static <T> T get(Iterable<T> iterable2, int position) {
        Preconditions.checkNotNull(iterable2);
        return (T)(iterable2 instanceof List ? ((List)iterable2).get(position) : Iterators.get(iterable2.iterator(), position));
    }

    @Nullable
    public static <T> T get(Iterable<? extends T> iterable2, int position, @Nullable T defaultValue) {
        Preconditions.checkNotNull(iterable2);
        Iterators.checkNonnegative(position);
        if (iterable2 instanceof List) {
            List<T> list2 = Lists.cast(iterable2);
            return position < list2.size() ? list2.get(position) : defaultValue;
        }
        Iterator<? extends T> iterator = iterable2.iterator();
        Iterators.advance(iterator, position);
        return Iterators.getNext(iterator, defaultValue);
    }

    @Nullable
    public static <T> T getFirst(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        return Iterators.getNext(iterable2.iterator(), defaultValue);
    }

    public static <T> T getLast(Iterable<T> iterable2) {
        if (iterable2 instanceof List) {
            List list2 = (List)iterable2;
            if (list2.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list2);
        }
        return Iterators.getLast(iterable2.iterator());
    }

    @Nullable
    public static <T> T getLast(Iterable<? extends T> iterable2, @Nullable T defaultValue) {
        if (iterable2 instanceof Collection) {
            Collection<T> c = Collections2.cast(iterable2);
            if (c.isEmpty()) {
                return defaultValue;
            }
            if (iterable2 instanceof List) {
                return Iterables.getLastInNonemptyList(Lists.cast(iterable2));
            }
        }
        return Iterators.getLast(iterable2.iterator(), defaultValue);
    }

    private static <T> T getLastInNonemptyList(List<T> list2) {
        return list2.get(list2.size() - 1);
    }

    public static <T> Iterable<T> skip(final Iterable<T> iterable2, final int numberToSkip) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(numberToSkip >= 0, "number to skip cannot be negative");
        if (iterable2 instanceof List) {
            final List list2 = (List)iterable2;
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    int toSkip = Math.min(list2.size(), numberToSkip);
                    return list2.subList(toSkip, list2.size()).iterator();
                }
            };
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable2.iterator();
                Iterators.advance(iterator, numberToSkip);
                return new Iterator<T>(){
                    boolean atStart = true;

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        Object result2 = iterator.next();
                        this.atStart = false;
                        return result2;
                    }

                    @Override
                    public void remove() {
                        CollectPreconditions.checkRemove(!this.atStart);
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> limit(final Iterable<T> iterable2, final int limitSize) {
        Preconditions.checkNotNull(iterable2);
        Preconditions.checkArgument(limitSize >= 0, "limit is negative");
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.limit(iterable2.iterator(), limitSize);
            }
        };
    }

    public static <T> Iterable<T> consumingIterable(final Iterable<T> iterable2) {
        if (iterable2 instanceof Queue) {
            return new FluentIterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return new ConsumingQueueIterator((Queue)iterable2);
                }

                @Override
                public String toString() {
                    return "Iterables.consumingIterable(...)";
                }
            };
        }
        Preconditions.checkNotNull(iterable2);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.consumingIterator(iterable2.iterator());
            }

            @Override
            public String toString() {
                return "Iterables.consumingIterable(...)";
            }
        };
    }

    public static boolean isEmpty(Iterable<?> iterable2) {
        if (iterable2 instanceof Collection) {
            return ((Collection)iterable2).isEmpty();
        }
        return !iterable2.iterator().hasNext();
    }

    @Beta
    public static <T> Iterable<T> mergeSorted(final Iterable<? extends Iterable<? extends T>> iterables, final Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterables, "iterables");
        Preconditions.checkNotNull(comparator, "comparator");
        FluentIterable iterable2 = new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.mergeSorted(Iterables.transform(iterables, Iterables.toIterator()), comparator);
            }
        };
        return new UnmodifiableIterable(iterable2);
    }

    static <T> Function<Iterable<? extends T>, Iterator<? extends T>> toIterator() {
        return new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> iterable2) {
                return iterable2.iterator();
            }
        };
    }

    private static final class UnmodifiableIterable<T>
    extends FluentIterable<T> {
        private final Iterable<? extends T> iterable;

        private UnmodifiableIterable(Iterable<? extends T> iterable2) {
            this.iterable = iterable2;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }

        @Override
        public String toString() {
            return this.iterable.toString();
        }
    }
}

