/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.aliasing;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.common.aliasing.AliasingTransfer;
import org.checkerframework.common.aliasing.qual.LeakedToResult;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.aliasing.qual.Unique;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class AliasingAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    private final AnnotationMirror MAYBE_ALIASED;
    private final AnnotationMirror NON_LEAKED;
    private final AnnotationMirror UNIQUE;
    private final AnnotationMirror MAYBE_LEAKED;

    public AliasingAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.MAYBE_ALIASED = AnnotationBuilder.fromClass(this.elements, MaybeAliased.class);
        this.NON_LEAKED = AnnotationBuilder.fromClass(this.elements, NonLeaked.class);
        this.UNIQUE = AnnotationBuilder.fromClass(this.elements, Unique.class);
        this.MAYBE_LEAKED = AnnotationBuilder.fromClass(this.elements, MaybeLeaked.class);
        if (this.getClass().equals(AliasingAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithoutPolyAll(MaybeLeaked.class);
    }

    @Override
    public CFTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        AliasingTransfer ret = new AliasingTransfer(analysis);
        return ret;
    }

    @Override
    protected ListTreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new AliasingTreeAnnotator(this), super.createTreeAnnotator());
    }

    @Override
    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new AliasingQualifierHierarchy(factory);
    }

    protected class AliasingQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        protected AliasingQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f);
        }

        @Override
        protected Set<AnnotationMirror> findBottoms(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newbottoms = AnnotationUtils.createAnnotationSet();
            newbottoms.add(AliasingAnnotatedTypeFactory.this.UNIQUE);
            newbottoms.add(AliasingAnnotatedTypeFactory.this.MAYBE_LEAKED);
            return newbottoms;
        }

        @Override
        protected Set<AnnotationMirror> findTops(Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newtops = AnnotationUtils.createAnnotationSet();
            newtops.add(AliasingAnnotatedTypeFactory.this.MAYBE_ALIASED);
            newtops.add(AliasingAnnotatedTypeFactory.this.NON_LEAKED);
            return newtops;
        }

        private boolean isLeakedQualifier(AnnotationMirror anno) {
            return AnnotationUtils.areSameByClass(anno, MaybeLeaked.class) || AnnotationUtils.areSameByClass(anno, NonLeaked.class) || AnnotationUtils.areSameByClass(anno, LeakedToResult.class);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (this.isLeakedQualifier(superAnno) && this.isLeakedQualifier(subAnno)) {
                return true;
            }
            return super.isSubtype(subAnno, superAnno);
        }
    }

    protected class AliasingTreeAnnotator
    extends TreeAnnotator {
        public AliasingTreeAnnotator(AliasingAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            AnnotatedTypeMirror defaulted = ((AnnotatedTypeMirror.AnnotatedExecutableType)this.atypeFactory.constructorFromUse((NewClassTree)node).first).getReturnType();
            Set<AnnotationMirror> defaultedSet = defaulted.getAnnotations();
            p.replaceAnnotations(defaultedSet);
            return null;
        }

        @Override
        public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(AliasingAnnotatedTypeFactory.this.UNIQUE);
            return (Void)super.visitNewArray(node, type);
        }
    }
}

