/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.BoolVal;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.DoubleVal;
import org.checkerframework.common.value.qual.IntRange;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.common.value.util.NumberUtils;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class ValueCheckerUtils {
    public static Class<?> getClassFromType(TypeMirror type) {
        switch (type.getKind()) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case ARRAY: {
                return ValueCheckerUtils.getArrayClassObject(((ArrayType)type).getComponentType());
            }
            case DECLARED: {
                String stringType = TypesUtils.getQualifiedName((DeclaredType)type).toString();
                if (stringType.equals("<nulltype>")) {
                    return Object.class;
                }
                try {
                    return Class.forName(stringType);
                }
                catch (ClassNotFoundException | UnsupportedClassVersionError e) {
                    return Object.class;
                }
            }
        }
        return Object.class;
    }

    public static Class<?> getArrayClassObject(TypeMirror componentType) {
        switch (componentType.getKind()) {
            case INT: {
                return int[].class;
            }
            case LONG: {
                return long[].class;
            }
            case SHORT: {
                return short[].class;
            }
            case BYTE: {
                return byte[].class;
            }
            case CHAR: {
                return char[].class;
            }
            case DOUBLE: {
                return double[].class;
            }
            case FLOAT: {
                return float[].class;
            }
            case BOOLEAN: {
                return boolean[].class;
            }
        }
        return Object[].class;
    }

    public static List<?> getValuesCastedToType(AnnotationMirror anno, TypeMirror castTo) {
        Class<?> castType = ValueCheckerUtils.getClassFromType(castTo);
        List<?> values = null;
        if (AnnotationUtils.areSameByClass(anno, DoubleVal.class)) {
            values = ValueCheckerUtils.convertDoubleVal(anno, castType, castTo);
        } else if (AnnotationUtils.areSameByClass(anno, IntVal.class)) {
            List<Long> longs = ValueAnnotatedTypeFactory.getIntValues(anno);
            values = ValueCheckerUtils.convertIntVal(longs, castType, castTo);
        } else if (AnnotationUtils.areSameByClass(anno, IntRange.class)) {
            Range range = ValueAnnotatedTypeFactory.getRange(anno);
            List<Long> longs = ValueCheckerUtils.getValuesFromRange(range, Long.class);
            values = ValueCheckerUtils.convertIntVal(longs, castType, castTo);
        } else if (AnnotationUtils.areSameByClass(anno, StringVal.class)) {
            values = ValueCheckerUtils.convertStringVal(anno, castType);
        } else if (AnnotationUtils.areSameByClass(anno, BoolVal.class)) {
            values = ValueCheckerUtils.convertBoolVal(anno, castType);
        } else if (AnnotationUtils.areSameByClass(anno, BottomVal.class)) {
            values = new ArrayList();
        } else if (AnnotationUtils.areSameByClass(anno, UnknownVal.class)) {
            values = null;
        } else if (AnnotationUtils.areSameByClass(anno, ArrayLen.class)) {
            values = new ArrayList();
        }
        return values;
    }

    public static Range getRangeFromValues(List<? extends Number> values) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Range.NOTHING;
        }
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (Number number : values) {
            longValues.add(number.longValue());
        }
        return new Range((Long)Collections.min(longValues), (Long)Collections.max(longValues));
    }

    private static <T> T convertLongToType(long value, Class<T> expectedType) {
        Constable convertedValue;
        if (expectedType == Integer.class) {
            convertedValue = (int)value;
        } else if (expectedType == Short.class) {
            convertedValue = (short)value;
        } else if (expectedType == Byte.class) {
            convertedValue = (byte)value;
        } else if (expectedType == Long.class) {
            convertedValue = value;
        } else if (expectedType == Double.class) {
            convertedValue = value;
        } else if (expectedType == Float.class) {
            convertedValue = Float.valueOf(value);
        } else if (expectedType == Character.class) {
            convertedValue = Character.valueOf((char)value);
        } else {
            throw new UnsupportedOperationException("ValueCheckerUtils: unexpected class: " + expectedType);
        }
        return expectedType.cast(convertedValue);
    }

    public static <T> List<T> getValuesFromRange(Range range, Class<T> expectedType) {
        if (range == null || range.isWiderThan(10L)) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        if (range.isNothing()) {
            return values;
        }
        long boundDifference = range.to - range.from;
        for (long offset = 0L; offset <= boundDifference; ++offset) {
            long value = range.from + offset;
            values.add(ValueCheckerUtils.convertLongToType(value, expectedType));
        }
        return values;
    }

    private static List<?> convertToStringVal(List<?> origValues) {
        if (origValues == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Object value : origValues) {
            strings.add(value.toString());
        }
        return strings;
    }

    private static List<?> convertBoolVal(AnnotationMirror anno, Class<?> newClass) {
        List<Boolean> bools = AnnotationUtils.getElementValueArray(anno, "value", Boolean.class, true);
        if (newClass == String.class) {
            return ValueCheckerUtils.convertToStringVal(bools);
        }
        return bools;
    }

    private static List<?> convertStringVal(AnnotationMirror anno, Class<?> newClass) {
        List<String> strings = ValueAnnotatedTypeFactory.getStringValues(anno);
        if (newClass == char[].class) {
            ArrayList<char[]> chars = new ArrayList<char[]>();
            for (String s2 : strings) {
                chars.add(s2.toCharArray());
            }
            return chars;
        }
        return strings;
    }

    private static List<?> convertIntVal(List<Long> longs, Class<?> newClass, TypeMirror newType) {
        if (longs == null) {
            return null;
        }
        if (newClass == String.class) {
            return ValueCheckerUtils.convertToStringVal(longs);
        }
        if (newClass == Character.class || newClass == Character.TYPE) {
            ArrayList<Character> chars = new ArrayList<Character>();
            for (Long l : longs) {
                chars.add(Character.valueOf((char)l.longValue()));
            }
            return chars;
        }
        if (newClass == Boolean.class) {
            throw new UnsupportedOperationException("ValueAnnotatedTypeFactory: can't convert int to boolean");
        }
        return NumberUtils.castNumbers(newType, longs);
    }

    private static List<?> convertDoubleVal(AnnotationMirror anno, Class<?> newClass, TypeMirror newType) {
        List<Double> doubles = ValueAnnotatedTypeFactory.getDoubleValues(anno);
        if (doubles == null) {
            return null;
        }
        if (newClass == String.class) {
            return ValueCheckerUtils.convertToStringVal(doubles);
        }
        if (newClass == Character.class || newClass == Character.TYPE) {
            ArrayList<Character> chars = new ArrayList<Character>();
            for (Double l : doubles) {
                chars.add(Character.valueOf((char)l.doubleValue()));
            }
            return chars;
        }
        if (newClass == Boolean.class) {
            throw new UnsupportedOperationException("ValueAnnotatedTypeFactory: can't convert double to boolean");
        }
        return NumberUtils.castNumbers(newType, doubles);
    }

    public static <T extends Comparable<T>> List<T> removeDuplicates(List<T> values) {
        TreeSet<T> set2 = new TreeSet<T>(values);
        return new ArrayList<T>(set2);
    }

    public static List<Integer> getLengthsForStringValues(List<String> values) {
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (String str : values) {
            lengths.add(str.length());
        }
        return ValueCheckerUtils.removeDuplicates(lengths);
    }
}

