/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.javacutil.AnnotationUtils;

public class AnnotationMirrorSet
implements Set<AnnotationMirror> {
    private Set<AnnotationMirror> shadowSet = new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());

    public AnnotationMirrorSet() {
    }

    public AnnotationMirrorSet(Collection<? extends AnnotationMirror> values) {
        this();
        this.addAll(values);
    }

    @Override
    public int size() {
        return this.shadowSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.shadowSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof AnnotationMirror && AnnotationUtils.containsSame(this.shadowSet, (AnnotationMirror)o);
    }

    @Override
    public Iterator<AnnotationMirror> iterator() {
        return this.shadowSet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.shadowSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.shadowSet.toArray(a);
    }

    @Override
    public boolean add(AnnotationMirror annotationMirror) {
        if (this.contains(annotationMirror)) {
            return false;
        }
        this.shadowSet.add(annotationMirror);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof AnnotationMirror) {
            AnnotationMirror found = AnnotationUtils.getSame(this.shadowSet, (AnnotationMirror)o);
            return found != null && this.shadowSet.remove(found);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends AnnotationMirror> c) {
        boolean result2 = true;
        for (AnnotationMirror annotationMirror : c) {
            if (this.add(annotationMirror)) continue;
            result2 = false;
        }
        return result2;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        TreeSet<AnnotationMirror> newSet = new TreeSet<AnnotationMirror>(AnnotationUtils.annotationOrdering());
        for (Object o : c) {
            if (!this.contains(o)) continue;
            newSet.add((AnnotationMirror)o);
        }
        if (newSet.size() != this.shadowSet.size()) {
            this.shadowSet = newSet;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result2 = true;
        for (Object a : c) {
            if (this.remove(a)) continue;
            result2 = false;
        }
        return result2;
    }

    @Override
    public void clear() {
        this.shadowSet.clear();
    }
}

