/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.solver;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;

public class InferenceResult
extends LinkedHashMap<TypeVariable, InferredValue> {
    private static final long serialVersionUID = 6911459752070485818L;

    public Set<TypeVariable> getRemainingTargets(Set<TypeVariable> allTargets, boolean inferredTypesOnly) {
        LinkedHashSet<TypeVariable> remainingTargets = new LinkedHashSet<TypeVariable>(allTargets);
        if (inferredTypesOnly) {
            for (TypeVariable target : this.keySet()) {
                if (!(this.get(target) instanceof InferredValue.InferredType)) continue;
                remainingTargets.remove(target);
            }
        } else {
            remainingTargets.removeAll(this.keySet());
        }
        return remainingTargets;
    }

    public boolean isComplete(Set<TypeVariable> targets) {
        for (TypeVariable target : targets) {
            InferredValue inferred = (InferredValue)this.get(target);
            if (inferred == null || inferred instanceof InferredValue.InferredTarget) {
                return false;
            }
            if (!(inferred instanceof InferredValue.InferredType) || ((InferredValue.InferredType)inferred).type.getKind() != TypeKind.NULL) continue;
            return false;
        }
        return this.keySet().containsAll(targets);
    }

    public void resolveChainedTargets() {
        LinkedHashMap<TypeVariable, InferredValue> inferredTypes = new LinkedHashMap<TypeVariable, InferredValue>(this.size());
        boolean grew = true;
        while (grew) {
            grew = false;
            for (Map.Entry inferred : this.entrySet()) {
                TypeVariable target = (TypeVariable)inferred.getKey();
                InferredValue value = (InferredValue)inferred.getValue();
                if (value instanceof InferredValue.InferredType) {
                    inferredTypes.put(target, value);
                    continue;
                }
                InferredValue.InferredTarget currentTarget = (InferredValue.InferredTarget)value;
                InferredValue.InferredType equivalentType = (InferredValue.InferredType)inferredTypes.get(((InferredValue.InferredTarget)value).target);
                if (equivalentType == null) continue;
                grew = true;
                AnnotatedTypeMirror type = equivalentType.type.deepCopy();
                type.replaceAnnotations(currentTarget.additionalAnnotations);
                InferredValue.InferredType newConstraint = new InferredValue.InferredType(type);
                inferredTypes.put(currentTarget.target, newConstraint);
            }
        }
        this.putAll(inferredTypes);
    }

    public Map<TypeVariable, AnnotatedTypeMirror> toAtmMap() {
        LinkedHashMap<TypeVariable, AnnotatedTypeMirror> result2 = new LinkedHashMap<TypeVariable, AnnotatedTypeMirror>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            InferredValue inferredValue = (InferredValue)entry.getValue();
            if (!(inferredValue instanceof InferredValue.InferredType)) continue;
            result2.put((TypeVariable)entry.getKey(), ((InferredValue.InferredType)inferredValue).type);
        }
        return result2;
    }

    public void mergeSubordinate(InferenceResult subordinate) {
        LinkedHashSet previousKeySet = new LinkedHashSet(this.keySet());
        LinkedHashSet remainingSubKeys = new LinkedHashSet(subordinate.keySet());
        remainingSubKeys.removeAll(this.keySet());
        for (TypeVariable target : previousKeySet) {
            this.mergeTarget(target, subordinate);
        }
        for (TypeVariable target : remainingSubKeys) {
            this.put(target, subordinate.get(target));
        }
        this.resolveChainedTargets();
    }

    protected InferredValue.InferredType mergeTarget(TypeVariable target, InferenceResult subordinate) {
        InferredValue inferred = (InferredValue)this.get(target);
        if (inferred instanceof InferredValue.InferredTarget) {
            InferredValue.InferredType newType = this.mergeTarget(((InferredValue.InferredTarget)inferred).target, subordinate);
            if (newType == null) {
                InferredValue subValue = (InferredValue)subordinate.get(target);
                if (subValue != null && subValue instanceof InferredValue.InferredType) {
                    this.put(target, subValue);
                    return null;
                }
            } else {
                InferredValue subValue;
                if (newType.type.getKind() == TypeKind.NULL && (subValue = (InferredValue)subordinate.get(target)) != null && subValue instanceof InferredValue.InferredType) {
                    AnnotatedTypeMirror copy = ((InferredValue.InferredType)subValue).type.deepCopy();
                    copy.replaceAnnotations(newType.type.getAnnotations());
                    newType = new InferredValue.InferredType(copy);
                }
                this.put(target, newType);
                return newType;
            }
            return null;
        }
        return (InferredValue.InferredType)inferred;
    }
}

