/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.org.objectweb.asm.ClassAdapter;
import org.checkerframework.org.objectweb.asm.ClassVisitor;
import org.checkerframework.org.objectweb.asm.FieldVisitor;
import org.checkerframework.org.objectweb.asm.MethodVisitor;

public class SerialVersionUIDAdder
extends ClassAdapter {
    protected boolean computeSVUID;
    protected boolean hasSVUID;
    protected int access;
    protected String name;
    protected String[] interfaces;
    protected Collection svuidFields = new ArrayList();
    protected boolean hasStaticInitializer;
    protected Collection svuidConstructors = new ArrayList();
    protected Collection svuidMethods = new ArrayList();

    public SerialVersionUIDAdder(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean bl = this.computeSVUID = (access & 0x200) == 0;
        if (this.computeSVUID) {
            this.name = name;
            this.access = access;
            this.interfaces = interfaces;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.computeSVUID) {
            if (name.equals("<clinit>")) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if (name.equals("<init>")) {
                    this.svuidConstructors.add(new Item(name, mods, desc));
                } else if (!name.equals("<clinit>")) {
                    this.svuidMethods.add(new Item(name, mods, desc));
                }
            }
        }
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.computeSVUID) {
            if (name.equals("serialVersionUID")) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            int mods = access & 0xDF;
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                this.svuidFields.add(new Item(name, mods, desc));
            }
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.cv.visitField(24, "serialVersionUID", "J", null, new Long(this.computeSVUID()));
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while computing SVUID for " + this.name, e);
            }
        }
        super.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeSVUID() throws IOException {
        if (this.hasSVUID) {
            return 0L;
        }
        ByteArrayOutputStream bos = null;
        long svuid = 0L;
        try (FilterOutputStream dos = null;){
            bos = new ByteArrayOutputStream();
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeUTF(this.name.replace('/', '.'));
            ((DataOutputStream)dos).writeInt(this.access & 0x611);
            Arrays.sort(this.interfaces);
            for (int i = 0; i < this.interfaces.length; ++i) {
                ((DataOutputStream)dos).writeUTF(this.interfaces[i].replace('/', '.'));
            }
            this.writeItems(this.svuidFields, (DataOutputStream)dos, false);
            if (this.hasStaticInitializer) {
                ((DataOutputStream)dos).writeUTF("<clinit>");
                ((DataOutputStream)dos).writeInt(8);
                ((DataOutputStream)dos).writeUTF("()V");
            }
            this.writeItems(this.svuidConstructors, (DataOutputStream)dos, true);
            this.writeItems(this.svuidMethods, (DataOutputStream)dos, true);
            ((DataOutputStream)dos).flush();
            byte[] hashBytes = this.computeSHAdigest(bos.toByteArray());
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
            }
        }
        return svuid;
    }

    protected byte[] computeSHAdigest(byte[] value) {
        try {
            return MessageDigest.getInstance("SHA").digest(value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private void writeItems(Collection itemCollection, DataOutputStream dos, boolean dotted) throws IOException {
        int size = itemCollection.size();
        Object[] items = itemCollection.toArray(new Item[size]);
        Arrays.sort(items);
        for (int i = 0; i < size; ++i) {
            dos.writeUTF(((Item)items[i]).name);
            dos.writeInt(((Item)items[i]).access);
            dos.writeUTF(dotted ? ((Item)items[i]).desc.replace('/', '.') : ((Item)items[i]).desc);
        }
    }

    static class Item
    implements Comparable {
        String name;
        int access;
        String desc;

        Item(String name, int access, String desc) {
            this.name = name;
            this.access = access;
            this.desc = desc;
        }

        public int compareTo(Object o) {
            Item other = (Item)o;
            int retVal = this.name.compareTo(other.name);
            if (retVal == 0) {
                retVal = this.desc.compareTo(other.desc);
            }
            return retVal;
        }
    }
}

