/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.optimizer;

import java.util.HashMap;
import org.checkerframework.org.objectweb.asm.Type;
import org.checkerframework.org.objectweb.asm.optimizer.Constant;

public class ConstantPool
extends HashMap {
    private Constant key1 = new Constant();
    private Constant key2 = new Constant();
    private Constant key3 = new Constant();

    public Constant newInteger(int value) {
        this.key1.set(value);
        Constant result2 = this.get(this.key1);
        if (result2 == null) {
            result2 = new Constant(this.key1);
            this.put(result2);
        }
        return result2;
    }

    public Constant newFloat(float value) {
        this.key1.set(value);
        Constant result2 = this.get(this.key1);
        if (result2 == null) {
            result2 = new Constant(this.key1);
            this.put(result2);
        }
        return result2;
    }

    public Constant newLong(long value) {
        this.key1.set(value);
        Constant result2 = this.get(this.key1);
        if (result2 == null) {
            result2 = new Constant(this.key1);
            this.put(result2);
        }
        return result2;
    }

    public Constant newDouble(double value) {
        this.key1.set(value);
        Constant result2 = this.get(this.key1);
        if (result2 == null) {
            result2 = new Constant(this.key1);
            this.put(result2);
        }
        return result2;
    }

    public Constant newUTF8(String value) {
        this.key1.set('s', value, null, null);
        Constant result2 = this.get(this.key1);
        if (result2 == null) {
            result2 = new Constant(this.key1);
            this.put(result2);
        }
        return result2;
    }

    private Constant newString(String value) {
        this.key2.set('S', value, null, null);
        Constant result2 = this.get(this.key2);
        if (result2 == null) {
            this.newUTF8(value);
            result2 = new Constant(this.key2);
            this.put(result2);
        }
        return result2;
    }

    public Constant newClass(String value) {
        this.key2.set('C', value, null, null);
        Constant result2 = this.get(this.key2);
        if (result2 == null) {
            this.newUTF8(value);
            result2 = new Constant(this.key2);
            this.put(result2);
        }
        return result2;
    }

    public Constant newConst(Object cst) {
        if (cst instanceof Integer) {
            int val = (Integer)cst;
            return this.newInteger(val);
        }
        if (cst instanceof Float) {
            float val = ((Float)cst).floatValue();
            return this.newFloat(val);
        }
        if (cst instanceof Long) {
            long val = (Long)cst;
            return this.newLong(val);
        }
        if (cst instanceof Double) {
            double val = (Double)cst;
            return this.newDouble(val);
        }
        if (cst instanceof String) {
            return this.newString((String)cst);
        }
        if (cst instanceof Type) {
            Type t = (Type)cst;
            return this.newClass(t.getSort() == 10 ? t.getInternalName() : t.getDescriptor());
        }
        throw new IllegalArgumentException("value " + cst);
    }

    public Constant newField(String owner, String name, String desc) {
        this.key3.set('G', owner, name, desc);
        Constant result2 = this.get(this.key3);
        if (result2 == null) {
            this.newClass(owner);
            this.newNameType(name, desc);
            result2 = new Constant(this.key3);
            this.put(result2);
        }
        return result2;
    }

    public Constant newMethod(String owner, String name, String desc, boolean itf) {
        this.key3.set(itf ? (char)'N' : 'M', owner, name, desc);
        Constant result2 = this.get(this.key3);
        if (result2 == null) {
            this.newClass(owner);
            this.newNameType(name, desc);
            result2 = new Constant(this.key3);
            this.put(result2);
        }
        return result2;
    }

    public Constant newNameType(String name, String desc) {
        this.key2.set('T', name, desc, null);
        Constant result2 = this.get(this.key2);
        if (result2 == null) {
            this.newUTF8(name);
            this.newUTF8(desc);
            result2 = new Constant(this.key2);
            this.put(result2);
        }
        return result2;
    }

    private Constant get(Constant key) {
        return (Constant)this.get((Object)key);
    }

    private void put(Constant cst) {
        this.put(cst, cst);
    }
}

