/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.tree.JumpInsnNode;
import org.checkerframework.org.objectweb.asm.tree.analysis.AnalyzerException;

class Subroutine {
    Label start;
    boolean[] access;
    List callers;

    private Subroutine() {
    }

    public Subroutine(Label start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList();
        this.callers.add(caller);
    }

    public Subroutine copy() {
        Subroutine result2 = new Subroutine();
        result2.start = this.start;
        result2.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result2.access, 0, this.access.length);
        result2.callers = new ArrayList(this.callers);
        return result2;
    }

    public boolean merge(Subroutine subroutine, boolean checkOverlap) throws AnalyzerException {
        int i;
        if (checkOverlap && subroutine.start != this.start) {
            throw new AnalyzerException("Overlapping sub routines");
        }
        boolean changes = false;
        for (i = 0; i < this.access.length; ++i) {
            if (!subroutine.access[i] || this.access[i]) continue;
            this.access[i] = true;
            changes = true;
        }
        for (i = 0; i < subroutine.callers.size(); ++i) {
            Object caller = subroutine.callers.get(i);
            if (this.callers.contains(caller)) continue;
            this.callers.add(caller);
            changes = true;
        }
        return changes;
    }
}

