/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.Objects;
import scenelib.annotations.io.ASTPath;

public class ASTRecord
implements Comparable<ASTRecord> {
    public final CompilationUnitTree ast;
    public final String className;
    public final String methodName;
    public final String varName;
    public final ASTPath astPath;

    public ASTRecord(CompilationUnitTree ast, String className, String methodName, String varName, ASTPath astPath) {
        int n;
        this.ast = ast;
        this.className = className;
        this.methodName = methodName;
        this.varName = varName;
        if (varName == null && methodName != null && (n = astPath.size()) > 0 && ((ASTPath.ASTEntry)astPath.get(0)).getTreeKind() != Tree.Kind.METHOD && ((ASTPath.ASTEntry)astPath.get(0)).getTreeKind() != Tree.Kind.VARIABLE) {
            ASTPath bodyPath = ASTPath.empty().add(new ASTPath.ASTEntry(Tree.Kind.METHOD, "body"));
            for (int i = 0; i < n; ++i) {
                bodyPath = bodyPath.add((ASTPath.ASTEntry)astPath.get(i));
            }
            astPath = bodyPath;
        }
        this.astPath = astPath;
    }

    public ASTRecord newArrayLevel(int depth) {
        return new ASTRecord(this.ast, this.className, this.methodName, this.varName, this.astPath.extendNewArray(depth));
    }

    public ASTRecord replacePath(ASTPath newPath) {
        return new ASTRecord(this.ast, this.className, this.methodName, this.varName, newPath);
    }

    public boolean equals(Object o) {
        return o instanceof ASTRecord && this.equals((ASTRecord)o);
    }

    public boolean equals(ASTRecord astRecord) {
        return this.compareTo(astRecord) == 0;
    }

    @Override
    public int compareTo(ASTRecord rec) {
        int d;
        int n = this.ast == null ? (rec.ast == null ? 0 : -1) : (d = rec.ast == null ? 1 : Integer.compare(this.ast.hashCode(), rec.ast.hashCode()));
        if (d == 0) {
            int n2 = this.className == null ? (rec.className == null ? 0 : -1) : (d = rec.className == null ? 1 : this.className.compareTo(rec.className));
            if (d == 0) {
                int n3 = this.methodName == null ? (rec.methodName == null ? 0 : -1) : (d = rec.methodName == null ? 1 : this.methodName.compareTo(rec.methodName));
                if (d == 0) {
                    int n4 = this.varName == null ? (rec.varName == null ? 0 : -1) : (d = rec.varName == null ? 1 : this.varName.compareTo(rec.varName));
                    if (d == 0) {
                        d = this.astPath == null ? (rec.astPath == null ? 0 : -1) : (rec.astPath == null ? 1 : this.astPath.compareTo(rec.astPath));
                    }
                }
            }
        }
        return d;
    }

    public int hashCode() {
        return Objects.hash(this.ast, this.className, this.methodName, this.varName, this.astPath);
    }

    public boolean matches(TreePath treePath) {
        String clazz = null;
        String meth = null;
        String var = null;
        boolean matchVars = false;
        ArrayDeque<Tree> stack = new ArrayDeque<Tree>();
        for (Tree tree : treePath) {
            stack.push(tree);
        }
        block6: while (!stack.isEmpty()) {
            Tree tree = (Tree)stack.pop();
            switch (tree.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    clazz = ((ClassTree)tree).getSimpleName().toString();
                    meth = null;
                    var = null;
                    matchVars = true;
                    continue block6;
                }
                case METHOD: {
                    assert (meth == null);
                    meth = ((MethodTree)tree).getName().toString();
                    matchVars = false;
                    continue block6;
                }
                case VARIABLE: {
                    if (!matchVars) continue block6;
                    assert (var == null);
                    var = ((VariableTree)tree).getName().toString();
                    matchVars = false;
                    continue block6;
                }
            }
            matchVars = false;
        }
        return this.className.equals(clazz) && (this.methodName == null ? meth == null : this.methodName.equals(meth)) && (this.varName == null ? var == null : this.varName.equals(var)) && this.astPath.matches(treePath);
    }

    public String toString() {
        return (this.className == null ? "" : this.className) + ":" + (this.methodName == null ? "" : this.methodName) + ":" + (this.varName == null ? "" : this.varName) + ":" + this.astPath;
    }

    public ASTRecord extend(ASTPath.ASTEntry entry) {
        return new ASTRecord(this.ast, this.className, this.methodName, this.varName, this.astPath.extend(entry));
    }

    public ASTRecord extend(Tree.Kind kind, String sel) {
        return this.extend(new ASTPath.ASTEntry(kind, sel));
    }

    public ASTRecord extend(Tree.Kind kind, String sel, int arg) {
        return this.extend(new ASTPath.ASTEntry(kind, sel, arg));
    }
}

