/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.transcode.codec.json;

import com.digitalasset.transcode.MissingFieldsException;
import com.digitalasset.transcode.UnexpectedFieldsException;
import com.digitalasset.transcode.codec.json.JsonCodec$;
import com.digitalasset.transcode.schema.CodecVisitor;
import com.digitalasset.transcode.schema.DynamicValue$;
import com.digitalasset.transcode.schema.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.SeqView;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import ujson.Arr;
import ujson.Arr$;
import ujson.Bool$;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.Value;
import ujson.Value$;
import upickle.core.LinkedHashMap;

public class JsonCodec
implements CodecVisitor<Value> {
    private final boolean encodeNumericAsString;
    private final boolean encodeInt64AsString;
    public final boolean com$digitalasset$transcode$codec$json$JsonCodec$$allowMissingFields;
    public final boolean com$digitalasset$transcode$codec$json$JsonCodec$$removeTrailingNonesInRecords;

    public static boolean $lessinit$greater$default$1() {
        return JsonCodec$.MODULE$.$lessinit$greater$default$1();
    }

    public static boolean $lessinit$greater$default$2() {
        return JsonCodec$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return JsonCodec$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return JsonCodec$.MODULE$.$lessinit$greater$default$4();
    }

    public JsonCodec(boolean encodeNumericAsString, boolean encodeInt64AsString, boolean allowMissingFields, boolean removeTrailingNonesInRecords) {
        this.encodeNumericAsString = encodeNumericAsString;
        this.encodeInt64AsString = encodeInt64AsString;
        this.com$digitalasset$transcode$codec$json$JsonCodec$$allowMissingFields = allowMissingFields;
        this.com$digitalasset$transcode$codec$json$JsonCodec$$removeTrailingNonesInRecords = removeTrailingNonesInRecords;
    }

    public CodecVisitor.Codec<Value> record(Seq<Tuple2<String, CodecVisitor.Codec<Value>>> fields) {
        return new CodecVisitor.Codec<Value>(fields, this){
            private final Seq fields$1;
            private final /* synthetic */ JsonCodec $outer;
            {
                this.fields$1 = fields$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object toDynamicValue(Value v, Map x$2) {
                LinkedHashMap valueMap = Value$.MODULE$.JsonableDict((IterableOnce)v.obj(), Predef$.MODULE$.$conforms()).value();
                Set missingFields = (Set)((IterableOnceOps)this.fields$1.collect((PartialFunction)new Serializable(x$2){
                    private final Map x$2$1;
                    {
                        this.x$2$1 = x$2$16;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            CodecVisitor.Codec c = (CodecVisitor.Codec)tuple2._2();
                            if (!c.isOptional(this.x$2$1)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            CodecVisitor.Codec c = (CodecVisitor.Codec)tuple2._2();
                            if (!c.isOptional(this.x$2$1)) {
                                return name;
                            }
                        }
                        return function1.apply((Object)x);
                    }
                })).toSet().$minus$minus((IterableOnce)valueMap.keys());
                if (!this.$outer.com$digitalasset$transcode$codec$json$JsonCodec$$allowMissingFields && missingFields.nonEmpty()) {
                    throw new MissingFieldsException((Set<String>)missingFields);
                }
                Set unexpectedFields = (Set)((IterableOnceOps)valueMap.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Tuple2 x) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Value v = (Value)tuple2._2();
                            if (!v.isNull()) {
                                return true;
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            Value v = (Value)tuple2._2();
                            if (!v.isNull()) {
                                return name;
                            }
                        }
                        return function1.apply((Object)x);
                    }
                })).toSet().$minus$minus((IterableOnce)this.fields$1.map(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$1));
                if (unexpectedFields.nonEmpty()) {
                    throw new UnexpectedFieldsException((Set<String>)unexpectedFields);
                }
                SeqView values = this.fields$1.view().map(arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$2(valueMap, x$2, arg_0));
                if (this.$outer.com$digitalasset$transcode$codec$json$JsonCodec$$removeTrailingNonesInRecords) {
                    return DynamicValue$.MODULE$.Record((IterableOnce)((IterableOnceOps)values.reverse().dropWhile(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$toDynamicValue$$anonfun$1)).toSeq().reverse());
                }
                return DynamicValue$.MODULE$.Record((IterableOnce)values);
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                DynamicValue$.MODULE$.checkRecordSize(dv, this.fields$1.size());
                Iterator iterator = this.$outer.com$digitalasset$transcode$codec$json$JsonCodec$$allowMissingFields ? DynamicValue$.MODULE$.recordIterator(dv) : DynamicValue$.MODULE$.recordIteratorPadded(dv, this.fields$1.size());
                Iterator values = iterator.zip((IterableOnce)this.fields$1).map(arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$3(x$2, arg_0));
                if (this.$outer.com$digitalasset$transcode$codec$json$JsonCodec$$removeTrailingNonesInRecords) {
                    return Obj$.MODULE$.from((IterableOnce)((SeqOps)((IterableOps)values.toSeq().reverse()).dropWhile(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$fromDynamicValue$$anonfun$1)).reverse());
                }
                return Obj$.MODULE$.from((IterableOnce)values);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$1(scala.Tuple2 ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$2(upickle.core.LinkedHashMap scala.collection.immutable.Map scala.Tuple2 ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$toDynamicValue$$anonfun$1(java.lang.Object ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$3(scala.collection.immutable.Map scala.Tuple2 ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$fromDynamicValue$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> variant(Seq<Tuple2<String, CodecVisitor.Codec<Value>>> cases) {
        return new CodecVisitor.Codec<Value>(cases){
            private final Tuple2[] caseList;
            private final Map caseMap;
            {
                this.caseList = (Tuple2[])((IterableOnceOps)cases$1.map(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$1)).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                this.caseMap = ((IterableOnceOps)((IterableOps)cases$1.zipWithIndex()).map(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public Object toDynamicValue(Value v, Map x$2) {
                String key$proxy1 = ((Value)v.obj().apply((Object)"tag")).str();
                Tuple2 tuple2 = (Tuple2)this.caseMap.getOrElse((Object)key$proxy1, () -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$_$$anonfun$4(key$proxy1));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int ctorIx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                CodecVisitor.Codec valueCodec = (CodecVisitor.Codec)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ctorIx), (Object)valueCodec);
                int ctorIx2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
                CodecVisitor.Codec valueCodec2 = (CodecVisitor.Codec)tuple22._2();
                return DynamicValue$.MODULE$.Variant(ctorIx2, valueCodec2.toDynamicValue(v.obj().apply((Object)"value"), x$2));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                Tuple2 tuple2 = DynamicValue$.MODULE$.variant(dv);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int ctorIx = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Object value = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ctorIx), value);
                int ctorIx2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
                Object value2 = tuple22._2();
                if (ctorIx2 >= this.caseList.length) {
                    throw new Exception("Unexpected case: " + ctorIx2);
                }
                Tuple2 tuple23 = this.caseList[ctorIx2];
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                String ctorName = (String)tuple23._1();
                CodecVisitor.Codec valueCodec = (CodecVisitor.Codec)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)ctorName, (Object)valueCodec);
                String ctorName2 = (String)tuple24._1();
                CodecVisitor.Codec valueCodec2 = (CodecVisitor.Codec)tuple24._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"tag");
                Object[] objectArray = new Tuple2[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, valueCodec2.fromDynamicValue(value2, x$2));
                return Obj$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Str$.MODULE$.apply(ctorName2)), (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Predef$.MODULE$.$conforms());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$1(scala.Tuple2 ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$2(scala.Tuple2 ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$_$$anonfun$4(java.lang.String )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> enumeration(Seq<String> cases) {
        return new CodecVisitor.Codec<Value>(cases){
            private final String[] caseList;
            private final Map caseMap;
            {
                this.caseList = (String[])((IterableOnceOps)cases$2.map(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$3)).toArray(ClassTag$.MODULE$.apply(String.class));
                this.caseMap = ((IterableOnceOps)((IterableOps)cases$2.map(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$4)).zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public Object toDynamicValue(Value v, Map x$2) {
                String key$proxy2 = v.str();
                return BoxesRunTime.boxToInteger((int)DynamicValue$.MODULE$.Enumeration(BoxesRunTime.unboxToInt((Object)this.caseMap.getOrElse((Object)key$proxy2, () -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$toDynamicValue$$anonfun$2(key$proxy2)))));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                int ix$proxy1 = DynamicValue$.MODULE$.enumeration(dv);
                if (ix$proxy1 >= this.caseList.length) {
                    throw new Exception("Unexpected case: " + ix$proxy1);
                }
                return Str$.MODULE$.apply(this.caseList[ix$proxy1]);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$3(java.lang.String ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$4(java.lang.String ), com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$toDynamicValue$$anonfun$2(java.lang.String )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> list(CodecVisitor.Codec<Value> elem) {
        return new CodecVisitor.Codec<Value>(elem){
            private final CodecVisitor.Codec elem$1;
            {
                this.elem$1 = elem$6;
            }

            public Object toDynamicValue(Value v2, Map x$2) {
                return DynamicValue$.MODULE$.List((IterableOnce)v2.arr().view().map((Function1 & Serializable)v -> this.elem$1.toDynamicValue(v, x$2)));
            }

            public Value fromDynamicValue(Object dv2, Map x$2) {
                return Arr$.MODULE$.apply(ArrayBuffer$.MODULE$.from((IterableOnce)DynamicValue$.MODULE$.list(dv2).iterator().map((Function1 & Serializable)dv -> (Value)this.elem$1.fromDynamicValue(dv, x$2))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{toDynamicValue$$anonfun$3(scala.collection.immutable.Map ujson.Value ), fromDynamicValue$$anonfun$2(scala.collection.immutable.Map java.lang.Object )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> optional(CodecVisitor.Codec<Value> elem) {
        return new OptionalProcessor(this, elem);
    }

    public CodecVisitor.Codec<Value> textMap(CodecVisitor.Codec<Value> value) {
        return new CodecVisitor.Codec<Value>(value){
            private final CodecVisitor.Codec value$1;
            {
                this.value$1 = value$3;
            }

            public Object toDynamicValue(Value v2, Map x$2) {
                return DynamicValue$.MODULE$.TextMap((IterableOnce)Value$.MODULE$.JsonableDict((IterableOnce)v2.obj(), Predef$.MODULE$.$conforms()).value().view().mapValues((Function1 & Serializable)v -> this.value$1.toDynamicValue(v, x$2)));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Obj$.MODULE$.from((IterableOnce)DynamicValue$.MODULE$.textMap(dv).iterator().map((Function1 & Serializable)x$1 -> {
                    String string = (String)x$1._1();
                    Object object = x$1._2();
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)string);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, this.value$1.fromDynamicValue(object, x$2));
                }));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{toDynamicValue$$anonfun$4(scala.collection.immutable.Map ujson.Value ), fromDynamicValue$$anonfun$3(scala.collection.immutable.Map scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> genMap(CodecVisitor.Codec<Value> key, CodecVisitor.Codec<Value> value) {
        return new CodecVisitor.Codec<Value>(key, value){
            private final CodecVisitor.Codec key$1;
            private final CodecVisitor.Codec value$2;
            {
                this.key$1 = key$2;
                this.value$2 = value$4;
            }

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.GenMap((IterableOnce)v.arr().view().map((Function1 & Serializable)e -> {
                    Object object = Predef$.MODULE$.ArrowAssoc(this.key$1.toDynamicValue(e.arr().apply(0), x$2));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, this.value$2.toDynamicValue(e.arr().apply(1), x$2));
                }));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Arr$.MODULE$.from((IterableOnce)DynamicValue$.MODULE$.genMap(dv).iterator().map((Function1 & Serializable)x$1 -> {
                    Object object = x$1._1();
                    Object object2 = x$1._2();
                    return Arr$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[]{(Value)this.key$1.fromDynamicValue(object, x$2), (Value)this.value$2.fromDynamicValue(object2, x$2)}));
                }), Predef$.MODULE$.$conforms());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{toDynamicValue$$anonfun$5(scala.collection.immutable.Map ujson.Value ), fromDynamicValue$$anonfun$4(scala.collection.immutable.Map scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public CodecVisitor.Codec<Value> unit() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.Unit();
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Obj$.MODULE$.apply();
            }
        };
    }

    public CodecVisitor.Codec<Value> bool() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return BoxesRunTime.boxToBoolean((boolean)DynamicValue$.MODULE$.Bool(v.bool()));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Bool$.MODULE$.apply(DynamicValue$.MODULE$.bool(dv));
            }
        };
    }

    public CodecVisitor.Codec<Value> text() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.Text(v.str());
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Str$.MODULE$.apply(DynamicValue$.MODULE$.text(dv));
            }
        };
    }

    public CodecVisitor.Codec<Value> int64() {
        if (this.encodeInt64AsString) {
            return new CodecVisitor.Codec<Value>(){

                public Object toDynamicValue(Value v, Map x$2) {
                    return BoxesRunTime.boxToLong((long)DynamicValue$.MODULE$.Int64(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v.str()))));
                }

                public Value fromDynamicValue(Object dv, Map x$2) {
                    return Str$.MODULE$.apply(String.valueOf(DynamicValue$.MODULE$.int64(dv)));
                }
            };
        }
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return BoxesRunTime.boxToLong((long)DynamicValue$.MODULE$.Int64(Predef$.MODULE$.double2Double(v.num()).longValue()));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Num$.MODULE$.apply((double)DynamicValue$.MODULE$.int64(dv));
            }
        };
    }

    public CodecVisitor.Codec<Value> numeric(int scale) {
        if (this.encodeNumericAsString) {
            return new CodecVisitor.Codec<Value>(){

                public Object toDynamicValue(Value v, Map x$2) {
                    Value value = v;
                    if (value instanceof Num) {
                        Num num = (Num)value;
                        return DynamicValue$.MODULE$.Numeric(BoxesRunTime.boxToDouble((double)num.value()).toString());
                    }
                    if (value instanceof Str) {
                        Str str = (Str)value;
                        return DynamicValue$.MODULE$.Numeric(str.value());
                    }
                    throw new IllegalArgumentException(v + " is not a valid numeric value");
                }

                public Value fromDynamicValue(Object dv, Map x$2) {
                    return Str$.MODULE$.apply(DynamicValue$.MODULE$.numeric(dv));
                }
            };
        }
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.Numeric(BoxesRunTime.boxToDouble((double)v.num()).toString());
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Num$.MODULE$.apply(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(DynamicValue$.MODULE$.numeric(dv))));
            }
        };
    }

    public CodecVisitor.Codec<Value> party() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.Party(v.str());
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Str$.MODULE$.apply(DynamicValue$.MODULE$.party(dv));
            }
        };
    }

    public CodecVisitor.Codec<Value> timestamp() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                ZonedDateTime time = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)v.str(), JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$17$$_$_$$anonfun$5);
                return BoxesRunTime.boxToLong((long)DynamicValue$.MODULE$.Timestamp(time.toEpochSecond() * 1000000L + (long)(time.getNano() / 1000)));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                ZonedDateTime time = LocalDateTime.ofEpochSecond(DynamicValue$.MODULE$.timestamp(dv) / 1000000L, 0, ZoneOffset.UTC).plusNanos(DynamicValue$.MODULE$.timestamp(dv) % 1000000L * 1000L).atZone(ZoneOffset.UTC);
                return Str$.MODULE$.apply(DateTimeFormatter.ISO_DATE_TIME.format(time));
            }
        };
    }

    public CodecVisitor.Codec<Value> date() {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return BoxesRunTime.boxToInteger((int)DynamicValue$.MODULE$.Date(Predef$.MODULE$.long2Long(DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)v.str(), JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$$anon$18$$_$toDynamicValue$$anonfun$6).toEpochDay()).intValue()));
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Str$.MODULE$.apply(DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.ofEpochDay(Predef$.MODULE$.int2Integer(DynamicValue$.MODULE$.date(dv)).longValue())));
            }
        };
    }

    public CodecVisitor.Codec<Value> contractId(CodecVisitor.Codec<Value> template) {
        return new CodecVisitor.Codec<Value>(){

            public Object toDynamicValue(Value v, Map x$2) {
                return DynamicValue$.MODULE$.ContractId(v.str());
            }

            public Value fromDynamicValue(Object dv, Map x$2) {
                return Str$.MODULE$.apply(DynamicValue$.MODULE$.contractId(dv));
            }
        };
    }

    public static final /* synthetic */ String com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$1(Tuple2 _$1) {
        return (String)_$1._1();
    }

    private static final Value $anonfun$2$$anonfun$1() {
        return Null$.MODULE$;
    }

    public static final /* synthetic */ Object com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$2(LinkedHashMap valueMap$1, Map x$2$2, Tuple2 x$1) {
        String string = (String)x$1._1();
        CodecVisitor.Codec codec = (CodecVisitor.Codec)x$1._2();
        return codec.toDynamicValue(valueMap$1.getOrElse((Object)string, JsonCodec::$anonfun$2$$anonfun$1), x$2$2);
    }

    public static final /* synthetic */ boolean com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$toDynamicValue$$anonfun$1(Object _$2) {
        return DynamicValue$.MODULE$.isEmpty(_$2);
    }

    public static final /* synthetic */ Tuple2 com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$_$$anonfun$3(Map x$2$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            Object f = tuple2._1();
            if (tuple22 != null) {
                String name = (String)tuple22._1();
                CodecVisitor.Codec c = (CodecVisitor.Codec)tuple22._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, c.fromDynamicValue(f, x$2$3));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean com$digitalasset$transcode$codec$json$JsonCodec$$anon$1$$_$fromDynamicValue$$anonfun$1(Tuple2 x$1) {
        String string = (String)x$1._1();
        Value value = (Value)x$1._2();
        return value.isNull();
    }

    public static final /* synthetic */ Tuple2 com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$1(Tuple2 x$1) {
        String string = (String)x$1._1();
        CodecVisitor.Codec codec = (CodecVisitor.Codec)x$1._2();
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.variantConName(string));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)codec);
    }

    public static final /* synthetic */ Tuple2 com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$$lessinit$greater$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x$1;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
            String n = (String)tuple2._1();
            CodecVisitor.Codec c = (CodecVisitor.Codec)tuple2._2();
            int ix = BoxesRunTime.unboxToInt((Object)tuple22._2());
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.variantConName(n));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ix), (Object)c));
        }
        throw new MatchError((Object)tuple22);
    }

    public static final Tuple2 com$digitalasset$transcode$codec$json$JsonCodec$$anon$4$$_$_$$anonfun$4(String key$proxy1$1) {
        throw new Exception("Unexpected case: " + key$proxy1$1);
    }

    public static final /* synthetic */ String com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$3(String _$4) {
        return package$.MODULE$.enumConName(_$4);
    }

    public static final /* synthetic */ String com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$$lessinit$greater$$anonfun$4(String _$5) {
        return package$.MODULE$.enumConName(_$5);
    }

    public static final int com$digitalasset$transcode$codec$json$JsonCodec$$anon$5$$_$toDynamicValue$$anonfun$2(String key$proxy2$1) {
        throw new Exception("Unexpected case: " + key$proxy2$1);
    }

    public static final Value com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueSimple$$anonfun$1() {
        return Null$.MODULE$;
    }

    public static final Arr com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNested$$anonfun$1() {
        return Arr$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[0]));
    }

    public static final /* synthetic */ Object com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$toDynamicValueNext$$anonfun$1(OptionalProcessor elem$2, Map x$2$8, Value v) {
        return elem$2.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$toDynamicValueNested(v, (Map<String, CodecVisitor.Decoder<Value>>)x$2$8);
    }

    public static final /* synthetic */ Object com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$toDynamicValueNext$$anonfun$2(CodecVisitor.Codec elem$3, Map x$2$9, Value v) {
        return elem$3.toDynamicValue((Object)v, x$2$9);
    }

    public static final /* synthetic */ Value com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNext$$anonfun$1(OptionalProcessor elem$4, Map x$2$10, Object dv) {
        return elem$4.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$fromDynamicValueNested(dv, (Map<String, CodecVisitor.Encoder<Value>>)x$2$10);
    }

    public static final /* synthetic */ Value com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNext$$anonfun$2(CodecVisitor.Codec elem$5, Map x$2$11, Object dv) {
        return (Value)elem$5.fromDynamicValue(dv, x$2$11);
    }

    public static final /* synthetic */ ZonedDateTime com$digitalasset$transcode$codec$json$JsonCodec$$anon$17$$_$_$$anonfun$5(TemporalAccessor x$0) {
        return ZonedDateTime.from(x$0);
    }

    public static final /* synthetic */ LocalDate com$digitalasset$transcode$codec$json$JsonCodec$$anon$18$$_$toDynamicValue$$anonfun$6(TemporalAccessor x$0) {
        return LocalDate.from(x$0);
    }

    public class OptionalProcessor
    implements CodecVisitor.Codec<Value> {
        private final CodecVisitor.Codec<Value> elem;
        private final /* synthetic */ JsonCodec $outer;

        public OptionalProcessor(JsonCodec $outer, CodecVisitor.Codec<Value> elem) {
            this.elem = elem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public boolean isOptional(Map<String, CodecVisitor.Decoder<Value>> x$1) {
            return true;
        }

        public Object toDynamicValue(Value v, Map<String, CodecVisitor.Decoder<Value>> x$2) {
            CodecVisitor.Codec<Value> codec = this.elem;
            if (codec instanceof OptionalProcessor && ((OptionalProcessor)codec).com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$$outer() == this.$outer) {
                return this.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$toDynamicValueNested(v, x$2);
            }
            return this.toDynamicValueSimple(v, x$2);
        }

        public Value fromDynamicValue(Object dv, Map<String, CodecVisitor.Encoder<Value>> x$2) {
            CodecVisitor.Codec<Value> codec = this.elem;
            if (codec instanceof OptionalProcessor && ((OptionalProcessor)codec).com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$$outer() == this.$outer) {
                return this.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$fromDynamicValueNested(dv, x$2);
            }
            return this.fromDynamicValueSimple(dv, x$2);
        }

        private Object toDynamicValueSimple(Value v, Map<String, CodecVisitor.Decoder<Value>> x$2) {
            return DynamicValue$.MODULE$.Optional((Option)(v.isNull() ? None$.MODULE$ : Some$.MODULE$.apply(this.elem.toDynamicValue((Object)v, x$2))));
        }

        private Value fromDynamicValueSimple(Object dv, Map<String, CodecVisitor.Encoder<Value>> x$2) {
            return (Value)DynamicValue$.MODULE$.optional(dv).fold(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueSimple$$anonfun$1, (Function1 & Serializable)v -> (Value)this.elem.fromDynamicValue(v, x$2));
        }

        public Object com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$toDynamicValueNested(Value v, Map<String, CodecVisitor.Decoder<Value>> x$2) {
            return DynamicValue$.MODULE$.Optional((Option)(v.arr().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.toDynamicValueNext(this.elem, x$2).apply(v.arr().apply(0)))));
        }

        public Value com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$fromDynamicValueNested(Object dv, Map<String, CodecVisitor.Encoder<Value>> x$2) {
            return (Value)DynamicValue$.MODULE$.optional(dv).fold(JsonCodec::com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNested$$anonfun$1, (Function1 & Serializable)v -> Arr$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value[]{(Value)this.fromDynamicValueNext(this.elem, x$2).apply(v)})));
        }

        private Function1<Value, Object> toDynamicValueNext(CodecVisitor.Codec<Value> e, Map<String, CodecVisitor.Decoder<Value>> x$2) {
            CodecVisitor.Codec<Value> codec = e;
            if (codec instanceof OptionalProcessor && ((OptionalProcessor)codec).com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$$outer() == this.$outer) {
                OptionalProcessor elem = (OptionalProcessor)codec;
                return arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$toDynamicValueNext$$anonfun$1(elem, x$2, arg_0);
            }
            CodecVisitor.Codec<Value> elem = codec;
            return arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$toDynamicValueNext$$anonfun$2(elem, x$2, arg_0);
        }

        private Function1<Object, Value> fromDynamicValueNext(CodecVisitor.Codec<Value> e, Map<String, CodecVisitor.Encoder<Value>> x$2) {
            CodecVisitor.Codec<Value> codec = e;
            if (codec instanceof OptionalProcessor && ((OptionalProcessor)codec).com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$$outer() == this.$outer) {
                OptionalProcessor elem = (OptionalProcessor)codec;
                return arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNext$$anonfun$1(elem, x$2, arg_0);
            }
            CodecVisitor.Codec<Value> elem = codec;
            return arg_0 -> JsonCodec.com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$_$fromDynamicValueNext$$anonfun$2(elem, x$2, arg_0);
        }

        public final /* synthetic */ JsonCodec com$digitalasset$transcode$codec$json$JsonCodec$OptionalProcessor$$$outer() {
            return this.$outer;
        }
    }
}

