// Copyright (c) 2024, Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
// SPDX-License-Identifier: Apache-2.0

package com.digitalasset.transcode.codegen

import com.digitalasset.transcode.schema.SchemaVisitor

/** Base type for code generators.
  *
  * Define potentially mutable [[Context]] to store compilation units during schema traversal. Be aware that schema
  * cases can be called multiple types in case of recursive definitions in daml model.
  *
  * Instances of codegen visitors can be shared and reused. Any state should be stored in transient [[Context]]
  * instances only
  *
  * Note that [[Type]] and [[Result]] are
  * [[https://docs.scala-lang.org/scala3/reference/contextual/context-functions.html Context Functions]] which provide
  * implicit [[Context]] instance in every handler method.
  */
trait CodegenVisitor extends SchemaVisitor {
  final type Type   = Context ?=> CodeUnit
  final type Result = Context ?=> Map[os.RelPath, String]

  // Implement:
  type Context
  type CodeUnit
  def createContext: Context

  protected final def ctx(using ctx: Context): Context = ctx
}
