// Copyright (c) 2025, Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.

package com.digitalasset.transcode

import com.digitalasset.transcode.schema.Identifier

import java.util.jar.Attributes.Name.IMPLEMENTATION_VERSION
import java.util.jar.Manifest
import scala.util.Using

package object codegen:
  extension (id: Identifier)
    def canonicalPackageName: String = id match
      case Identifier(packageId, packageName, _, "DA.Internal.Template", _) if packageId == packageName =>
        "ghc-stdlib-DA-Internal-Template"
      case Identifier(packageId, packageName, _, _, _) if packageId == packageName =>
        "da-internal"
      case _ =>
        id.packageName

  extension (path: os.RelPath)
    def setExtension(ext: String): os.RelPath =
      if path.ext == ext
      then path
      else path / os.up / s"${path.last.dropRight(path.ext.length)}.$ext"

  def ImplementationVersion: String = Using
    .apply(Thread.currentThread().getContextClassLoader.getResourceAsStream("META-INF/MANIFEST.MF"))(Manifest(_))
    .get
    .getMainAttributes
    .getValue(IMPLEMENTATION_VERSION)
