/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.transcode.java;

import com.digitalasset.transcode.java.ContractId;
import com.digitalasset.transcode.java.Party;
import com.digitalasset.transcode.java.Unit;
import com.digitalasset.transcode.schema.DynamicValue;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.convert.JavaCollectionWrappers;

public class JavaConverters {
    public static Function<Object, Unit> fromUnit = object -> Unit.UNIT;
    public static Function<Unit, Object> toUnit = unit -> DynamicValue.Unit();
    public static Function<Object, Boolean> fromBool = object -> DynamicValue.bool((Object)object);
    public static Function<Boolean, Object> toBool = bl -> DynamicValue.Bool((boolean)bl);
    public static Function<Object, String> fromText = object -> DynamicValue.text((Object)object);
    public static Function<String, Object> toText = string -> DynamicValue.Text((String)string);
    public static Function<Object, Long> fromInt64 = object -> DynamicValue.int64((Object)object);
    public static Function<Long, Object> toInt64 = l -> DynamicValue.Int64((long)l);
    public static Function<Object, Instant> fromTimestamp = object -> Instant.ofEpochSecond(DynamicValue.timestamp((Object)object) / 1000000L, DynamicValue.timestamp((Object)object) % 1000000L * 1000L);
    public static Function<Instant, Object> toTimestamp = instant -> DynamicValue.Timestamp((long)(instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000)));
    public static Function<Object, LocalDate> fromDate = object -> LocalDate.ofEpochDay(DynamicValue.date((Object)object));
    public static Function<LocalDate, Object> toDate = localDate -> DynamicValue.Date((int)((int)localDate.toEpochDay()));
    public static Function<Object, Party> fromParty = object -> new Party(DynamicValue.party((Object)object));
    public static Function<Party, Object> toParty = party -> DynamicValue.Party((String)party.getParty);

    public static Function<Object, BigDecimal> fromNumeric(int n) {
        return object -> new BigDecimal(DynamicValue.numeric((Object)object)).setScale(n);
    }

    public static Function<BigDecimal, Object> toNumeric(int n) {
        return bigDecimal -> DynamicValue.Numeric((String)bigDecimal.setScale(n).toPlainString());
    }

    public static <A> Function<Object, ContractId<A>> fromContractId(Function<Object, A> function) {
        return object -> new ContractId(DynamicValue.contractId((Object)object));
    }

    public static <A> Function<ContractId<A>, Object> toContractId(Function<A, Object> function) {
        return contractId -> DynamicValue.ContractId((String)contractId.getContractId);
    }

    public static <A> Function<Object, List<A>> fromList(Function<Object, A> function) {
        return object -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(new JavaCollectionWrappers.IteratorWrapper(DynamicValue.list((Object)object).iterator()), 16), false).map(function).collect(Collectors.toList());
    }

    public static <A> Function<List<A>, Object> toList(Function<A, Object> function) {
        return list -> DynamicValue.List((IterableOnce)new JavaCollectionWrappers.JIteratorWrapper(list.stream().map(function).iterator()));
    }

    public static <A> Function<Object, Optional<A>> fromOptional(Function<Object, A> function) {
        return object2 -> (Optional)DynamicValue.optional((Object)object2).fold(() -> Optional.empty(), object -> Optional.of(function.apply(object)));
    }

    public static <A> Function<Optional<A>, Object> toOptional(Function<A, Object> function) {
        return optional -> DynamicValue.Optional((Option)optional.map(object -> Some.apply(function.apply(object))).orElse(Option.empty()));
    }

    public static <A> Function<Object, java.util.Map<String, A>> fromTextMap(Function<Object, A> function) {
        return object -> new JavaCollectionWrappers.MapWrapper((Map)scala.collection.immutable.Map.from((IterableOnce)DynamicValue.textMap((Object)object).iterator().map(tuple2 -> tuple2.copy((Object)((String)tuple2._1), function.apply(tuple2._2)))));
    }

    public static <A> Function<java.util.Map<String, A>, Object> toTextMap(Function<A, Object> function) {
        return map -> DynamicValue.TextMap((IterableOnce)new JavaCollectionWrappers.JMapWrapper(map).view().mapValues(object -> function.apply(object)));
    }

    public static <K, V> Function<Object, java.util.Map<K, V>> fromGenMap(Function<Object, K> function, Function<Object, V> function2) {
        return object -> new JavaCollectionWrappers.MapWrapper((Map)scala.collection.immutable.Map.from((IterableOnce)DynamicValue.genMap((Object)object).iterator().map(tuple2 -> tuple2.copy(function.apply(tuple2._1), function2.apply(tuple2._2)))));
    }

    public static <K, V> Function<java.util.Map<K, V>, Object> toGenMap(Function<K, Object> function, Function<V, Object> function2) {
        return map -> DynamicValue.GenMap((IterableOnce)new JavaCollectionWrappers.JMapWrapper(map).map(tuple2 -> tuple2.copy(function.apply(tuple2._1), function2.apply(tuple2._2))));
    }

    public static <T> T err(String string) {
        throw new IllegalArgumentException(string);
    }

    public static <A> Function<Object, A> fromArchive(Supplier<A> supplier) {
        return object -> supplier.get();
    }

    public static <A> Function<A, Object> toArchive() {
        return object -> DynamicValue.Record((Object[])new Object[0]);
    }
}

