/*
 * Decompiled with CFR 0.152.
 */
package com.darrinholst.sass_java;

import com.darrinholst.sass_java.Clock;
import com.darrinholst.sass_java.Compiler;
import com.darrinholst.sass_java.Config;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SassCompilingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SassCompilingFilter.class);
    private static final int DWELL = 1000;
    protected static final String RETHROW_EXCEPTIONS_PARAM = "rethrowExceptions";
    protected static final String ONLY_RUN_KEY_PARAM = "onlyRunWhenKey";
    protected static final String ONLY_RUN_VALUE_PARAM = "onlyRunWhenValue";
    protected static final String CONFIG_LOCATION_PARAM = "configLocation";
    protected static final String DEFAULT_CONFIG_LOCATION = "WEB-INF" + File.separator + "sass" + File.separator + "config.rb";
    private long lastRun;
    private String onlyRunWhenKey;
    private String onlyRunWhenValue;
    private boolean rethrowExceptions;
    private Compiler compiler = new Compiler();
    private AtomicBoolean compiling = new AtomicBoolean(false);

    public void init(FilterConfig filterConfig) throws ServletException {
        Config config = new Config(filterConfig);
        this.onlyRunWhenKey = config.getString(ONLY_RUN_KEY_PARAM);
        this.onlyRunWhenValue = config.getString(ONLY_RUN_VALUE_PARAM);
        this.rethrowExceptions = config.getBoolean(RETHROW_EXCEPTIONS_PARAM, false);
        this.compiler.setConfigLocation(new File(config.getRootPath(), config.getString(CONFIG_LOCATION_PARAM, DEFAULT_CONFIG_LOCATION)));
        if (this.environmentAllowsRunning()) {
            this.compiler.compile();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.shouldRun()) {
            this.run();
        }
        while (this.compiling.get()) {
            this.waitABit();
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void waitABit() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        LOG.debug("compiling sass");
        try {
            this.compiling.set(true);
            this.compiler.compile();
        }
        catch (Exception e) {
            LOG.warn("exception thrown while compiling sass", (Throwable)e);
            if (this.rethrowExceptions) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.compiling.set(false);
        }
    }

    private boolean shouldRun() {
        return !this.compiling.get() && this.environmentAllowsRunning() && this.timeToRun();
    }

    private boolean environmentAllowsRunning() {
        if (this.onlyRunWhenKey != null) {
            String value = System.getProperty(this.onlyRunWhenKey, System.getenv(this.onlyRunWhenKey));
            return this.onlyRunWhenValue.equalsIgnoreCase(value);
        }
        return true;
    }

    private synchronized boolean timeToRun() {
        long now = Clock.now().getTime();
        if (now - this.lastRun >= 1000L) {
            this.lastRun = Clock.now().getTime();
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }
}

