/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.CliTokenSource;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.utils.AzureUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureCliCredentialsProvider
implements CredentialsProvider,
AzureUtils {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(AzureCliCredentialsProvider.class);
    public static final String AZURE_CLI = "azure-cli";

    @Override
    public String authType() {
        return AZURE_CLI;
    }

    @Override
    public CliTokenSource tokenSourceFor(DatabricksConfig config, String resource) {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("az", "account", "get-access-token", "--resource", resource, "--output", "json"));
        return new CliTokenSource(cmd, "tokenType", "accessToken", "expiresOn", config::getAllEnv);
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure()) {
            return null;
        }
        try {
            this.ensureHostPresent(config, this.mapper);
            String resource = config.getEffectiveAzureLoginAppId();
            CliTokenSource tokenSource = this.tokenSourceFor(config, resource);
            tokenSource.getToken();
            return () -> {
                Token token = tokenSource.getToken();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
                return headers;
            };
        }
        catch (DatabricksException e) {
            String stderr = e.getMessage();
            if (stderr.contains("not found")) {
                String doc = "https://docs.microsoft.com/en-us/cli/azure/?view=azure-cli-latest";
                LOG.info(String.format("Most likely Azure CLI is not installed. See %s for details", doc));
                return null;
            }
            throw e;
        }
    }
}

