/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.error;

import com.databricks.sdk.core.DatabricksError;
import com.databricks.sdk.core.error.ApiErrorBody;
import com.databricks.sdk.core.http.Response;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiErrors {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern HTML_ERROR_REGEX = Pattern.compile("<pre>(.*)</pre>");

    public static DatabricksError checkForRetry(Response out, Exception error) {
        if (error != null) {
            return new DatabricksError("IO_ERROR", 523, error);
        }
        if (out.getStatusCode() == 429) {
            return new DatabricksError("TOO_MANY_REQUESTS", "Current request has to be retried", 429);
        }
        if (out.getStatusCode() >= 400) {
            return ApiErrors.readErrorFromResponse(out);
        }
        return new DatabricksError(out.getStatusCode());
    }

    private static DatabricksError readErrorFromResponse(Response response) {
        ApiErrorBody errorBody = ApiErrors.parseApiError(response);
        if (errorBody.getApi12Error() != null && !errorBody.getApi12Error().isEmpty()) {
            errorBody.setMessage(errorBody.getApi12Error());
        }
        if (errorBody.getMessage() == null || errorBody.getMessage().isEmpty()) {
            if (errorBody.getScimDetail() != null && !"null".equals(errorBody.getScimDetail())) {
                errorBody.setMessage(errorBody.getScimDetail());
            } else {
                errorBody.setMessage("SCIM API Internal Error");
            }
            String message = errorBody.getScimType() + " " + errorBody.getMessage();
            errorBody.setMessage(message.trim());
            errorBody.setErrorCode("SCIM_" + errorBody.getScimStatus());
        }
        return new DatabricksError(errorBody.getErrorCode(), errorBody.getMessage(), response.getStatusCode());
    }

    private static ApiErrorBody parseApiError(Response response) {
        try {
            return (ApiErrorBody)MAPPER.readValue(response.getBody(), ApiErrorBody.class);
        }
        catch (IOException e) {
            return ApiErrors.parseUnknownError(response, e);
        }
    }

    private static ApiErrorBody parseUnknownError(Response response, IOException err) {
        ApiErrorBody errorBody = new ApiErrorBody();
        String[] statusParts = response.getStatus().split(" ", 2);
        if (statusParts.length < 2) {
            errorBody.setErrorCode("UNKNOWN");
        } else {
            String errorCode = statusParts[1].replaceAll("^[ .]+|[ .]+$", "");
            errorBody.setErrorCode(errorCode.replaceAll(" ", "_").toUpperCase());
        }
        Matcher messageMatcher = HTML_ERROR_REGEX.matcher(response.getBody());
        if (messageMatcher.find()) {
            errorBody.setMessage(messageMatcher.group(1).replaceAll("^[ .]+|[ .]+$", ""));
        } else {
            errorBody.setMessage(String.format("Response from server (%s) %s: %s", response.getStatus(), response.getBody(), err.getMessage()));
        }
        return errorBody;
    }
}

