/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.AccountsCreateMetastore;
import com.databricks.sdk.service.catalog.AccountsMetastoreInfo;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastore;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.support.Generated;

@Generated
class AccountMetastoresImpl
implements AccountMetastoresService {
    private final ApiClient apiClient;

    public AccountMetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountsMetastoreInfo create(AccountsCreateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, AccountsMetastoreInfo.class);
    }

    @Override
    public void delete(DeleteAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public AccountsMetastoreInfo get(GetAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.GET(path, request, AccountsMetastoreInfo.class);
    }

    @Override
    public ListMetastoresResponse list() {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        return this.apiClient.GET(path, ListMetastoresResponse.class);
    }

    @Override
    public AccountsMetastoreInfo update(AccountsUpdateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.PUT(path, request, AccountsMetastoreInfo.class);
    }
}

