/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.catalog.AccountsCreateStorageCredential;
import com.databricks.sdk.service.catalog.AccountsUpdateStorageCredential;
import com.databricks.sdk.service.catalog.DeleteAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.ListStorageCredentialsResponse;
import com.databricks.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.sdk.support.Generated;

@Generated
class AccountStorageCredentialsImpl
implements AccountStorageCredentialsService {
    private final ApiClient apiClient;

    public AccountStorageCredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public StorageCredentialInfo create(AccountsCreateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.POST(path, request, StorageCredentialInfo.class);
    }

    @Override
    public void delete(DeleteAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/", this.apiClient.configuredAccountID(), request.getMetastoreId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public StorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.GET(path, request, StorageCredentialInfo.class);
    }

    @Override
    public ListStorageCredentialsResponse list(ListAccountStorageCredentialsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.GET(path, request, ListStorageCredentialsResponse.class);
    }

    @Override
    public StorageCredentialInfo update(AccountsUpdateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.PUT(path, request, StorageCredentialInfo.class);
    }
}

