/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.CancelCommand;
import com.databricks.sdk.service.compute.Command;
import com.databricks.sdk.service.compute.CommandExecutionImpl;
import com.databricks.sdk.service.compute.CommandExecutionService;
import com.databricks.sdk.service.compute.CommandStatus;
import com.databricks.sdk.service.compute.CommandStatusRequest;
import com.databricks.sdk.service.compute.CommandStatusResponse;
import com.databricks.sdk.service.compute.ContextStatus;
import com.databricks.sdk.service.compute.ContextStatusRequest;
import com.databricks.sdk.service.compute.ContextStatusResponse;
import com.databricks.sdk.service.compute.CreateContext;
import com.databricks.sdk.service.compute.Created;
import com.databricks.sdk.service.compute.DestroyContext;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CommandExecutionAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CommandExecutionAPI.class);
    private final CommandExecutionService impl;

    public CommandExecutionAPI(ApiClient apiClient) {
        this.impl = new CommandExecutionImpl(apiClient);
    }

    public CommandExecutionAPI(CommandExecutionService mock) {
        this.impl = mock;
    }

    public CommandStatusResponse waitCommandStatusCommandExecutionCancelled(String clusterId, String commandId, String contextId) throws TimeoutException {
        return this.waitCommandStatusCommandExecutionCancelled(clusterId, commandId, contextId, Duration.ofMinutes(20L), null);
    }

    public CommandStatusResponse waitCommandStatusCommandExecutionCancelled(String clusterId, String commandId, String contextId, Duration timeout, Consumer<CommandStatusResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<CommandStatus> targetStates = Arrays.asList(CommandStatus.CANCELLED);
        List<CommandStatus> failureStates = Arrays.asList(CommandStatus.ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            CommandStatusResponse poll = this.commandStatus(new CommandStatusRequest().setClusterId(clusterId).setCommandId(commandId).setContextId(contextId));
            CommandStatus status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getResults() != null) {
                statusMessage = poll.getResults().getCause();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach CANCELLED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("clusterId=%s, commandId=%s, contextId=%s", clusterId, commandId, contextId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public CommandStatusResponse waitCommandStatusCommandExecutionFinishedOrError(String clusterId, String commandId, String contextId) throws TimeoutException {
        return this.waitCommandStatusCommandExecutionFinishedOrError(clusterId, commandId, contextId, Duration.ofMinutes(20L), null);
    }

    public CommandStatusResponse waitCommandStatusCommandExecutionFinishedOrError(String clusterId, String commandId, String contextId, Duration timeout, Consumer<CommandStatusResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<CommandStatus> targetStates = Arrays.asList(CommandStatus.FINISHED, CommandStatus.ERROR);
        List<CommandStatus> failureStates = Arrays.asList(CommandStatus.CANCELLED, CommandStatus.CANCELLING);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            CommandStatusResponse poll = this.commandStatus(new CommandStatusRequest().setClusterId(clusterId).setCommandId(commandId).setContextId(contextId));
            CommandStatus status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach FINISHED or ERROR, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("clusterId=%s, commandId=%s, contextId=%s", clusterId, commandId, contextId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public ContextStatusResponse waitContextStatusCommandExecutionRunning(String clusterId, String contextId) throws TimeoutException {
        return this.waitContextStatusCommandExecutionRunning(clusterId, contextId, Duration.ofMinutes(20L), null);
    }

    public ContextStatusResponse waitContextStatusCommandExecutionRunning(String clusterId, String contextId, Duration timeout, Consumer<ContextStatusResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<ContextStatus> targetStates = Arrays.asList(ContextStatus.RUNNING);
        List<ContextStatus> failureStates = Arrays.asList(ContextStatus.ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            ContextStatusResponse poll = this.contextStatus(new ContextStatusRequest().setClusterId(clusterId).setContextId(contextId));
            ContextStatus status = poll.getStatus();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach RUNNING, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("clusterId=%s, contextId=%s", clusterId, contextId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<CommandStatusResponse, Void> cancel(CancelCommand request) {
        this.impl.cancel(request);
        return new Wait<CommandStatusResponse, Void>((timeout, callback) -> this.waitCommandStatusCommandExecutionCancelled(request.getClusterId(), request.getCommandId(), request.getContextId(), timeout, callback));
    }

    public CommandStatusResponse commandStatus(String clusterId, String contextId, String commandId) {
        return this.commandStatus(new CommandStatusRequest().setClusterId(clusterId).setContextId(contextId).setCommandId(commandId));
    }

    public CommandStatusResponse commandStatus(CommandStatusRequest request) {
        return this.impl.commandStatus(request);
    }

    public ContextStatusResponse contextStatus(String clusterId, String contextId) {
        return this.contextStatus(new ContextStatusRequest().setClusterId(clusterId).setContextId(contextId));
    }

    public ContextStatusResponse contextStatus(ContextStatusRequest request) {
        return this.impl.contextStatus(request);
    }

    public Wait<ContextStatusResponse, Created> create(CreateContext request) {
        Created response = this.impl.create(request);
        return new Wait<ContextStatusResponse, Created>((timeout, callback) -> this.waitContextStatusCommandExecutionRunning(request.getClusterId(), response.getId(), timeout, callback), response);
    }

    public void destroy(String clusterId, String contextId) {
        this.destroy(new DestroyContext().setClusterId(clusterId).setContextId(contextId));
    }

    public void destroy(DestroyContext request) {
        this.impl.destroy(request);
    }

    public Wait<CommandStatusResponse, Created> execute(Command request) {
        Created response = this.impl.execute(request);
        return new Wait<CommandStatusResponse, Created>((timeout, callback) -> this.waitCommandStatusCommandExecutionFinishedOrError(request.getClusterId(), response.getId(), request.getContextId(), timeout, callback), response);
    }

    public CommandExecutionService impl() {
        return this.impl;
    }
}

