/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.CreateInstancePool;
import com.databricks.sdk.service.compute.CreateInstancePoolResponse;
import com.databricks.sdk.service.compute.DeleteInstancePool;
import com.databricks.sdk.service.compute.EditInstancePool;
import com.databricks.sdk.service.compute.GetInstancePool;
import com.databricks.sdk.service.compute.GetInstancePoolRequest;
import com.databricks.sdk.service.compute.InstancePoolAndStats;
import com.databricks.sdk.service.compute.InstancePoolsImpl;
import com.databricks.sdk.service.compute.InstancePoolsService;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class InstancePoolsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(InstancePoolsAPI.class);
    private final InstancePoolsService impl;

    public InstancePoolsAPI(ApiClient apiClient) {
        this.impl = new InstancePoolsImpl(apiClient);
    }

    public InstancePoolsAPI(InstancePoolsService mock) {
        this.impl = mock;
    }

    public CreateInstancePoolResponse create(String instancePoolName, String nodeTypeId) {
        return this.create(new CreateInstancePool().setInstancePoolName(instancePoolName).setNodeTypeId(nodeTypeId));
    }

    public CreateInstancePoolResponse create(CreateInstancePool request) {
        return this.impl.create(request);
    }

    public void delete(String instancePoolId) {
        this.delete(new DeleteInstancePool().setInstancePoolId(instancePoolId));
    }

    public void delete(DeleteInstancePool request) {
        this.impl.delete(request);
    }

    public void edit(String instancePoolId, String instancePoolName, String nodeTypeId) {
        this.edit(new EditInstancePool().setInstancePoolId(instancePoolId).setInstancePoolName(instancePoolName).setNodeTypeId(nodeTypeId));
    }

    public void edit(EditInstancePool request) {
        this.impl.edit(request);
    }

    public GetInstancePool get(String instancePoolId) {
        return this.get(new GetInstancePoolRequest().setInstancePoolId(instancePoolId));
    }

    public GetInstancePool get(GetInstancePoolRequest request) {
        return this.impl.get(request);
    }

    public Iterable<InstancePoolAndStats> list() {
        return this.impl.list().getInstancePools();
    }

    public InstancePoolsService impl() {
        return this.impl;
    }
}

