/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.CreateFeatureRequest;
import com.databricks.sdk.service.ml.CreateMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.DeleteFeatureRequest;
import com.databricks.sdk.service.ml.DeleteMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.Feature;
import com.databricks.sdk.service.ml.FeatureEngineeringImpl;
import com.databricks.sdk.service.ml.FeatureEngineeringService;
import com.databricks.sdk.service.ml.GetFeatureRequest;
import com.databricks.sdk.service.ml.GetMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.ListFeaturesRequest;
import com.databricks.sdk.service.ml.ListFeaturesResponse;
import com.databricks.sdk.service.ml.ListMaterializedFeaturesRequest;
import com.databricks.sdk.service.ml.ListMaterializedFeaturesResponse;
import com.databricks.sdk.service.ml.MaterializedFeature;
import com.databricks.sdk.service.ml.UpdateFeatureRequest;
import com.databricks.sdk.service.ml.UpdateMaterializedFeatureRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FeatureEngineeringAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureEngineeringAPI.class);
    private final FeatureEngineeringService impl;

    public FeatureEngineeringAPI(ApiClient apiClient) {
        this.impl = new FeatureEngineeringImpl(apiClient);
    }

    public FeatureEngineeringAPI(FeatureEngineeringService mock) {
        this.impl = mock;
    }

    public Feature createFeature(CreateFeatureRequest request) {
        return this.impl.createFeature(request);
    }

    public MaterializedFeature createMaterializedFeature(CreateMaterializedFeatureRequest request) {
        return this.impl.createMaterializedFeature(request);
    }

    public void deleteFeature(String fullName) {
        this.deleteFeature(new DeleteFeatureRequest().setFullName(fullName));
    }

    public void deleteFeature(DeleteFeatureRequest request) {
        this.impl.deleteFeature(request);
    }

    public void deleteMaterializedFeature(String materializedFeatureId) {
        this.deleteMaterializedFeature(new DeleteMaterializedFeatureRequest().setMaterializedFeatureId(materializedFeatureId));
    }

    public void deleteMaterializedFeature(DeleteMaterializedFeatureRequest request) {
        this.impl.deleteMaterializedFeature(request);
    }

    public Feature getFeature(String fullName) {
        return this.getFeature(new GetFeatureRequest().setFullName(fullName));
    }

    public Feature getFeature(GetFeatureRequest request) {
        return this.impl.getFeature(request);
    }

    public MaterializedFeature getMaterializedFeature(String materializedFeatureId) {
        return this.getMaterializedFeature(new GetMaterializedFeatureRequest().setMaterializedFeatureId(materializedFeatureId));
    }

    public MaterializedFeature getMaterializedFeature(GetMaterializedFeatureRequest request) {
        return this.impl.getMaterializedFeature(request);
    }

    public Iterable<Feature> listFeatures(ListFeaturesRequest request) {
        return new Paginator(request, this.impl::listFeatures, ListFeaturesResponse::getFeatures, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<MaterializedFeature> listMaterializedFeatures(ListMaterializedFeaturesRequest request) {
        return new Paginator(request, this.impl::listMaterializedFeatures, ListMaterializedFeaturesResponse::getMaterializedFeatures, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Feature updateFeature(UpdateFeatureRequest request) {
        return this.impl.updateFeature(request);
    }

    public MaterializedFeature updateMaterializedFeature(UpdateMaterializedFeatureRequest request) {
        return this.impl.updateMaterializedFeature(request);
    }

    public FeatureEngineeringService impl() {
        return this.impl;
    }
}

