/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.ml.CreateFeatureRequest;
import com.databricks.sdk.service.ml.CreateMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.DeleteFeatureRequest;
import com.databricks.sdk.service.ml.DeleteMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.Feature;
import com.databricks.sdk.service.ml.FeatureEngineeringService;
import com.databricks.sdk.service.ml.GetFeatureRequest;
import com.databricks.sdk.service.ml.GetMaterializedFeatureRequest;
import com.databricks.sdk.service.ml.ListFeaturesRequest;
import com.databricks.sdk.service.ml.ListFeaturesResponse;
import com.databricks.sdk.service.ml.ListMaterializedFeaturesRequest;
import com.databricks.sdk.service.ml.ListMaterializedFeaturesResponse;
import com.databricks.sdk.service.ml.MaterializedFeature;
import com.databricks.sdk.service.ml.UpdateFeatureRequest;
import com.databricks.sdk.service.ml.UpdateMaterializedFeatureRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class FeatureEngineeringImpl
implements FeatureEngineeringService {
    private final ApiClient apiClient;

    public FeatureEngineeringImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Feature createFeature(CreateFeatureRequest request) {
        String path = "/api/2.0/feature-engineering/features";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getFeature()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Feature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MaterializedFeature createMaterializedFeature(CreateMaterializedFeatureRequest request) {
        String path = "/api/2.0/feature-engineering/materialized-features";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getMaterializedFeature()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MaterializedFeature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteFeature(DeleteFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/features/%s", request.getFullName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteMaterializedFeature(DeleteMaterializedFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/materialized-features/%s", request.getMaterializedFeatureId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Feature getFeature(GetFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/features/%s", request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Feature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MaterializedFeature getMaterializedFeature(GetMaterializedFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/materialized-features/%s", request.getMaterializedFeatureId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, MaterializedFeature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListFeaturesResponse listFeatures(ListFeaturesRequest request) {
        String path = "/api/2.0/feature-engineering/features";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListFeaturesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListMaterializedFeaturesResponse listMaterializedFeatures(ListMaterializedFeaturesRequest request) {
        String path = "/api/2.0/feature-engineering/materialized-features";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListMaterializedFeaturesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Feature updateFeature(UpdateFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/features/%s", request.getFullName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getFeature()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Feature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public MaterializedFeature updateMaterializedFeature(UpdateMaterializedFeatureRequest request) {
        String path = String.format("/api/2.0/feature-engineering/materialized-features/%s", request.getMaterializedFeatureId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getMaterializedFeature()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, MaterializedFeature.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

